/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.cdk;

import java.io.BufferedReader;
import java.io.IOException;
import org.jmol.api.ModelAdapter;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.io.ChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.tools.AtomTypeFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;
import org.openscience.cdk.tools.manipulator.SetOfMoleculesManipulator;

public class CdkModelAdapter
extends ModelAdapter {
    public CdkModelAdapter(ModelAdapter.Logger logger) {
        super("CdkModelAdapter", logger);
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader) {
        ChemFile chemFile = null;
        try {
            ChemObjectReader chemObjectReader = null;
            try {
                chemObjectReader = new ReaderFactory().createReader(bufferedReader);
            }
            catch (IOException ex) {
                return "Error determining input format: " + ex;
            }
            if (chemObjectReader == null) {
                return "unrecognized input format";
            }
            chemFile = (ChemFile)chemObjectReader.read(new ChemFile());
        }
        catch (CDKException ex) {
            return "Error reading input:" + ex;
        }
        if (chemFile == null) {
            return "unknown error reading file";
        }
        try {
            AtomTypeFactory factory = AtomTypeFactory.getInstance("jmol_atomtypes.txt");
            AtomContainer atomContainer = ChemFileManipulator.getAllInOneContainer(chemFile);
            Atom[] atoms = atomContainer.getAtoms();
            for (int i = 0; i < atoms.length; ++i) {
                try {
                    factory.configure(atoms[i]);
                    continue;
                }
                catch (CDKException exception) {
                    System.out.println("Could not configure atom: " + atoms[i]);
                }
            }
        }
        catch (ClassNotFoundException exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        catch (IOException exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        return chemFile;
    }

    public String getFileTypeName(Object clientFile) {
        AtomContainer atomContainer = this.getAtomContainer(clientFile);
        if (atomContainer.getAtomCount() > 0 && atomContainer.getAtomAt(0).getProperty("pdb.record") != null) {
            return "pdb";
        }
        return "other";
    }

    public String getModelSetName(Object clientFile) {
        if (clientFile instanceof ChemFile) {
            Object moleculeTitle;
            Object title = ((ChemFile)clientFile).getProperty("Title");
            if (title != null) {
                System.out.println("Setting model name to title");
                return title.toString();
            }
            AtomContainer container = this.getAtomContainer((ChemFile)clientFile);
            if (container != null && (moleculeTitle = container.getProperty("Title")) != null) {
                return moleculeTitle.toString();
            }
        }
        return null;
    }

    private AtomContainer getAtomContainer(Object clientFile) {
        ChemFile chemFile = (ChemFile)clientFile;
        ChemSequence chemSequence = chemFile.getChemSequence(0);
        ChemModel[] chemModels = chemSequence.getChemModels();
        ChemModel chemModel = chemModels[0];
        SetOfMolecules setOfMolecules = chemModel.getSetOfMolecules();
        Crystal crystal = chemModel.getCrystal();
        if (setOfMolecules != null) {
            AtomContainer molecule = SetOfMoleculesManipulator.getAllInOneContainer(setOfMolecules);
            return molecule;
        }
        if (crystal != null) {
            CrystalGeometryTools.fractionalToCartesian(crystal);
            System.out.println(crystal.toString());
            return crystal;
        }
        System.out.println("Cannot display data in model");
        return null;
    }

    public int getEstimatedAtomCount(Object clientFile) {
        return this.getAtomContainer(clientFile).getAtomCount();
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        AtomContainer container = this.getAtomContainer(clientFile);
        if (container instanceof Crystal) {
            Crystal crystal = (Crystal)container;
            double[] notional = CrystalGeometryTools.cartesianToNotional(crystal.getA(), crystal.getB(), crystal.getC());
            float[] fNotional = new float[6];
            for (int i = 0; i < 6; ++i) {
                fNotional[i] = (float)notional[i];
            }
            return fNotional;
        }
        System.err.println("Cannot return notional unit cell params: no Crystal found");
        return null;
    }

    public String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        Object value = ((Atom)clientAtom).getProperty(propertyName);
        return value == null ? null : "" + value;
    }

    public ModelAdapter.AtomIterator getAtomIterator(Object clientFile) {
        return new AtomIterator(this.getAtomContainer(clientFile));
    }

    public ModelAdapter.BondIterator getBondIterator(Object clientFile) {
        return new BondIterator(this.getAtomContainer(clientFile));
    }

    class BondIterator
    extends ModelAdapter.BondIterator {
        AtomContainer atomContainer;
        Bond[] bonds;
        int ibond;
        Bond bond;
        Atom[] bondedAtoms;

        BondIterator(AtomContainer atomContainer) {
            super(CdkModelAdapter.this);
            this.atomContainer = atomContainer;
            this.bonds = atomContainer.getBonds();
            this.ibond = 0;
        }

        public boolean hasNext() {
            if (this.ibond == this.bonds.length) {
                return false;
            }
            this.bond = this.bonds[this.ibond++];
            this.bondedAtoms = this.bond.getAtoms();
            return true;
        }

        public Object getAtomUniqueID1() {
            return this.bondedAtoms.length == 2 ? this.bondedAtoms[0] : null;
        }

        public Object getAtomUniqueID2() {
            return this.bondedAtoms.length == 2 ? this.bondedAtoms[1] : null;
        }

        public int getEncodedOrder() {
            return (int)this.bond.getOrder();
        }
    }

    class AtomIterator
    extends ModelAdapter.AtomIterator {
        AtomContainer atomContainer;
        int atomCount;
        int iatom;
        Atom atom;

        AtomIterator(AtomContainer atomContainer) {
            super(CdkModelAdapter.this);
            this.atomContainer = atomContainer;
            this.atomCount = atomContainer.getAtomCount();
            this.iatom = 0;
        }

        public boolean hasNext() {
            if (this.iatom == this.atomCount) {
                return false;
            }
            this.atom = this.atomContainer.getAtomAt(this.iatom++);
            return true;
        }

        public Object getUniqueID() {
            return this.atom;
        }

        public int getElementNumber() {
            return this.atom.getAtomicNumber();
        }

        public String getElementSymbol() {
            return this.atom.getSymbol();
        }

        public float getX() {
            return (float)this.atom.getX3d();
        }

        public float getY() {
            return (float)this.atom.getY3d();
        }

        public float getZ() {
            return (float)this.atom.getZ3d();
        }

        public String getPdbAtomRecord() {
            return (String)this.atom.getProperty("pdb.record");
        }

        public int getPdbModelNumber() {
            return 0;
        }

        public Object getClientAtomReference() {
            return this.atom;
        }
    }
}

