/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Model;
import org.jmol.adapter.smarter.ModelReader;

class GaussianReader
extends ModelReader {
    int coordinateBase = 34;
    int atomCount;
    int modelCount;

    GaussianReader() {
    }

    Model readModel(BufferedReader reader) throws Exception {
        this.model = new Model("gaussian");
        try {
            String line;
            int lineNum = 0;
            while ((line = reader.readLine()) != null) {
                if (line.indexOf("Standard orientation:") >= 0) {
                    this.readAtoms(reader);
                } else {
                    if (line.startsWith(" Harmonic frequencies")) {
                        this.readFrequencies(reader);
                        break;
                    }
                    if (line.startsWith(" Total atomic charges:") || line.startsWith(" Mulliken atomic charges:")) {
                        this.readPartialCharges(reader);
                    } else if (lineNum < 20) {
                        if (line.indexOf("This is part of the Gaussian 94(TM) system") >= 0) {
                            this.setGaussian94Offsets();
                        } else if (line.indexOf("This is part of the Gaussian(R) 98 program.") >= 0) {
                            this.setGaussian98Offsets();
                        } else if (line.indexOf("This is the Gaussian(R) 03 program.") >= 0) {
                            this.setGaussian03Offsets();
                        }
                    }
                }
                ++lineNum;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.model.errorMessage = "Could not read file:" + ex;
            return this.model;
        }
        if (this.model.atomCount == 0) {
            this.model.errorMessage = "No atoms in file";
        }
        return this.model;
    }

    void setGaussian94Offsets() {
        this.coordinateBase = 23;
    }

    void setGaussian98Offsets() {
        this.coordinateBase = 34;
    }

    void setGaussian03Offsets() {
        this.coordinateBase = 34;
    }

    void readAtoms(BufferedReader reader) throws Exception {
        String line;
        this.model.discardPreviousAtoms();
        this.atomCount = 0;
        this.modelCount = 1;
        this.discardLines(reader, 4);
        while ((line = reader.readLine()) != null && !line.startsWith(" --")) {
            String centerNumber = this.parseToken(line, 0, 5);
            int elementNumber = this.parseInt(line, 13);
            if (elementNumber <= 0 || elementNumber > 110) continue;
            float x = this.parseFloat(line, this.coordinateBase, this.coordinateBase + 12);
            float y = this.parseFloat(line, this.coordinateBase + 12, this.coordinateBase + 24);
            float z = this.parseFloat(line, this.coordinateBase + 24, this.coordinateBase + 36);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) continue;
            Atom atom = this.model.addNewAtom();
            atom.elementNumber = (byte)elementNumber;
            atom.x = x;
            atom.y = y;
            atom.z = z;
            ++this.atomCount;
        }
    }

    void readFrequencies(BufferedReader reader) throws Exception {
        String line;
        int modelNumber = 1;
        while ((line = reader.readLine()) != null && !line.startsWith(" Frequencies --")) {
        }
        if (line == null) {
            return;
        }
        do {
            this.discardLinesUntilStartsWith(reader, " Atom AN");
            for (int i = 0; i < this.atomCount; ++i) {
                line = reader.readLine();
                int atomCenterNumber = this.parseInt(line, 0, 4);
                int j = 0;
                int col = 11;
                while (j < 3) {
                    float x = this.parseFloat(line, col, col + 6);
                    float y = this.parseFloat(line, col + 7, col + 13);
                    float z = this.parseFloat(line, col + 14, col + 20);
                    this.recordAtomVector(modelNumber + j, atomCenterNumber, x, y, z);
                    ++j;
                    col += 23;
                }
            }
            this.discardLines(reader, 2);
            modelNumber += 3;
        } while ((line = reader.readLine()) != null && line.startsWith(" Frequencies --"));
    }

    void recordAtomVector(int modelNumber, int atomCenterNumber, float x, float y, float z) {
        if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) {
            return;
        }
        if (atomCenterNumber <= 0 || atomCenterNumber > this.atomCount) {
            return;
        }
        if (atomCenterNumber == 1 && modelNumber > 1) {
            this.createNewModel(modelNumber);
        }
        Atom atom = this.model.atoms[(modelNumber - 1) * this.atomCount + atomCenterNumber - 1];
        atom.vectorX = x;
        atom.vectorY = y;
        atom.vectorZ = z;
    }

    void readPartialCharges(BufferedReader reader) throws Exception {
        String line;
        this.discardLines(reader, 1);
        for (int i = 0; i < this.atomCount && (line = reader.readLine()) != null; ++i) {
            this.model.atoms[i].partialCharge = this.parseFloat(line, 9, 18);
        }
    }

    void createNewModel(int modelNumber) {
        this.modelCount = modelNumber - 1;
        Atom[] atoms = this.model.atoms;
        for (int i = 0; i < this.atomCount; ++i) {
            Atom atomNew = this.model.newCloneAtom(atoms[i]);
            atomNew.modelNumber = modelNumber;
        }
    }
}

