/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Model;
import org.jmol.adapter.smarter.ModelReader;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.ModelAdapter;

class PdbReader
extends ModelReader {
    String line;
    int lineLength;
    int currentModelNumber;
    int[] serialMap = new int[512];
    boolean isNMRdata;
    final Hashtable htFormul = new Hashtable();
    String currentGroup3;
    Hashtable htElementsInCurrentGroup;

    PdbReader() {
    }

    Model readModel(BufferedReader reader) throws Exception {
        this.model = new Model("pdb");
        this.model.pdbStructureRecords = new String[32];
        StringBuffer sbHeader = new StringBuffer();
        this.initialize();
        boolean accumulatingHeader = true;
        while ((this.line = reader.readLine()) != null) {
            this.lineLength = this.line.length();
            if (this.line.startsWith("ATOM  ") || this.line.startsWith("HETATM")) {
                this.atom();
                accumulatingHeader = false;
                continue;
            }
            if (this.line.startsWith("CONECT")) {
                this.conect();
                accumulatingHeader = false;
                continue;
            }
            if (this.line.startsWith("HELIX ") || this.line.startsWith("SHEET ") || this.line.startsWith("TURN  ")) {
                this.structure();
                accumulatingHeader = false;
                continue;
            }
            if (this.line.startsWith("MODEL ")) {
                this.model();
                accumulatingHeader = false;
                continue;
            }
            if (this.line.startsWith("CRYST1")) {
                this.cryst1();
                accumulatingHeader = false;
                continue;
            }
            if (this.line.startsWith("SCALE1")) {
                this.scale1();
                accumulatingHeader = false;
                continue;
            }
            if (this.line.startsWith("SCALE2")) {
                this.scale2();
                accumulatingHeader = false;
                continue;
            }
            if (this.line.startsWith("SCALE3")) {
                this.scale3();
                accumulatingHeader = false;
                continue;
            }
            if (this.line.startsWith("EXPDTA")) {
                this.expdta();
                continue;
            }
            if (this.line.startsWith("FORMUL")) {
                this.formul();
                continue;
            }
            if (this.line.startsWith("HEADER") && this.lineLength >= 66) {
                this.model.setModelName(this.line.substring(62, 66));
                continue;
            }
            if (!accumulatingHeader) continue;
            sbHeader.append(this.line);
            sbHeader.append("\n");
        }
        this.serialMap = null;
        if (this.isNMRdata) {
            this.model.pdbScaleTranslate = null;
            this.model.pdbScaleMatrix = null;
            this.model.notionalUnitcell = null;
        }
        this.model.fileHeader = "" + sbHeader;
        return this.model;
    }

    void initialize() {
        this.htFormul.clear();
        this.currentGroup3 = null;
    }

    void atom() {
        boolean isHetero = this.line.startsWith("HETATM");
        try {
            char charAlternateLocation = this.line.charAt(16);
            if (charAlternateLocation != ' ' && charAlternateLocation != 'A') {
                return;
            }
            int serial = this.parseInt(this.line, 6, 11);
            char chainID = this.line.charAt(21);
            int sequenceNumber = this.parseInt(this.line, 22, 26);
            char insertionCode = this.line.charAt(26);
            String group3 = this.parseToken(this.line, 17, 20);
            if (group3 == null) {
                this.currentGroup3 = group3;
                this.htElementsInCurrentGroup = null;
            } else if (!group3.equals(this.currentGroup3)) {
                this.currentGroup3 = group3;
                this.htElementsInCurrentGroup = (Hashtable)this.htFormul.get(group3);
            }
            String elementSymbol = this.deduceElementSymbol();
            String rawAtomName = this.line.substring(12, 16);
            String atomName = rawAtomName.trim();
            int charge = 0;
            if (this.lineLength >= 80) {
                char chMag = this.line.charAt(78);
                char chSign = this.line.charAt(79);
                if (chMag >= '0' && chMag <= '7' && (chSign == '+' || chSign == '-' || chSign == ' ')) {
                    charge = chMag - 48;
                    if (chSign == '-') {
                        charge = -charge;
                    }
                }
            }
            float bfactor = this.parseFloat(this.line, 60, 66);
            int occupancy = 100;
            float floatOccupancy = this.parseFloat(this.line, 54, 60);
            if (floatOccupancy != Float.NaN) {
                occupancy = (int)(floatOccupancy * 100.0f);
            }
            float x = this.parseFloat(this.line, 30, 38);
            float y = this.parseFloat(this.line, 38, 46);
            float z = this.parseFloat(this.line, 46, 54);
            if (serial >= this.serialMap.length) {
                this.serialMap = this.setLength(this.serialMap, serial + 500);
            }
            Atom atom = this.model.addNewAtom();
            atom.modelNumber = this.currentModelNumber;
            atom.elementSymbol = elementSymbol;
            atom.atomName = atomName;
            atom.formalCharge = charge;
            atom.occupancy = occupancy;
            atom.bfactor = bfactor;
            atom.x = x;
            atom.y = y;
            atom.z = z;
            atom.isHetero = isHetero;
            atom.chainID = chainID;
            atom.atomSerial = serial;
            atom.group3 = this.currentGroup3;
            atom.sequenceNumber = sequenceNumber;
            atom.insertionCode = ModelAdapter.canonizeInsertionCode(insertionCode);
            this.serialMap[serial] = this.model.atomCount;
        }
        catch (NumberFormatException e) {
            this.logger.log("bad record", "" + this.line);
        }
    }

    String deduceElementSymbol() {
        if (this.lineLength >= 78) {
            char ch76 = this.line.charAt(76);
            char ch77 = this.line.charAt(77);
            if (ch76 == ' ' && Atom.isValidElementSymbol(ch77)) {
                return "" + ch77;
            }
            if (Atom.isValidElementSymbolNoCaseSecondChar(ch76, ch77)) {
                return "" + ch76 + ch77;
            }
        }
        char ch12 = this.line.charAt(12);
        char ch13 = this.line.charAt(13);
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get(this.line.substring(12, 14)) != null) && Atom.isValidElementSymbolNoCaseSecondChar(ch12, ch13)) {
            return "" + ch12 + ch13;
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + ch13) != null) && Atom.isValidElementSymbol(ch13)) {
            return "" + ch13;
        }
        if ((this.htElementsInCurrentGroup == null || this.htElementsInCurrentGroup.get("" + ch12) != null) && Atom.isValidElementSymbol(ch12)) {
            return "" + ch12;
        }
        return "Xx";
    }

    void conect() {
        int sourceSerial = -1;
        int sourceIndex = -1;
        try {
            sourceSerial = this.parseInt(this.line, 6, 11);
            sourceIndex = this.serialMap[sourceSerial] - 1;
            if (sourceIndex < 0) {
                return;
            }
            for (int i = 0; i < 9; i += i == 5 ? 2 : 1) {
                int targetIndex;
                int targetSerial = this.getTargetSerial(i);
                if (targetSerial < 0 || (targetIndex = this.serialMap[targetSerial] - 1) < 0) continue;
                if (this.model.bondCount > 0) {
                    Bond bond = this.model.bonds[this.model.bondCount - 1];
                    if (i < 4 && bond.atomIndex1 == sourceIndex && bond.atomIndex2 == targetIndex) {
                        ++bond.order;
                        continue;
                    }
                }
                this.model.addBond(new Bond(sourceIndex, targetIndex, i < 4 ? 1 : 64));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int getTargetSerial(int i) {
        int offset = i * 5 + 11;
        int offsetEnd = offset + 5;
        if (offsetEnd <= this.lineLength) {
            return this.parseInt(this.line, offset, offsetEnd);
        }
        return Integer.MIN_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    void structure() {
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        int endIndex;
        int endChainIDIndex;
        int startIndex;
        int startChainIDIndex;
        String structureType = "none";
        if (this.line.startsWith("HELIX ")) {
            structureType = "helix";
            startChainIDIndex = 19;
            startIndex = 21;
            endChainIDIndex = 31;
            endIndex = 33;
        } else if (this.line.startsWith("SHEET ")) {
            structureType = "sheet";
            startChainIDIndex = 21;
            startIndex = 22;
            endChainIDIndex = 32;
            endIndex = 33;
        } else if (this.line.startsWith("TURN  ")) {
            structureType = "turn";
            startChainIDIndex = 19;
            startIndex = 20;
            endChainIDIndex = 30;
            endIndex = 31;
        } else {
            return;
        }
        char startChainID = this.line.charAt((int)var2_2);
        int startSequenceNumber = this.parseInt(this.line, (int)var3_3, (int)(var3_3 + 4));
        char startInsertionCode = this.line.charAt((int)(var3_3 + 4));
        char endChainID = this.line.charAt((int)var4_4);
        int endSequenceNumber = this.parseInt(this.line, (int)var5_5, (int)(var5_5 + 4));
        char endInsertionCode = this.line.charAt((int)(var5_5 + 4));
        this.model.addStructure(new Structure(structureType, startChainID, startSequenceNumber, startInsertionCode, endChainID, endSequenceNumber, endInsertionCode));
    }

    void model() {
        try {
            int modelNumber;
            int startModelColumn = 6;
            int endModelColumn = 14;
            if (endModelColumn > this.lineLength) {
                endModelColumn = this.lineLength;
            }
            if ((modelNumber = this.parseInt(this.line, startModelColumn, endModelColumn)) != this.currentModelNumber + 1) {
                this.logger.log("Model number sequence seems confused");
            }
            this.currentModelNumber = modelNumber;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    void cryst1() {
        try {
            float a = this.getFloat(6, 9);
            float b = this.getFloat(15, 9);
            float c = this.getFloat(24, 9);
            float alpha = this.getFloat(33, 7);
            float beta = this.getFloat(40, 7);
            float gamma = this.getFloat(47, 7);
            this.model.notionalUnitcell = new float[6];
            float[] notionalUnitcell = this.model.notionalUnitcell;
            notionalUnitcell[0] = a;
            notionalUnitcell[1] = b;
            notionalUnitcell[2] = c;
            notionalUnitcell[3] = alpha;
            notionalUnitcell[4] = beta;
            notionalUnitcell[5] = gamma;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    float getFloat(int ich, int cch) throws Exception {
        return this.parseFloat(this.line, ich, ich + cch);
    }

    void scale(int n) throws Exception {
        this.model.pdbScaleMatrix[n * 3 + 0] = this.getFloat(10, 10);
        this.model.pdbScaleMatrix[n * 3 + 1] = this.getFloat(20, 10);
        this.model.pdbScaleMatrix[n * 3 + 2] = this.getFloat(30, 10);
        float translation = this.getFloat(45, 10);
        if (translation != 0.0f) {
            if (this.model.pdbScaleTranslate == null) {
                this.model.pdbScaleTranslate = new float[3];
            }
            this.model.pdbScaleTranslate[n] = translation;
        }
    }

    void scale1() {
        try {
            this.model.pdbScaleMatrix = new float[9];
            this.scale(0);
        }
        catch (Exception e) {
            this.model.pdbScaleMatrix = null;
            this.logger.log("scale1 died:3");
        }
    }

    void scale2() {
        try {
            this.scale(1);
        }
        catch (Exception e) {
            this.model.pdbScaleMatrix = null;
            this.logger.log("scale2 died");
        }
    }

    void scale3() {
        try {
            this.scale(2);
        }
        catch (Exception e) {
            this.model.pdbScaleMatrix = null;
            this.logger.log("scale3 died");
        }
    }

    void expdta() {
        String technique = this.parseTrimmed(this.line, 10).toLowerCase();
        if (technique.regionMatches(true, 0, "nmr", 0, 3)) {
            this.isNMRdata = true;
        }
    }

    void formul() {
        String elementWithCount;
        Hashtable<String, Boolean> htElementsInGroup;
        String groupName = this.parseToken(this.line, 12, 15);
        String formula = this.parseTrimmed(this.line, 19, 70);
        int ichLeftParen = formula.indexOf(40);
        if (ichLeftParen >= 0) {
            int ichRightParen = formula.indexOf(41);
            if (ichRightParen < 0 || ichLeftParen >= ichRightParen) {
                return;
            }
            formula = this.parseTrimmed(formula, ichLeftParen + 1, ichRightParen);
        }
        if ((htElementsInGroup = (Hashtable<String, Boolean>)this.htFormul.get(groupName)) == null) {
            htElementsInGroup = new Hashtable<String, Boolean>();
            this.htFormul.put(groupName, htElementsInGroup);
        }
        this.ichNextParse = 0;
        while ((elementWithCount = this.parseToken(formula, this.ichNextParse)) != null) {
            char chSecond;
            if (elementWithCount.length() < 2) continue;
            char chFirst = elementWithCount.charAt(0);
            if (Atom.isValidElementSymbolNoCaseSecondChar(chFirst, chSecond = elementWithCount.charAt(1))) {
                htElementsInGroup.put("" + chFirst + chSecond, Boolean.TRUE);
                continue;
            }
            if (!Atom.isValidElementSymbol(chFirst)) continue;
            htElementsInGroup.put("" + chFirst, Boolean.TRUE);
        }
    }
}

