/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Mapping;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;

public class Reaction
extends ChemObject
implements Serializable,
Cloneable {
    public static final int UNKNOWN_DIRECTION = 0;
    public static final int FORWARD = 1;
    public static final int BACKWARD = 2;
    public static final int BIDIRECTIONAL = 3;
    protected int growArraySize = 3;
    protected SetOfMolecules reactants = new SetOfMolecules();
    protected SetOfMolecules products = new SetOfMolecules();
    protected SetOfMolecules agents = new SetOfMolecules();
    protected Mapping[] map = new Mapping[this.growArraySize];
    protected int mappingCount = 0;
    private int reactionDirection = 1;

    public int getReactantCount() {
        return this.reactants.getAtomContainerCount();
    }

    public int getProductCount() {
        return this.products.getAtomContainerCount();
    }

    public SetOfMolecules getReactants() {
        return this.reactants;
    }

    public void setReactants(SetOfMolecules setOfMolecules) {
        this.reactants = setOfMolecules;
    }

    public SetOfMolecules getProducts() {
        return this.products;
    }

    public void setProducts(SetOfMolecules setOfMolecules) {
        this.products = setOfMolecules;
    }

    public SetOfMolecules getAgents() {
        return this.agents;
    }

    public Mapping[] getMappings() {
        Mapping[] returnMappings = new Mapping[this.mappingCount];
        System.arraycopy(this.map, 0, returnMappings, 0, returnMappings.length);
        return returnMappings;
    }

    public void addReactant(Molecule reactant) {
        this.addReactant(reactant, 1.0);
    }

    public void addAgent(Molecule agent) {
        this.agents.addAtomContainer(agent);
    }

    public void addReactant(Molecule reactant, double coefficient) {
        this.reactants.addAtomContainer(reactant, coefficient);
    }

    public void addProduct(Molecule product) {
        this.addProduct(product, 1.0);
    }

    public void addProduct(Molecule product, double coefficient) {
        this.products.addAtomContainer(product, coefficient);
    }

    public double getReactantCoefficient(Molecule reactant) {
        return this.reactants.getMultiplier(reactant);
    }

    public double getProductCoefficient(Molecule product) {
        return this.products.getMultiplier(product);
    }

    public boolean setReactantCoefficient(Molecule reactant, double coefficient) {
        return this.reactants.setMultiplier(reactant, coefficient);
    }

    public boolean setProductCoefficient(Molecule product, double coefficient) {
        return this.products.setMultiplier(product, coefficient);
    }

    public double[] getReactantCoefficients() {
        return this.reactants.getMultipliers();
    }

    public double[] getProductCoefficients() {
        return this.products.getMultipliers();
    }

    public boolean setReactantCoefficients(double[] reactantCoefficients) {
        return this.reactants.setMultipliers(reactantCoefficients);
    }

    public boolean setProductCoefficients(double[] productCoefficients) {
        return this.products.setMultipliers(productCoefficients);
    }

    public void setDirection(int direction) {
        this.reactionDirection = direction;
    }

    public int getDirection() {
        return this.reactionDirection;
    }

    public void addMapping(Mapping mapping) {
        if (this.mappingCount + 1 >= this.map.length) {
            this.growMappingArray();
        }
        this.map[this.mappingCount] = mapping;
        ++this.mappingCount;
    }

    protected void growMappingArray() {
        Mapping[] newMap = new Mapping[this.map.length + this.growArraySize];
        System.arraycopy(this.map, 0, newMap, 0, this.map.length);
        this.map = newMap;
    }

    public String toString() {
        StringBuffer description = new StringBuffer();
        description.append("Reaction(");
        description.append(this.getID() + ", ");
        description.append("#M:" + this.mappingCount + ", ");
        description.append("reactants=" + this.reactants.toString() + ", ");
        description.append("products=" + this.products.toString() + ", ");
        description.append("agents=" + this.agents.toString());
        description.append(")");
        return description.toString();
    }
}

