/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.vecmath.Point2d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.Ring;

public class RingSet
extends Vector
implements Serializable,
Cloneable {
    public static final int LARGE_FIRST = 1;
    public static final int SMALL_FIRST = 2;

    public boolean ringAlreadyInSet(Ring newRing) {
        for (int f = 0; f < this.size(); ++f) {
            Bond[] newBonds;
            boolean equals = false;
            int equalCount = 0;
            Ring ring = (Ring)this.elementAt(f);
            Bond[] bonds = ring.getBonds();
            if (bonds.length == (newBonds = newRing.getBonds()).length) {
                for (int i = 0; i < bonds.length; ++i) {
                    Bond bond = newBonds[i];
                    for (int n = 0; n < bonds.length; ++n) {
                        if (bond != bonds[n]) continue;
                        equals = true;
                        ++equalCount;
                        break;
                    }
                    if (!equals) break;
                }
            }
            if (equalCount != bonds.length) continue;
            return true;
        }
        return false;
    }

    public Vector getRings(Bond bond) {
        Vector<Ring> rings = new Vector<Ring>();
        for (int i = 0; i < this.size(); ++i) {
            Ring ring = (Ring)this.elementAt(i);
            if (!ring.contains(bond)) continue;
            rings.addElement(ring);
        }
        return rings;
    }

    public RingSet getRings(Atom atom) {
        RingSet rings = new RingSet();
        for (int i = 0; i < this.size(); ++i) {
            Ring ring = (Ring)this.elementAt(i);
            if (!ring.contains(atom)) continue;
            rings.addElement(ring);
        }
        return rings;
    }

    public Ring getHeaviestRing(Bond bond) {
        Vector rings = this.getRings(bond);
        Ring ring = null;
        int maxOrderSum = 0;
        for (int i = 0; i < rings.size(); ++i) {
            if (maxOrderSum >= ((Ring)rings.elementAt(i)).getOrderSum()) continue;
            ring = (Ring)rings.elementAt(i);
            maxOrderSum = ring.getOrderSum();
        }
        return ring;
    }

    public Vector getConnectedRings(Ring ring) {
        Vector<Ring> connectedRings = new Vector<Ring>();
        for (int i = 0; i < ring.getAtomCount(); ++i) {
            Atom atom = ring.getAtomAt(i);
            for (int j = 0; j < this.size(); ++j) {
                Ring tempRing = (Ring)this.elementAt(j);
                if (tempRing == ring || !tempRing.contains(atom)) continue;
                connectedRings.addElement(tempRing);
            }
        }
        return connectedRings;
    }

    public Ring getMostComplexRing() {
        int i;
        int[] neighbors = new int[this.size()];
        int mostComplex = 0;
        int mostComplexPosition = 0;
        for (i = 0; i < this.size(); ++i) {
            Ring ring1 = (Ring)this.elementAt(i);
            for (int j = 0; j < ring1.getAtomCount(); ++j) {
                Atom atom1 = ring1.getAtomAt(j);
                block2: for (int k = i + 1; k < this.size(); ++k) {
                    Ring ring2 = (Ring)this.elementAt(k);
                    if (ring1 == ring2) continue;
                    for (int l = 0; l < ring2.getAtomCount(); ++l) {
                        Atom atom2 = ring2.getAtomAt(l);
                        if (atom1 != atom2) continue;
                        int n = i;
                        neighbors[n] = neighbors[n] + 1;
                        int n2 = k;
                        neighbors[n2] = neighbors[n2] + 1;
                        continue block2;
                    }
                }
            }
        }
        for (i = 0; i < neighbors.length; ++i) {
            if (neighbors[i] <= mostComplex) continue;
            mostComplex = neighbors[i];
            mostComplexPosition = i;
        }
        return (Ring)this.elementAt(mostComplexPosition);
    }

    public void add(RingSet rs) {
        for (int f = 0; f < rs.size(); ++f) {
            if (this.contains(rs.elementAt(f))) continue;
            this.addElement(rs.elementAt(f));
        }
    }

    public Point2d get2DCenter() {
        double centerX = 0.0;
        double centerY = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            centerX += ((Ring)this.elementAt((int)i)).get2DCenter().x;
            centerY += ((Ring)this.elementAt((int)i)).get2DCenter().y;
        }
        Point2d point = new Point2d(centerX / (double)this.size(), centerY / (double)this.size());
        return point;
    }

    public boolean contains(Atom atom) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((Ring)this.elementAt(i)).contains(atom)) continue;
            return true;
        }
        return false;
    }

    public AtomContainer getRingSetInAtomContainer() {
        AtomContainer ac = new AtomContainer();
        for (int i = 0; i < this.size(); ++i) {
            ac.add((Ring)this.elementAt(i));
        }
        return ac;
    }

    public void sort() {
        Collections.sort(this, new RingSizeComparator(1));
    }

    public String reportRingList(Molecule molecule) {
        String ringList = "";
        for (int f = 0; f < this.size(); ++f) {
            ringList = ringList + ((Ring)this.elementAt(f)).toString(molecule) + "\n";
        }
        return ringList;
    }

    public class RingSizeComparator
    implements Comparator {
        int sortOrder = 2;

        public RingSizeComparator(int so) {
            this.sortOrder = so;
        }

        public int compare(Object o1, Object o2) throws ClassCastException {
            int s2;
            int s1 = ((Ring)o1).getAtomCount();
            if (s1 == (s2 = ((Ring)o2).getAtomCount())) {
                return 0;
            }
            if (s2 > s1 && this.sortOrder == 2) {
                return 1;
            }
            if (s2 > s1 && this.sortOrder == 1) {
                return -1;
            }
            if (s2 < s1 && this.sortOrder == 2) {
                return -1;
            }
            if (s2 < s1 && this.sortOrder == 1) {
                return 1;
            }
            return 0;
        }
    }
}

