/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.config.AtomTypeConfigurator;
import org.openscience.cdk.config.atomtypes.AtomTypeReader;

public class CDKBasedAtomTypeConfigurator
implements AtomTypeConfigurator {
    private String configFile = "org.openscience.cdk.config.data.structgen_atomtypes.xml";
    private InputStream ins = null;

    public void setInputStream(InputStream ins) {
        this.ins = ins;
    }

    public Vector readAtomTypes() throws Exception {
        Vector atomTypes = new Vector(0);
        if (this.ins == null) {
            try {
                this.ins = this.getClass().getClassLoader().getResourceAsStream(this.configFile);
            }
            catch (Exception exc) {
                throw new IOException("There was a problem getting a stream for " + this.configFile + " with getClass.getClassLoader.getResourceAsStream");
            }
            if (this.ins == null) {
                try {
                    this.ins = this.getClass().getResourceAsStream(this.configFile);
                }
                catch (Exception exc) {
                    throw new IOException("There was a problem getting a stream for " + this.configFile + " with getClass.getResourceAsStream");
                }
            }
        }
        if (this.ins == null) {
            throw new IOException("There was a problem getting an input stream");
        }
        AtomTypeReader reader = new AtomTypeReader(new InputStreamReader(this.ins));
        atomTypes = reader.readAtomTypes();
        for (int f = 0; f < atomTypes.size(); ++f) {
            Object o = atomTypes.elementAt(f);
            if (o != null) continue;
            System.out.println("Expecting an object but found null!");
            if (o instanceof AtomType) continue;
            System.out.println("Expecting cdk.AtomType class, but got: " + o.getClass().getName());
        }
        return atomTypes;
    }
}

