/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.setting.BooleanIOSetting;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class Gaussian98Reader
extends DefaultChemObjectReader {
    private IsotopeFactory isotopeFactory;
    private BufferedReader input;
    private LoggingTool logger = new LoggingTool(this);
    private int atomCount = 0;
    private String lastRoute = "";
    private BooleanIOSetting readOptimizedStructureOnly;

    public Gaussian98Reader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "Gaussian98";
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public Gaussian98Reader(Reader input) {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
        try {
            this.isotopeFactory = IsotopeFactory.getInstance();
            this.logger.info("IsotopeFactory instantiated: " + this.isotopeFactory);
            this.logger.info(" #isotopes defined: " + this.isotopeFactory.getSize());
        }
        catch (Exception exception) {
            this.logger.error("Could not instantiate IsotopeFactory");
            this.logger.debug(exception);
        }
        this.initIOSettings();
    }

    public boolean accepts(ChemObject object) {
        return object instanceof ChemFile;
    }

    public boolean matches(int lineNumber, String line) {
        return line.indexOf("Gaussian(R) 98") >= 0 || line.indexOf("Gaussian 98") >= 0;
    }

    public ChemObject read(ChemObject object) throws CDKException {
        this.customizeJob();
        if (object instanceof ChemFile) {
            ChemFile file = null;
            try {
                file = this.readChemFile();
            }
            catch (IOException exception) {
                throw new CDKException("Error while reading file: " + exception.toString());
            }
            return file;
        }
        throw new CDKException("Reading of a " + object.getClass().getName() + " is not supported.");
    }

    public void close() throws IOException {
        this.input.close();
    }

    private ChemFile readChemFile() throws CDKException, IOException {
        ChemFile chemFile = new ChemFile();
        ChemSequence sequence = new ChemSequence();
        ChemModel model = null;
        String line = this.input.readLine();
        String levelOfTheory = "";
        String description = "";
        int modelCounter = 0;
        while (this.input.ready() && line != null) {
            if (line.indexOf("Standard orientation:") >= 0) {
                model = new ChemModel();
                this.readCoordinates(model);
                break;
            }
            line = this.input.readLine();
        }
        if (model != null) {
            line = this.input.readLine().trim();
            while (this.input.ready() && line != null) {
                if (line.indexOf("#") == 0) {
                    this.lastRoute = line;
                    modelCounter = 0;
                } else if (line.indexOf("Standard orientation:") >= 0) {
                    if (!this.readOptimizedStructureOnly.isSet()) {
                        sequence.addChemModel(model);
                    } else {
                        this.logger.info("Skipping frame, because I was told to do");
                    }
                    this.fireFrameRead();
                    model = new ChemModel();
                    ++modelCounter;
                    this.readCoordinates(model);
                } else if (line.indexOf("SCF Done:") >= 0) {
                    model.setProperty("Remark", line.trim());
                } else if (line.indexOf("Harmonic frequencies") < 0) {
                    if (line.indexOf("Total atomic charges") >= 0) {
                        this.readPartialCharges(model);
                    } else if (line.indexOf("Magnetic shielding") >= 0) {
                        this.readNMRData(model, line);
                    } else if (line.indexOf("GINC") >= 0) {
                        levelOfTheory = this.parseLevelOfTheory(line);
                        this.logger.debug("Level of Theory for this model: " + levelOfTheory);
                        description = this.lastRoute + ", model no. " + modelCounter;
                        model.setProperty("Description", description);
                    }
                }
                line = this.input.readLine();
            }
            sequence.addChemModel(model);
            this.fireFrameRead();
        }
        chemFile.addChemSequence(sequence);
        return chemFile;
    }

    private void readCoordinates(ChemModel model) throws CDKException, IOException {
        SetOfMolecules moleculeSet = new SetOfMolecules();
        Molecule molecule = new Molecule();
        String line = this.input.readLine();
        line = this.input.readLine();
        line = this.input.readLine();
        line = this.input.readLine();
        while (this.input.ready() && (line = this.input.readLine()) != null && line.indexOf("-----") < 0) {
            int atomicNumber = 0;
            StringReader sr = new StringReader(line);
            StreamTokenizer token = new StreamTokenizer(sr);
            token.nextToken();
            if (token.nextToken() == -2) {
                atomicNumber = (int)token.nval;
                if (atomicNumber == 0) {
                    continue;
                }
            } else {
                throw new CDKException("Error while reading coordinates: expected integer.");
            }
            token.nextToken();
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading x coordinate");
            }
            x = token.nval;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading y coordinate");
            }
            y = token.nval;
            if (token.nextToken() != -2) {
                throw new IOException("Error reading z coordinate");
            }
            z = token.nval;
            Atom atom = new Atom(this.isotopeFactory.getElementSymbol(atomicNumber));
            atom.setPoint3d(new Point3d(x, y, z));
            molecule.addAtom(atom);
        }
        this.atomCount = molecule.getAtomCount();
        moleculeSet.addMolecule(molecule);
        model.setSetOfMolecules(moleculeSet);
    }

    private void readPartialCharges(ChemModel model) throws CDKException, IOException {
        this.logger.info("Reading partial atomic charges");
        SetOfMolecules moleculeSet = model.getSetOfMolecules();
        Molecule molecule = moleculeSet.getMolecule(0);
        String line = this.input.readLine();
        while (this.input.ready()) {
            line = this.input.readLine();
            this.logger.debug("Read charge block line: " + line);
            if (line == null || line.indexOf("Sum of Mulliken charges") >= 0) {
                this.logger.debug("End of charge block found");
                break;
            }
            StringReader sr = new StringReader(line);
            StreamTokenizer tokenizer = new StreamTokenizer(sr);
            if (tokenizer.nextToken() != -2) continue;
            int atomCounter = (int)tokenizer.nval;
            tokenizer.nextToken();
            double charge = 0.0;
            if (tokenizer.nextToken() != -2) {
                throw new CDKException("Error while reading charge: expected double.");
            }
            charge = tokenizer.nval;
            this.logger.debug("Found charge for atom " + atomCounter + ": " + charge);
            Atom atom = molecule.getAtomAt(atomCounter - 1);
            atom.setCharge(charge);
        }
    }

    private void readFrequencies(ChemModel model) throws IOException {
    }

    private void readNMRData(ChemModel model, String labelLine) throws CDKException {
        AtomContainer ac = ChemModelManipulator.getAllInOneContainer(model);
        String label = labelLine.indexOf("Diamagnetic") >= 0 ? "Diamagnetic Magnetic shielding (Isotropic)" : (labelLine.indexOf("Paramagnetic") >= 0 ? "Paramagnetic Magnetic shielding (Isotropic)" : "Magnetic shielding (Isotropic)");
        int atomIndex = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            try {
                String line = this.input.readLine().trim();
                while (line.indexOf("Isotropic") < 0) {
                    if (line == null) {
                        return;
                    }
                    line = this.input.readLine().trim();
                }
                StringTokenizer st1 = new StringTokenizer(line);
                while (st1.hasMoreTokens() && !st1.nextToken().equals("Isotropic")) {
                }
                while (st1.hasMoreTokens() && !st1.nextToken().equals("=")) {
                }
                double shielding = Double.valueOf(st1.nextToken());
                ac.getAtomAt(atomIndex).setProperty("IsotropicShielding", new Double(shielding));
                ++atomIndex;
                continue;
            }
            catch (Exception exc) {
                this.logger.debug("failed to read line from gaussian98 file where I expected one.");
            }
        }
    }

    private String parseLevelOfTheory(String line) {
        StringBuffer summary = new StringBuffer();
        summary.append(line);
        try {
            do {
                line = this.input.readLine().trim();
                summary.append(line);
            } while (line.indexOf("@") < 0);
        }
        catch (Exception exc) {
            this.logger.debug("syntax problem while parsing summary of g98 section: ");
            this.logger.debug(exc);
        }
        this.logger.debug("parseLoT(): " + summary.toString());
        StringTokenizer st1 = new StringTokenizer(summary.toString(), "\\");
        if (st1.countTokens() < 6) {
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            st1.nextToken();
        }
        return st1.nextToken() + "/" + st1.nextToken();
    }

    private void initIOSettings() {
        this.readOptimizedStructureOnly = new BooleanIOSetting("ReadOptimizedStructureOnly", 2, "Should I only read the optimized structure from a geometry optimization?", "false");
    }

    private void customizeJob() {
        this.fireIOSettingQuestion(this.readOptimizedStructureOnly);
    }

    public IOSetting[] getIOSettings() {
        IOSetting[] settings = new IOSetting[]{this.readOptimizedStructureOnly};
        return settings;
    }
}

