/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;

public class HINReader
extends DefaultChemObjectReader {
    private BufferedReader input;

    public HINReader(Reader input) {
        this.input = new BufferedReader(input);
    }

    public HINReader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "HIN";
    }

    public void close() throws IOException {
        this.input.close();
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public boolean matches(int lineNumber, String line) {
        return line.indexOf(";") == 0 || line.startsWith("forcefield") || line.startsWith("sys") || line.startsWith("view") || line.startsWith("mol") || line.startsWith("endmol");
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof ChemFile) {
            return this.readChemFile();
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private String getMolName(String line) {
        if (line == null) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(line, " ");
        int ntok = st.countTokens();
        String[] toks = new String[ntok];
        for (int j = 0; j < ntok; ++j) {
            toks[j] = st.nextToken();
        }
        if (toks.length == 3) {
            return toks[2];
        }
        return "";
    }

    private ChemFile readChemFile() {
        ChemFile file = new ChemFile();
        ChemSequence chemSequence = new ChemSequence();
        ChemModel chemModel = new ChemModel();
        SetOfMolecules setOfMolecules = new SetOfMolecules();
        try {
            String line;
            while ((line = this.input.readLine()).indexOf("mol ") != 0) {
            }
            String info = this.getMolName(line);
            line = this.input.readLine();
            while (line != null) {
                ArrayList ar;
                int i;
                if (line.indexOf(59) == 0) continue;
                if (line.indexOf("mol ") == 0) {
                    info = this.getMolName(line);
                    line = this.input.readLine();
                }
                Molecule m = new Molecule();
                m.setProperty("Title", info);
                Vector cons = new Vector();
                int atomSerial = 0;
                while (line.indexOf("endmol ") < 0) {
                    if (line.indexOf(59) == 0) continue;
                    StringTokenizer tokenizer = new StringTokenizer(line, " ");
                    int ntoken = tokenizer.countTokens();
                    String[] toks = new String[ntoken];
                    for (int i2 = 0; i2 < ntoken; ++i2) {
                        toks[i2] = tokenizer.nextToken();
                    }
                    String sym = new String(toks[3]);
                    double charge = Double.parseDouble(toks[6]);
                    double x = Double.parseDouble(toks[7]);
                    double y = Double.parseDouble(toks[8]);
                    double z = Double.parseDouble(toks[9]);
                    int nbond = Integer.parseInt(toks[10]);
                    Atom atom = new Atom(sym, new Point3d(x, y, z));
                    atom.setCharge(charge);
                    for (int j = 11; j < 11 + nbond * 2; j += 2) {
                        double bo = 1.0;
                        int s = Integer.parseInt(toks[j]) - 1;
                        char bt = toks[j + 1].charAt(0);
                        switch (bt) {
                            case 's': {
                                bo = 1.0;
                                break;
                            }
                            case 'd': {
                                bo = 2.0;
                                break;
                            }
                            case 't': {
                                bo = 3.0;
                                break;
                            }
                            case 'a': {
                                bo = 1.5;
                            }
                        }
                        ArrayList<Number> ar2 = new ArrayList<Number>(3);
                        ar2.add(new Integer(atomSerial));
                        ar2.add(new Integer(s));
                        ar2.add(new Double(bo));
                        cons.add(ar2);
                    }
                    m.addAtom(atom);
                    ++atomSerial;
                    line = this.input.readLine();
                }
                Vector<ArrayList> blist = new Vector<ArrayList>();
                for (i = 0; i < cons.size(); ++i) {
                    ar = (ArrayList)cons.get(i);
                    ArrayList arev = new ArrayList(3);
                    arev.add(ar.get(1));
                    arev.add(ar.get(0));
                    arev.add(ar.get(2));
                    if (blist.contains(ar) || blist.contains(arev)) continue;
                    blist.add(ar);
                }
                for (i = 0; i < blist.size(); ++i) {
                    ar = (ArrayList)blist.get(i);
                    int s = (Integer)ar.get(0);
                    int e = (Integer)ar.get(1);
                    double bo = (Double)ar.get(2);
                    m.addBond(s, e, bo);
                }
                setOfMolecules.addMolecule(m);
                line = this.input.readLine();
            }
            chemModel.setSetOfMolecules(setOfMolecules);
            chemSequence.addChemModel(chemModel);
            file.addChemSequence(chemSequence);
        }
        catch (IOException e) {
            file = null;
        }
        return file;
    }
}

