/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.SetOfReactions;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.MDLV3000Reader;
import org.openscience.cdk.io.setting.IOSetting;
import org.openscience.cdk.tools.LoggingTool;

public class MDLRXNV3000Reader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private LoggingTool logger = new LoggingTool(this.getClass().getName());

    public MDLRXNV3000Reader(Reader in) {
        this.input = new BufferedReader(in);
        this.initIOSettings();
    }

    public MDLRXNV3000Reader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "MDL RXN V3000";
    }

    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public boolean matches(int lineNumber, String line) {
        return line.startsWith("$RXN V3000");
    }

    public ChemObject read(ChemObject object) throws CDKException {
        if (object instanceof Reaction) {
            return this.readReaction();
        }
        if (object instanceof ChemModel) {
            ChemModel model = new ChemModel();
            SetOfReactions reactionSet = new SetOfReactions();
            reactionSet.addReaction(this.readReaction());
            model.setSetOfReactions(reactionSet);
            return model;
        }
        throw new CDKException("Only supported are Reaction and ChemModel, and not " + object.getClass().getName() + ".");
    }

    public String readCommand() throws CDKException {
        String line = this.readLine();
        if (line.startsWith("M  V30 ")) {
            String command = line.substring(7);
            if (command.endsWith("-")) {
                command = command.substring(0, command.length() - 1);
                command = command + this.readCommand();
            }
            return command;
        }
        throw new CDKException("Could not read MDL file: unexpected line: " + line);
    }

    public String readLine() throws CDKException {
        String line = null;
        try {
            line = this.input.readLine();
            this.logger.debug("read line: " + line);
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            this.logger.error(error);
            this.logger.debug(exception);
            throw new CDKException(error);
        }
        return line;
    }

    private Reaction readReaction() throws CDKException {
        String error;
        MDLV3000Reader reader;
        String molFileLine;
        String error2;
        String announceMDLFileLine;
        StringBuffer molFile;
        int i;
        Reaction reaction = new Reaction();
        String firstLine = this.readLine();
        String secondLine = this.readLine();
        String thirdLine = this.readLine();
        String fourthLine = this.readLine();
        int reactantCount = 0;
        int productCount = 0;
        boolean foundCOUNTS = false;
        while (this.isReady() && !foundCOUNTS) {
            String command = this.readCommand();
            if (command.startsWith("COUNTS")) {
                StringTokenizer tokenizer = new StringTokenizer(command);
                try {
                    String dummy = tokenizer.nextToken();
                    reactantCount = Integer.valueOf(tokenizer.nextToken());
                    this.logger.info("Expecting " + reactantCount + " reactants in file");
                    productCount = Integer.valueOf(tokenizer.nextToken());
                    this.logger.info("Expecting " + productCount + " products in file");
                }
                catch (Exception exception) {
                    this.logger.debug(exception);
                    throw new CDKException("Error while counts line of RXN file");
                }
                foundCOUNTS = true;
                continue;
            }
            this.logger.warn("Waiting for COUNTS line, but found: " + command);
        }
        for (i = 1; i <= reactantCount; ++i) {
            molFile = new StringBuffer();
            announceMDLFileLine = this.readCommand();
            if (!announceMDLFileLine.equals("BEGIN REACTANT")) {
                error2 = "Excepted start of reactant, but found: " + announceMDLFileLine;
                this.logger.error(error2);
                throw new CDKException(error2);
            }
            molFileLine = "";
            while (!molFileLine.endsWith("END REACTANT")) {
                molFileLine = this.readLine();
                molFile.append(molFileLine);
                molFile.append("\n");
            }
            try {
                reader = new MDLV3000Reader(new StringReader(molFile.toString()));
                Molecule reactant = (Molecule)reader.read(new Molecule());
                reaction.addReactant(reactant);
                continue;
            }
            catch (Exception exception) {
                error = "Error while reading reactant: " + exception.getMessage();
                this.logger.error(error);
                this.logger.debug(exception);
                throw new CDKException(error);
            }
        }
        for (i = 1; i <= productCount; ++i) {
            molFile = new StringBuffer();
            announceMDLFileLine = this.readCommand();
            if (!announceMDLFileLine.equals("BEGIN PRODUCT")) {
                error2 = "Excepted start of product, but found: " + announceMDLFileLine;
                this.logger.error(error2);
                throw new CDKException(error2);
            }
            molFileLine = "";
            while (!molFileLine.endsWith("END PRODUCT")) {
                molFileLine = this.readLine();
                molFile.append(molFileLine);
                molFile.append("\n");
            }
            try {
                reader = new MDLV3000Reader(new StringReader(molFile.toString()));
                Molecule product = (Molecule)reader.read(new Molecule());
                reaction.addProduct(product);
                continue;
            }
            catch (Exception exception) {
                error = "Error while reading product: " + exception.getMessage();
                this.logger.error(error);
                this.logger.debug(exception);
                throw new CDKException(error);
            }
        }
        return reaction;
    }

    public boolean isReady() throws CDKException {
        try {
            return this.input.ready();
        }
        catch (Exception exception) {
            String error = "Unexpected error while reading file: " + exception.getMessage();
            this.logger.error(error);
            this.logger.debug(exception);
            throw new CDKException(error);
        }
    }

    public boolean accepts(ChemObject object) {
        if (object instanceof Reaction) {
            return true;
        }
        return object instanceof ChemModel;
    }

    public void close() throws IOException {
        this.input.close();
    }

    private void initIOSettings() {
    }

    private void customizeJob() {
    }

    public IOSetting[] getIOSettings() {
        return new IOSetting[0];
    }
}

