/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import javax.vecmath.Point3d;
import org.openscience.cdk.Atom;
import org.openscience.cdk.BioPolymer;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.ChemObject;
import org.openscience.cdk.ChemSequence;
import org.openscience.cdk.Monomer;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.tools.LoggingTool;

public class PDBReader
extends DefaultChemObjectReader {
    private LoggingTool logger = new LoggingTool(this.getClass().getName());
    private BufferedReader _oInput;

    public PDBReader(InputStream oIn) {
        this._oInput = new BufferedReader(new InputStreamReader(oIn));
    }

    public PDBReader(Reader oIn) {
        this._oInput = new BufferedReader(oIn);
    }

    public PDBReader() {
        this(new StringReader(""));
    }

    public String getFormatName() {
        return "Protein Brookhave Database (PDB)";
    }

    public void setReader(Reader input) throws CDKException {
        this._oInput = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    public boolean matches(int lineNumber, String line) {
        return line.startsWith("HEADER") || line.startsWith("HETATM ") || line.startsWith("ATOM  ");
    }

    public ChemObject read(ChemObject oObj) throws CDKException {
        if (oObj instanceof ChemFile) {
            return this.readChemFile();
        }
        throw new CDKException("Only supported is reading of ChemFile objects.");
    }

    private ChemFile readChemFile() {
        ChemFile oFile = new ChemFile();
        ChemSequence oSeq = new ChemSequence();
        ChemModel oModel = new ChemModel();
        SetOfMolecules oSet = new SetOfMolecules();
        BioPolymer oBP = new BioPolymer();
        try {
            do {
                String cRead = this._oInput.readLine();
                this.logger.debug(cRead);
                if (cRead == null) continue;
                StringBuffer cLine = new StringBuffer(cRead);
                while (cLine.length() < 6) {
                    cLine.append(" ");
                }
                String cCol = cLine.substring(0, 6).toUpperCase();
                if (cCol.equals("ATOM  ") || cCol.equals("HETATM")) {
                    Monomer oMonomer;
                    Atom oAtom = this.readAtom(cLine.toString());
                    StringBuffer cResidue = new StringBuffer(8);
                    Object oObj = oAtom.getProperty("pdb.resName");
                    if (oObj != null) {
                        cResidue = cResidue.append(((String)oObj).trim());
                    }
                    if ((oObj = oAtom.getProperty("pdb.chainID")) != null) {
                        cResidue = cResidue.append(((String)oObj).trim());
                    }
                    if ((oObj = oAtom.getProperty("pdb.resSeq")) != null) {
                        cResidue = cResidue.append(((String)oObj).trim());
                    }
                    if ((oMonomer = oBP.getMonomer(cResidue.toString())) == null) {
                        oMonomer = new Monomer();
                        oMonomer.setMonomerName(cResidue.toString());
                        oMonomer.setMonomerType((String)oAtom.getProperty("pdb.resName"));
                    }
                    oBP.addAtom(oAtom, oMonomer);
                    continue;
                }
                if (cCol.equals("TER   ")) {
                    oSet.addMolecule(oBP);
                    oBP = new BioPolymer();
                    continue;
                }
                if (cCol.equals("END   ")) {
                    if (oBP.getAtomCount() != 0) {
                        oSet.addMolecule(oBP);
                    }
                    oBP = new BioPolymer();
                    continue;
                }
                if (!cCol.equals("HELIX ") && !cCol.equals("SHEET ") && !cCol.equals("TURN  ")) continue;
                Vector<String> t = (Vector<String>)oModel.getProperty("pdb.structure.records");
                if (t == null) {
                    t = new Vector<String>();
                    oModel.setProperty("pdb.structure.records", t);
                }
                t.add("" + cLine);
            } while (this._oInput.ready());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this._oInput.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        oModel.setSetOfMolecules(oSet);
        oSeq.addChemModel(oModel);
        oFile.addChemSequence(oSeq);
        return oFile;
    }

    private Atom readAtom(String cLine) {
        if (cLine.length() < 59) {
            throw new RuntimeException("PDBReader error during readAtom(): line too short");
        }
        String elementSymbol = cLine.substring(12, 14).trim();
        if (elementSymbol.length() == 2) {
            elementSymbol = elementSymbol.charAt(0) + elementSymbol.substring(1).toLowerCase();
        }
        Atom oAtom = new Atom(elementSymbol, new Point3d(new Double(cLine.substring(30, 38)), new Double(cLine.substring(38, 46)), new Double(cLine.substring(46, 54))));
        oAtom.setProperty("pdb.record", cLine);
        oAtom.setProperty("pdb.serial", new Integer(cLine.substring(6, 11).trim()));
        oAtom.setProperty("pdb.name", new String(cLine.substring(12, 16)).trim());
        oAtom.setProperty("pdb.altLoc", new String(cLine.substring(16, 17)).trim());
        oAtom.setProperty("pdb.resName", new String(cLine.substring(17, 20)).trim());
        oAtom.setProperty("pdb.chainID", new String(cLine.substring(21, 22)).trim());
        oAtom.setProperty("pdb.resSeq", new String(cLine.substring(22, 26)).trim());
        oAtom.setProperty("pdb.iCode", new String(cLine.substring(26, 27)).trim());
        if (cLine.length() >= 59) {
            oAtom.setProperty("pdb.occupancy", new Double(cLine.substring(54, 60)));
        }
        if (cLine.length() >= 65) {
            oAtom.setProperty("pdb.tempFactor", new Double(cLine.substring(60, 66)));
        }
        if (cLine.length() >= 75) {
            oAtom.setProperty("pdb.segID", new String(cLine.substring(72, 76)).trim());
        }
        if (cLine.length() >= 78) {
            oAtom.setProperty("pdb.element", new String(cLine.substring(76, 78)).trim());
        }
        if (cLine.length() >= 79) {
            oAtom.setProperty("pdb.charge", new String(cLine.substring(78, 80)).trim());
        }
        return oAtom;
    }

    public void close() throws IOException {
        this._oInput.close();
    }
}

