/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.io.cml.CMLStack;
import org.openscience.cdk.io.cml.ModuleInterface;
import org.openscience.cdk.io.cml.cdopi.CDOInterface;
import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.Attributes;

public class CMLCoreModule
implements ModuleInterface {
    protected LoggingTool logger;
    protected final String SYSTEMID = "CML-1999-05-15";
    protected CDOInterface cdo;
    protected int atomCounter;
    protected Vector elsym;
    protected Vector eltitles;
    protected Vector elid;
    protected Vector formalCharges;
    protected Vector partialCharges;
    protected Vector isotope;
    protected Vector x3;
    protected Vector y3;
    protected Vector z3;
    protected Vector x2;
    protected Vector y2;
    protected Vector xfract;
    protected Vector yfract;
    protected Vector zfract;
    protected Vector hCounts;
    protected Vector atomParities;
    protected Vector atomDictRefs;
    protected int bondCounter;
    protected Vector bondid;
    protected Vector bondARef1;
    protected Vector bondARef2;
    protected Vector order;
    protected Vector bondStereo;
    protected Vector bondDictRefs;
    protected Vector bondElid;
    protected boolean stereoGiven;
    protected int curRef;
    protected int CurrentElement;
    protected String BUILTIN;
    protected String DICTREF;
    protected String elementTitle;
    protected String currentChars;
    protected double[] unitcellparams;
    protected int crystalScalar;
    private double[] a;
    private double[] b;
    private double[] c;
    boolean cartesianAxesSet = false;

    public CMLCoreModule(CDOInterface cdo) {
        this.logger = new LoggingTool(this.getClass().getName());
        this.cdo = cdo;
    }

    public CMLCoreModule(ModuleInterface conv) {
        this.inherit(conv);
    }

    public void inherit(ModuleInterface convention) {
        if (convention instanceof CMLCoreModule) {
            CMLCoreModule conv = (CMLCoreModule)convention;
            this.logger = conv.logger;
            this.cdo = conv.returnCDO();
            this.BUILTIN = conv.BUILTIN;
            this.atomCounter = conv.atomCounter;
            this.elsym = conv.elsym;
            this.eltitles = conv.eltitles;
            this.elid = conv.elid;
            this.formalCharges = conv.formalCharges;
            this.partialCharges = conv.partialCharges;
            this.isotope = conv.isotope;
            this.x3 = conv.x3;
            this.y3 = conv.y3;
            this.z3 = conv.z3;
            this.x2 = conv.x2;
            this.y2 = conv.y2;
            this.xfract = conv.xfract;
            this.yfract = conv.yfract;
            this.zfract = conv.zfract;
            this.hCounts = conv.hCounts;
            this.atomParities = conv.atomParities;
            this.atomDictRefs = conv.atomDictRefs;
            this.bondCounter = conv.bondCounter;
            this.bondid = conv.bondid;
            this.bondARef1 = conv.bondARef1;
            this.bondARef2 = conv.bondARef2;
            this.order = conv.order;
            this.bondStereo = conv.bondStereo;
            this.bondDictRefs = conv.bondDictRefs;
            this.curRef = conv.curRef;
            this.unitcellparams = conv.unitcellparams;
        } else {
            this.logger.warn((Object)"Cannot inherit information from module: ", convention.getClass().getName());
        }
    }

    public CDOInterface returnCDO() {
        return this.cdo;
    }

    protected void newMolecule() {
        this.newAtomData();
        this.newBondData();
        this.newCrystalData();
    }

    protected void newAtomData() {
        this.atomCounter = 0;
        this.elsym = new Vector();
        this.elid = new Vector();
        this.eltitles = new Vector();
        this.formalCharges = new Vector();
        this.partialCharges = new Vector();
        this.isotope = new Vector();
        this.x3 = new Vector();
        this.y3 = new Vector();
        this.z3 = new Vector();
        this.x2 = new Vector();
        this.y2 = new Vector();
        this.xfract = new Vector();
        this.yfract = new Vector();
        this.zfract = new Vector();
        this.hCounts = new Vector();
        this.atomParities = new Vector();
        this.atomDictRefs = new Vector();
    }

    protected void newBondData() {
        this.bondCounter = 0;
        this.bondid = new Vector();
        this.bondARef1 = new Vector();
        this.bondARef2 = new Vector();
        this.order = new Vector();
        this.bondStereo = new Vector();
        this.bondDictRefs = new Vector();
        this.bondElid = new Vector();
    }

    protected void newCrystalData() {
        this.unitcellparams = new double[6];
        this.cartesianAxesSet = false;
        this.crystalScalar = 0;
        this.a = new double[3];
        this.b = new double[3];
        this.c = new double[3];
    }

    public void startDocument() {
        this.logger.info("Start XML Doc");
        this.cdo.startDocument();
        this.newMolecule();
        this.BUILTIN = "";
        this.curRef = 0;
    }

    public void endDocument() {
        this.cdo.endDocument();
        this.logger.info("End XML Doc");
    }

    public void startElement(CMLStack xpath, String uri, String local, String raw, Attributes atts) {
        String att;
        int i;
        String name = local;
        this.logger.debug("StartElement");
        this.currentChars = "";
        this.BUILTIN = "";
        this.DICTREF = "";
        for (i = 0; i < atts.getLength(); ++i) {
            String qname = atts.getQName(i);
            if (qname.equals("builtin")) {
                this.BUILTIN = atts.getValue(i);
                this.logger.debug(name, "->BUILTIN found: ", atts.getValue(i));
                continue;
            }
            if (qname.equals("dictRef")) {
                this.DICTREF = atts.getValue(i);
                this.logger.debug(name, "->DICTREF found: ", atts.getValue(i));
                continue;
            }
            if (qname.equals("title")) {
                this.elementTitle = atts.getValue(i);
                this.logger.debug(name, "->TITLE found: ", atts.getValue(i));
                continue;
            }
            this.logger.debug((Object)"Qname: ", qname);
        }
        if ("atom".equals(name)) {
            ++this.atomCounter;
            for (i = 0; i < atts.getLength(); ++i) {
                StringTokenizer tokenizer;
                att = atts.getQName(i);
                String value = atts.getValue(i);
                if (att.equals("id")) {
                    this.elid.addElement(value);
                    continue;
                }
                if (att.equals("elementType")) {
                    this.elsym.addElement(value);
                    continue;
                }
                if (att.equals("title")) {
                    this.eltitles.addElement(value);
                    continue;
                }
                if (att.equals("x2")) {
                    this.x2.addElement(value);
                    continue;
                }
                if (att.equals("xy2")) {
                    tokenizer = new StringTokenizer(value);
                    this.x2.addElement(tokenizer.nextToken());
                    this.y2.addElement(tokenizer.nextToken());
                    continue;
                }
                if (att.equals("xyzFract")) {
                    tokenizer = new StringTokenizer(value);
                    this.xfract.addElement(tokenizer.nextToken());
                    this.yfract.addElement(tokenizer.nextToken());
                    this.zfract.addElement(tokenizer.nextToken());
                    continue;
                }
                if (att.equals("xyz3")) {
                    tokenizer = new StringTokenizer(value);
                    this.x3.addElement(tokenizer.nextToken());
                    this.y3.addElement(tokenizer.nextToken());
                    this.z3.addElement(tokenizer.nextToken());
                    continue;
                }
                if (att.equals("y2")) {
                    this.y2.addElement(value);
                    continue;
                }
                if (att.equals("x3")) {
                    this.x3.addElement(value);
                    continue;
                }
                if (att.equals("y3")) {
                    this.y3.addElement(value);
                    continue;
                }
                if (att.equals("z3")) {
                    this.z3.addElement(value);
                    continue;
                }
                if (att.equals("xFract")) {
                    this.xfract.addElement(value);
                    continue;
                }
                if (att.equals("yFract")) {
                    this.yfract.addElement(value);
                    continue;
                }
                if (att.equals("zFract")) {
                    this.zfract.addElement(value);
                    continue;
                }
                if (att.equals("formalCharge")) {
                    this.formalCharges.addElement(value);
                    continue;
                }
                if (att.equals("hydrogenCount")) {
                    this.hCounts.addElement(value);
                    continue;
                }
                if (att.equals("isotope")) {
                    this.isotope.addElement(value);
                    continue;
                }
                if (att.equals("dictRef")) {
                    this.atomDictRefs.addElement(value);
                    continue;
                }
                this.logger.warn("Unparsed attribute: " + att);
            }
        } else if ("atomArray".equals(name)) {
            boolean atomsCounted = false;
            for (int i2 = 0; i2 < atts.getLength(); ++i2) {
                String att2 = atts.getQName(i2);
                int count = 0;
                if (att2.equals("atomID")) {
                    count = this.addArrayElementsTo(this.elid, atts.getValue(i2));
                } else if (att2.equals("elementType")) {
                    count = this.addArrayElementsTo(this.elsym, atts.getValue(i2));
                } else if (att2.equals("x2")) {
                    count = this.addArrayElementsTo(this.x2, atts.getValue(i2));
                } else if (att2.equals("y2")) {
                    count = this.addArrayElementsTo(this.y2, atts.getValue(i2));
                } else if (att2.equals("x3")) {
                    count = this.addArrayElementsTo(this.x3, atts.getValue(i2));
                } else if (att2.equals("y3")) {
                    count = this.addArrayElementsTo(this.y3, atts.getValue(i2));
                } else if (att2.equals("z3")) {
                    count = this.addArrayElementsTo(this.z3, atts.getValue(i2));
                } else if (att2.equals("xFract")) {
                    count = this.addArrayElementsTo(this.xfract, atts.getValue(i2));
                } else if (att2.equals("yFract")) {
                    count = this.addArrayElementsTo(this.yfract, atts.getValue(i2));
                } else if (att2.equals("zFract")) {
                    count = this.addArrayElementsTo(this.zfract, atts.getValue(i2));
                } else {
                    this.logger.warn("Unparsed attribute: " + att2);
                }
                if (atomsCounted) continue;
                this.atomCounter += count;
                atomsCounted = true;
            }
        } else if ("bond".equals(name)) {
            ++this.bondCounter;
            for (i = 0; i < atts.getLength(); ++i) {
                att = atts.getQName(i);
                this.logger.debug("B2 ", att, "=", atts.getValue(i));
                if (att.equals("id")) {
                    this.bondid.addElement(atts.getValue(i));
                    this.logger.debug((Object)"B3 ", this.bondid);
                    continue;
                }
                if (att.equals("atomRefs") || att.equals("atomRefs2")) {
                    try {
                        StringTokenizer st = new StringTokenizer(atts.getValue(i));
                        this.bondARef1.addElement((String)st.nextElement());
                        this.bondARef2.addElement((String)st.nextElement());
                    }
                    catch (Exception e) {
                        this.logger.error((Object)"Error in CML file: ", e.getMessage());
                        this.logger.debug(e);
                    }
                    continue;
                }
                if (att.equals("order")) {
                    this.order.addElement(atts.getValue(i).trim());
                    continue;
                }
                if (!att.equals("dictRef")) continue;
                this.bondDictRefs.addElement(atts.getValue(i).trim());
            }
            this.stereoGiven = false;
            this.curRef = 0;
        } else if ("bondArray".equals(name)) {
            boolean bondsCounted = false;
            for (int i3 = 0; i3 < atts.getLength(); ++i3) {
                String att3 = atts.getQName(i3);
                int count = 0;
                if (att3.equals("bondID")) {
                    count = this.addArrayElementsTo(this.bondid, atts.getValue(i3));
                } else if (att3.equals("atomRefs1")) {
                    count = this.addArrayElementsTo(this.bondARef1, atts.getValue(i3));
                } else if (att3.equals("atomRefs2")) {
                    count = this.addArrayElementsTo(this.bondARef2, atts.getValue(i3));
                } else if (att3.equals("atomRef1")) {
                    count = this.addArrayElementsTo(this.bondARef1, atts.getValue(i3));
                } else if (att3.equals("atomRef2")) {
                    count = this.addArrayElementsTo(this.bondARef2, atts.getValue(i3));
                } else if (att3.equals("order")) {
                    count = this.addArrayElementsTo(this.order, atts.getValue(i3));
                } else {
                    this.logger.warn("Unparsed attribute: " + att3);
                }
                if (bondsCounted) continue;
                this.bondCounter += count;
                bondsCounted = true;
            }
            this.curRef = 0;
        } else if ("molecule".equals(name)) {
            this.newMolecule();
            this.BUILTIN = "";
            this.cdo.startObject("Molecule");
            for (i = 0; i < atts.getLength(); ++i) {
                att = atts.getQName(i);
                String value = atts.getValue(i);
                if (!att.equals("id")) continue;
                this.cdo.setObjectProperty("Molecule", "id", atts.getValue(i));
            }
        } else if ("crystal".equals(name)) {
            this.newCrystalData();
            this.cdo.startObject("Crystal");
            for (i = 0; i < atts.getLength(); ++i) {
                att = atts.getQName(i);
                if (!att.equals("z")) continue;
                this.cdo.setObjectProperty("Crystal", "z", atts.getValue(i));
            }
        } else if ("symmetry".equals(name)) {
            for (i = 0; i < atts.getLength(); ++i) {
                att = atts.getQName(i);
                if (!att.equals("spaceGroup")) continue;
                this.cdo.setObjectProperty("Crystal", "spacegroup", atts.getValue(i));
            }
        } else if ("scalar".equals(name)) {
            if (xpath.toString().endsWith("crystal/scalar/")) {
                ++this.crystalScalar;
            }
        } else if ("list".equals(name)) {
            this.cdo.startObject("SetOfMolecules");
        }
    }

    public void endElement(CMLStack xpath, String uri, String name, String raw) {
        this.logger.debug((Object)"EndElement: ", name);
        String cData = this.currentChars;
        if ("bond".equals(name)) {
            if (!this.stereoGiven) {
                this.bondStereo.addElement("");
            }
            if (this.bondStereo.size() > this.bondDictRefs.size()) {
                this.bondDictRefs.addElement(null);
            }
        } else if ("atom".equals(name)) {
            if (this.atomCounter > this.eltitles.size()) {
                this.eltitles.addElement(null);
            }
            if (this.atomCounter > this.hCounts.size()) {
                this.hCounts.addElement("0");
            }
            if (this.atomCounter > this.atomDictRefs.size()) {
                this.atomDictRefs.addElement(null);
            }
            if (this.atomCounter > this.isotope.size()) {
                this.isotope.addElement(null);
            }
            if (this.atomCounter > this.formalCharges.size()) {
                this.formalCharges.addElement("0");
            }
            if (this.atomCounter > this.x2.size() && this.x2.size() != 0) {
                this.x2.addElement(null);
                this.y2.addElement(null);
            }
            if (this.atomCounter > this.x3.size() && this.x3.size() != 0) {
                this.x3.addElement(null);
                this.y3.addElement(null);
                this.z3.addElement(null);
            }
            if (this.atomCounter > this.xfract.size() && this.xfract.size() != 0) {
                this.xfract.addElement(null);
                this.yfract.addElement(null);
                this.zfract.addElement(null);
            }
        } else if ("molecule".equals(name)) {
            this.storeData();
            this.cdo.endObject("Molecule");
        } else if ("crystal".equals(name)) {
            if (this.crystalScalar > 0) {
                double[][] axes = CrystalGeometryTools.notionalToCartesian(this.unitcellparams[0], this.unitcellparams[1], this.unitcellparams[2], this.unitcellparams[3], this.unitcellparams[4], this.unitcellparams[5]);
                this.a[0] = axes[0][0];
                this.a[1] = axes[0][1];
                this.a[2] = axes[0][2];
                this.b[0] = axes[1][0];
                this.b[1] = axes[1][1];
                this.b[2] = axes[1][2];
                this.c[0] = axes[2][0];
                this.c[1] = axes[2][1];
                this.c[2] = axes[2][2];
                this.cartesianAxesSet = true;
                this.cdo.startObject("a-axis");
                this.cdo.setObjectProperty("a-axis", "x", new Double(this.a[0]).toString());
                this.cdo.setObjectProperty("a-axis", "y", new Double(this.a[1]).toString());
                this.cdo.setObjectProperty("a-axis", "z", new Double(this.a[2]).toString());
                this.cdo.endObject("a-axis");
                this.cdo.startObject("b-axis");
                this.cdo.setObjectProperty("b-axis", "x", new Double(this.b[0]).toString());
                this.cdo.setObjectProperty("b-axis", "y", new Double(this.b[1]).toString());
                this.cdo.setObjectProperty("b-axis", "z", new Double(this.b[2]).toString());
                this.cdo.endObject("b-axis");
                this.cdo.startObject("c-axis");
                this.cdo.setObjectProperty("c-axis", "x", new Double(this.c[0]).toString());
                this.cdo.setObjectProperty("c-axis", "y", new Double(this.c[1]).toString());
                this.cdo.setObjectProperty("c-axis", "z", new Double(this.c[2]).toString());
                this.cdo.endObject("c-axis");
            } else {
                this.logger.error("Could not find crystal unit cell parameters");
            }
            this.cdo.endObject("Crystal");
        } else if ("list".equals(name)) {
            this.cdo.endObject("SetOfMolecules");
        } else if ("coordinate3".equals(name)) {
            if (this.BUILTIN.equals("xyz3")) {
                this.logger.debug((Object)"New coord3 xyz3 found: ", this.currentChars);
                try {
                    StringTokenizer st = new StringTokenizer(this.currentChars);
                    this.x3.addElement(st.nextToken());
                    this.y3.addElement(st.nextToken());
                    this.z3.addElement(st.nextToken());
                    this.logger.debug((Object)"coord3 x3.length: ", this.x3.size());
                    this.logger.debug((Object)"coord3 y3.length: ", this.y3.size());
                    this.logger.debug((Object)"coord3 z3.length: ", this.z3.size());
                }
                catch (Exception exception) {
                    this.logger.error("CMLParsing error while setting coordinate3!");
                    this.logger.debug(exception);
                }
            } else {
                this.logger.warn("Unknown coordinate3 BUILTIN: " + this.BUILTIN);
            }
        } else if ("string".equals(name)) {
            if (this.BUILTIN.equals("elementType")) {
                this.logger.debug((Object)"Element: ", cData.trim());
                this.elsym.addElement(cData);
            } else if (this.BUILTIN.equals("atomRef")) {
                ++this.curRef;
                this.logger.debug((Object)"Bond: ref #", this.curRef);
                if (this.curRef == 1) {
                    this.bondARef1.addElement(cData.trim());
                } else if (this.curRef == 2) {
                    this.bondARef2.addElement(cData.trim());
                }
            } else if (this.BUILTIN.equals("order")) {
                this.logger.debug((Object)"Bond: order ", cData.trim());
                this.order.addElement(cData.trim());
            } else if (this.BUILTIN.equals("formalCharge")) {
                this.logger.warn("formalCharge BUILTIN accepted but violating CML DTD");
                this.logger.debug((Object)"Charge: ", cData.trim());
                String charge = cData.trim();
                if (charge.startsWith("+") && charge.length() > 1) {
                    charge = charge.substring(1);
                }
                this.formalCharges.addElement(charge);
            }
        } else if ("float".equals(name)) {
            if (this.BUILTIN.equals("x3")) {
                this.x3.addElement(cData.trim());
            } else if (this.BUILTIN.equals("y3")) {
                this.y3.addElement(cData.trim());
            } else if (this.BUILTIN.equals("z3")) {
                this.z3.addElement(cData.trim());
            } else if (this.BUILTIN.equals("x2")) {
                this.x2.addElement(cData.trim());
            } else if (this.BUILTIN.equals("y2")) {
                this.y2.addElement(cData.trim());
            } else if (this.BUILTIN.equals("order")) {
                this.order.addElement(cData.trim());
            } else if (this.BUILTIN.equals("charge") || this.BUILTIN.equals("partialCharge")) {
                this.partialCharges.addElement(cData.trim());
            }
        } else if ("integer".equals(name)) {
            if (this.BUILTIN.equals("formalCharge")) {
                this.formalCharges.addElement(cData.trim());
            }
        } else if ("coordinate2".equals(name)) {
            if (this.BUILTIN.equals("xy2")) {
                this.logger.debug((Object)"New coord2 xy2 found.", cData);
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    this.x2.addElement(st.nextToken());
                    this.y2.addElement(st.nextToken());
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 175, 1);
                }
            }
        } else if ("stringArray".equals(name)) {
            if (this.BUILTIN.equals("id") || this.BUILTIN.equals("atomId") || this.BUILTIN.equals("atomID")) {
                try {
                    boolean countAtoms = this.atomCounter == 0;
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        if (countAtoms) {
                            ++this.atomCounter;
                        }
                        String token = st.nextToken();
                        this.logger.debug((Object)"StringArray (Token): ", token);
                        this.elid.addElement(token);
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 186, 1);
                }
            } else if (this.BUILTIN.equals("elementType")) {
                try {
                    boolean countAtoms = this.atomCounter == 0;
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        if (countAtoms) {
                            ++this.atomCounter;
                        }
                        this.elsym.addElement(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 194, 1);
                }
            } else if (this.BUILTIN.equals("atomRefs")) {
                ++this.curRef;
                this.logger.debug((Object)"New atomRefs found: ", this.curRef);
                try {
                    boolean countBonds = this.bondCounter == 0;
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        if (countBonds) {
                            ++this.bondCounter;
                        }
                        String token = st.nextToken();
                        this.logger.debug((Object)"Token: ", token);
                        if (this.curRef == 1) {
                            this.bondARef1.addElement(token);
                            continue;
                        }
                        if (this.curRef != 2) continue;
                        this.bondARef2.addElement(token);
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 194, 1);
                }
            } else if (this.BUILTIN.equals("atomRef")) {
                ++this.curRef;
                this.logger.debug((Object)"New atomRef found: ", this.curRef);
                try {
                    boolean countBonds = this.bondCounter == 0;
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        if (countBonds) {
                            ++this.bondCounter;
                        }
                        String token = st.nextToken();
                        this.logger.debug((Object)"Token: ", token);
                        if (this.curRef == 1) {
                            this.bondARef1.addElement(token);
                            continue;
                        }
                        if (this.curRef != 2) continue;
                        this.bondARef2.addElement(token);
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 194, 1);
                }
            } else if (this.BUILTIN.equals("order")) {
                this.logger.debug("New bond order found.");
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        this.logger.debug((Object)"Token: ", token);
                        this.order.addElement(token);
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 194, 1);
                }
            }
        } else if ("integerArray".equals(name)) {
            this.logger.debug((Object)"IntegerArray: builtin = ", this.BUILTIN);
            if (this.BUILTIN.equals("formalCharge")) {
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        this.logger.debug((Object)"Charge added: ", token);
                        this.formalCharges.addElement(token);
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 205, 1);
                }
            }
        } else if ("scalar".equals(name)) {
            if (xpath.toString().endsWith("crystal/scalar/")) {
                this.logger.debug("Going to set a crystal parameter: " + this.crystalScalar, " to ", cData);
                try {
                    this.unitcellparams[this.crystalScalar - 1] = Double.parseDouble(cData.trim());
                }
                catch (NumberFormatException exception) {
                    this.logger.error("Content must a float: " + cData);
                }
            } else if (xpath.toString().endsWith("bond/scalar/")) {
                if (this.DICTREF.equals("mdl:stereo")) {
                    this.bondStereo.addElement(cData.trim());
                }
            } else {
                this.logger.warn("Ignoring scaler: " + xpath);
            }
        } else if ("floatArray".equals(name)) {
            if (this.BUILTIN.equals("x3")) {
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.x3.addElement(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 205, 1);
                }
            } else if (this.BUILTIN.equals("y3")) {
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.y3.addElement(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 213, 1);
                }
            } else if (this.BUILTIN.equals("z3")) {
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.z3.addElement(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 221, 1);
                }
            } else if (this.BUILTIN.equals("x2")) {
                this.logger.debug("New floatArray found.");
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.x2.addElement(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 205, 1);
                }
            } else if (this.BUILTIN.equals("y2")) {
                this.logger.debug("New floatArray found.");
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.y2.addElement(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 454, 1);
                }
            } else if (this.BUILTIN.equals("partialCharge")) {
                this.logger.debug("New floatArray with partial charges found.");
                try {
                    StringTokenizer st = new StringTokenizer(cData);
                    while (st.hasMoreTokens()) {
                        this.partialCharges.addElement(st.nextToken());
                    }
                }
                catch (Exception e) {
                    this.notify("CMLParsing error: " + e, "CML-1999-05-15", 462, 1);
                }
            }
        } else {
            this.logger.warn("Skipping element: " + name);
        }
        this.currentChars = "";
        this.BUILTIN = "";
        this.elementTitle = "";
    }

    public void characterData(CMLStack xpath, char[] ch, int start, int length) {
        this.currentChars = this.currentChars + new String(ch, start, length);
        this.logger.debug((Object)"CD: ", this.currentChars);
    }

    protected void notify(String message, String systemId, int line, int column) {
        this.logger.debug((Object)"Message: ", message);
        this.logger.debug((Object)"SystemId: ", systemId);
        this.logger.debug((Object)"Line: ", line);
        this.logger.debug((Object)"Column: ", column);
    }

    protected void storeData() {
        this.storeAtomData();
        this.storeBondData();
    }

    protected void storeAtomData() {
        this.logger.debug((Object)"No atoms: ", this.atomCounter);
        if (this.atomCounter == 0) {
            return;
        }
        boolean hasID = false;
        boolean has3D = false;
        boolean has3Dfract = false;
        boolean has2D = false;
        boolean hasFormalCharge = false;
        boolean hasPartialCharge = false;
        boolean hasHCounts = false;
        boolean hasSymbols = false;
        boolean hasTitles = false;
        boolean hasIsotopes = false;
        boolean hasDictRefs = false;
        if (this.elid.size() == this.atomCounter) {
            hasID = true;
        } else {
            this.logger.debug((Object)("No atom ids: " + this.elid.size()), " != " + this.atomCounter);
        }
        if (this.elsym.size() == this.atomCounter) {
            hasSymbols = true;
        } else {
            this.logger.debug((Object)("No atom symbols: " + this.elsym.size()), " != " + this.atomCounter);
        }
        if (this.eltitles.size() == this.atomCounter) {
            hasTitles = true;
        } else {
            this.logger.debug((Object)("No atom titles: " + this.eltitles.size()), " != " + this.atomCounter);
        }
        if (this.x3.size() == this.atomCounter && this.y3.size() == this.atomCounter && this.z3.size() == this.atomCounter) {
            has3D = true;
        } else {
            this.logger.debug("No 3D info: " + this.x3.size(), " " + this.y3.size(), " " + this.z3.size(), " != " + this.atomCounter);
        }
        if (this.xfract.size() == this.atomCounter && this.yfract.size() == this.atomCounter && this.zfract.size() == this.atomCounter) {
            has3Dfract = true;
        } else {
            this.logger.debug("No 3D fractional info: " + this.xfract.size(), " " + this.yfract.size(), " " + this.zfract.size(), " != " + this.atomCounter);
        }
        if (this.x2.size() == this.atomCounter && this.y2.size() == this.atomCounter) {
            has2D = true;
        } else {
            this.logger.debug("No 2D info: " + this.x2.size(), " " + this.y2.size(), " != " + this.atomCounter);
        }
        if (this.formalCharges.size() == this.atomCounter) {
            hasFormalCharge = true;
        } else {
            this.logger.debug((Object)("No formal Charge info: " + this.formalCharges.size()), " != " + this.atomCounter);
        }
        if (this.partialCharges.size() == this.atomCounter) {
            hasPartialCharge = true;
        } else {
            this.logger.debug((Object)("No partial Charge info: " + this.partialCharges.size()), " != " + this.atomCounter);
        }
        if (this.hCounts.size() == this.atomCounter) {
            hasHCounts = true;
        } else {
            this.logger.debug((Object)("No hydrogen Count info: " + this.hCounts.size()), " != " + this.atomCounter);
        }
        if (this.atomDictRefs.size() == this.atomCounter) {
            hasDictRefs = true;
        } else {
            this.logger.debug((Object)("No dictRef info: " + this.atomDictRefs.size()), " != " + this.atomCounter);
        }
        if (this.isotope.size() == this.atomCounter) {
            hasIsotopes = true;
        } else {
            this.logger.debug((Object)("No isotope info: " + this.isotope.size()), " != " + this.atomCounter);
        }
        for (int i = 0; i < this.atomCounter; ++i) {
            String symbol;
            this.logger.info((Object)"Storing atom: ", i);
            this.cdo.startObject("Atom");
            if (hasID) {
                this.cdo.setObjectProperty("Atom", "id", (String)this.elid.elementAt(i));
            }
            if (hasTitles) {
                if (hasSymbols) {
                    symbol = (String)this.elsym.elementAt(i);
                    if (symbol.equals("Du") || symbol.equals("Dummy")) {
                        this.cdo.setObjectProperty("PseudoAtom", "label", (String)this.eltitles.elementAt(i));
                    } else {
                        this.cdo.setObjectProperty("Atom", "title", (String)this.eltitles.elementAt(i));
                    }
                } else {
                    this.cdo.setObjectProperty("Atom", "title", (String)this.eltitles.elementAt(i));
                }
            }
            if (hasSymbols) {
                symbol = (String)this.elsym.elementAt(i);
                if (symbol.equals("Du") || symbol.equals("Dummy")) {
                    symbol = "R";
                }
                this.cdo.setObjectProperty("Atom", "type", symbol);
            }
            if (has3D) {
                this.cdo.setObjectProperty("Atom", "x3", (String)this.x3.elementAt(i));
                this.cdo.setObjectProperty("Atom", "y3", (String)this.y3.elementAt(i));
                this.cdo.setObjectProperty("Atom", "z3", (String)this.z3.elementAt(i));
            }
            if (has3Dfract) {
                this.cdo.setObjectProperty("Atom", "xFract", (String)this.xfract.elementAt(i));
                this.cdo.setObjectProperty("Atom", "yFract", (String)this.yfract.elementAt(i));
                this.cdo.setObjectProperty("Atom", "zFract", (String)this.zfract.elementAt(i));
            }
            if (hasFormalCharge) {
                this.cdo.setObjectProperty("Atom", "formalCharge", (String)this.formalCharges.elementAt(i));
            }
            if (hasPartialCharge) {
                this.logger.debug("Storing partial atomic charge...");
                this.cdo.setObjectProperty("Atom", "partialCharge", (String)this.partialCharges.elementAt(i));
            }
            if (hasHCounts) {
                this.cdo.setObjectProperty("Atom", "hydrogenCount", (String)this.hCounts.elementAt(i));
            }
            if (has2D) {
                if (this.x2.elementAt(i) != null) {
                    this.cdo.setObjectProperty("Atom", "x2", (String)this.x2.elementAt(i));
                }
                if (this.y2.elementAt(i) != null) {
                    this.cdo.setObjectProperty("Atom", "y2", (String)this.y2.elementAt(i));
                }
            }
            if (hasDictRefs) {
                this.cdo.setObjectProperty("Atom", "dictRef", (String)this.atomDictRefs.elementAt(i));
            }
            if (hasIsotopes) {
                this.cdo.setObjectProperty("Atom", "massNumber", (String)this.isotope.elementAt(i));
            }
            this.cdo.endObject("Atom");
        }
        if (this.elid.size() > 0) {
            this.bondElid = this.elid;
        }
        this.newAtomData();
    }

    protected void storeBondData() {
        this.logger.debug("Testing a1,a2,stereo,order = count: " + this.bondARef1.size(), "," + this.bondARef2.size(), "," + this.bondStereo.size(), "," + this.order.size(), "=" + this.bondCounter);
        if (this.bondARef1.size() == this.bondCounter && this.bondARef2.size() == this.bondCounter) {
            this.logger.debug((Object)"About to add bond info to ", this.cdo.getClass().getName());
            Enumeration orders = this.order.elements();
            Enumeration ids = this.bondid.elements();
            Enumeration bar1s = this.bondARef1.elements();
            Enumeration bar2s = this.bondARef2.elements();
            Enumeration stereos = this.bondStereo.elements();
            while (bar1s.hasMoreElements()) {
                this.cdo.startObject("Bond");
                if (ids.hasMoreElements()) {
                    this.cdo.setObjectProperty("Bond", "id", (String)ids.nextElement());
                }
                this.cdo.setObjectProperty("Bond", "atom1", new Integer(this.bondElid.indexOf((String)bar1s.nextElement())).toString());
                this.cdo.setObjectProperty("Bond", "atom2", new Integer(this.bondElid.indexOf((String)bar2s.nextElement())).toString());
                if (orders.hasMoreElements()) {
                    String bondOrder = (String)orders.nextElement();
                    if ("S".equals(bondOrder)) {
                        this.cdo.setObjectProperty("Bond", "order", "1");
                    } else if ("D".equals(bondOrder)) {
                        this.cdo.setObjectProperty("Bond", "order", "2");
                    } else if ("T".equals(bondOrder)) {
                        this.cdo.setObjectProperty("Bond", "order", "3");
                    } else if ("A".equals(bondOrder)) {
                        this.cdo.setObjectProperty("Bond", "order", "1.5");
                    } else {
                        this.cdo.setObjectProperty("Bond", "order", bondOrder);
                    }
                }
                if (stereos.hasMoreElements()) {
                    this.cdo.setObjectProperty("Bond", "stereo", (String)stereos.nextElement());
                }
                this.cdo.endObject("Bond");
            }
        }
        this.newBondData();
    }

    private int addArrayElementsTo(Vector toAddto, String array) {
        StringTokenizer tokenizer = new StringTokenizer(array);
        int i = 0;
        while (tokenizer.hasMoreElements()) {
            toAddto.addElement(tokenizer.nextToken());
            ++i;
        }
        return i;
    }
}

