/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.cml;

import org.openscience.cdk.tools.LoggingTool;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CMLErrorHandler
implements ErrorHandler {
    private LoggingTool logger = new LoggingTool(this.getClass().getName());
    public boolean reportErrors = true;
    public boolean abortOnErrors = false;

    public CMLErrorHandler() {
        this.logger.info("instantiated");
    }

    private void print(String level, SAXParseException exception) {
        if (level.equals("warning")) {
            this.logger.warn("** " + level + ": " + exception.getMessage());
            this.logger.warn("   URI  = " + exception.getSystemId());
            this.logger.warn("   line = " + exception.getLineNumber());
        } else {
            this.logger.error("** " + level + ": " + exception.getMessage());
            this.logger.error("   URI  = " + exception.getSystemId());
            this.logger.error("   line = " + exception.getLineNumber());
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.reportErrors) {
            this.print("error", exception);
        }
        if (this.abortOnErrors) {
            throw exception;
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        if (this.reportErrors) {
            this.print("fatal", exception);
        }
        if (this.abortOnErrors) {
            throw exception;
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (this.reportErrors) {
            this.print("warning", exception);
        }
    }
}

