/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.IOException;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.Isotope;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.SetOfMolecules;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.SaturationChecker;
import org.openscience.cdk.tools.ValencyChecker;
import org.openscience.cdk.tools.ValencyCheckerInterface;

public class HydrogenAdder {
    private LoggingTool logger = new LoggingTool(this);
    private ValencyCheckerInterface valencyChecker;

    public HydrogenAdder() {
        this("org.openscience.cdk.tools.SaturationChecker");
    }

    public HydrogenAdder(String valencyCheckerInterfaceClassName) {
        try {
            if (valencyCheckerInterfaceClassName.equals("org.openscience.cdk.tools.ValencyChecker")) {
                this.valencyChecker = new ValencyChecker();
            } else if (valencyCheckerInterfaceClassName.equals("org.openscience.cdk.tools.SaturationChecker")) {
                this.valencyChecker = new SaturationChecker();
            } else {
                this.logger.error("Cannot instantiate unknown ValencyCheckerInterface; using SaturationChecker");
                this.valencyChecker = new SaturationChecker();
            }
        }
        catch (Exception exception) {
            this.logger.error("Could not intantiate a SaturationChecker.");
            this.logger.debug(exception);
        }
    }

    public void addHydrogensToSatisfyValency(Molecule molecule) throws IOException, ClassNotFoundException, CDKException {
        this.logger.debug("Start of addHydrogensToSatisfyValency");
        this.addExplicitHydrogensToSatisfyValency(molecule);
        this.logger.debug("End of addHydrogensToSatisfyValency");
    }

    public void addExplicitHydrogensToSatisfyValency(Molecule molecule) throws IOException, ClassNotFoundException, CDKException {
        this.logger.debug("Start of addExplicitHydrogensToSatisfyValency");
        SetOfMolecules moleculeSet = ConnectivityChecker.partitionIntoMolecules((AtomContainer)molecule);
        Molecule[] molecules = moleculeSet.getMolecules();
        for (int k = 0; k < molecules.length; ++k) {
            Molecule molPart = molecules[k];
            Atom[] atoms = molPart.getAtoms();
            for (int i = 0; i < atoms.length; ++i) {
                this.addHydrogensToSatisfyValency(molPart, atoms[i], molecule);
            }
        }
        this.logger.debug("End of addExplicitHydrogensToSatisfyValency");
    }

    public void addHydrogensToSatisfyValency(AtomContainer container, Atom atom, AtomContainer totalContainer) throws IOException, ClassNotFoundException, CDKException {
        this.logger.debug("Start of addHydrogensToSatisfyValency(AtomContainer container, Atom atom)");
        this.addExplicitHydrogensToSatisfyValency(container, atom, totalContainer);
        this.logger.debug("End of addHydrogensToSatisfyValency(AtomContainer container, Atom atom)");
    }

    public void addExplicitHydrogensToSatisfyValency(AtomContainer container, Atom atom, AtomContainer totalContainer) throws IOException, ClassNotFoundException, CDKException {
        this.logger.debug("Start of addExplicitHydrogensToSatisfyValency(AtomContainer container, Atom atom)");
        int missingHydrogens = this.valencyChecker.calculateMissingHydrogen(atom, container);
        this.logger.debug("According to valencyChecker, " + missingHydrogens + " are missing");
        this.addExplicitHydrogensToSatisfyValency(container, atom, missingHydrogens, totalContainer);
        this.logger.debug("End of addExplicitHydrogensToSatisfyValency(AtomContainer container, Atom atom)");
    }

    public void addExplicitHydrogensToSatisfyValency(AtomContainer container, Atom atom, int count, AtomContainer totalContainer) throws IOException, ClassNotFoundException {
        boolean create2DCoordinates = GeometryTools.has2DCoordinates(container);
        boolean create3DCoordinates = GeometryTools.has3DCoordinates(container);
        Isotope isotope = IsotopeFactory.getInstance().getMajorIsotope("H");
        atom.setHydrogenCount(0);
        for (int i = 1; i <= count; ++i) {
            Atom hydrogen = new Atom("H");
            IsotopeFactory.getInstance().configure(hydrogen, isotope);
            totalContainer.addAtom(hydrogen);
            Bond newBond = new Bond(atom, hydrogen, 1.0);
            totalContainer.addBond(newBond);
        }
    }

    public void addImplicitHydrogensToSatisfyValency(AtomContainer container) throws CDKException {
        SetOfMolecules moleculeSet = ConnectivityChecker.partitionIntoMolecules((AtomContainer)container);
        Molecule[] molecules = moleculeSet.getMolecules();
        for (int k = 0; k < molecules.length; ++k) {
            Molecule molPart = molecules[k];
            Atom[] atoms = molPart.getAtoms();
            for (int f = 0; f < atoms.length; ++f) {
                this.addImplicitHydrogensToSatisfyValency(molPart, atoms[f]);
            }
        }
    }

    public void addImplicitHydrogensToSatisfyValency(AtomContainer container, Atom atom) throws CDKException {
        int missingHydrogens = this.valencyChecker.calculateMissingHydrogen(atom, container);
        atom.setHydrogenCount(missingHydrogens);
    }

    public void addImplicitHydrogensToSatisfyValency(Atom atom) throws CDKException {
        int missingHydrogens = this.valencyChecker.calculateMissingHydrogen(atom);
        atom.setHydrogenCount(missingHydrogens);
    }
}

