/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools;

import java.io.IOException;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.AtomType;
import org.openscience.cdk.Bond;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.tools.LoggingTool;
import org.openscience.cdk.tools.ValencyCheckerInterface;

public class ValencyChecker
implements ValencyCheckerInterface {
    private final String atomTypeList = "org/openscience/cdk/config/data/valency_atomtypes.xml";
    private AtomTypeFactory structgenATF = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/valency_atomtypes.xml");
    private LoggingTool logger = new LoggingTool(this);

    public ValencyChecker() throws IOException, ClassNotFoundException {
        this.logger.info((Object)"Using configuration file: ", "org/openscience/cdk/config/data/valency_atomtypes.xml");
    }

    public boolean isSaturated(Atom atom, AtomContainer container) throws CDKException {
        if (atom instanceof PseudoAtom) {
            this.logger.debug("don't figure it out... it simply does not lack H's");
            return true;
        }
        AtomType[] atomTypes = this.structgenATF.getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            this.logger.warn((Object)"Missing entry in atom type list for ", atom.getSymbol());
            return true;
        }
        double bondOrderSum = container.getBondOrderSum(atom);
        double maxBondOrder = container.getMaximumBondOrder(atom);
        int hcount = atom.getHydrogenCount();
        int charge = atom.getFormalCharge();
        this.logger.debug((Object)"Checking saturation of atom ", atom.getSymbol());
        this.logger.debug((Object)"bondOrderSum: ", bondOrderSum);
        this.logger.debug((Object)"maxBondOrder: ", maxBondOrder);
        this.logger.debug((Object)"hcount: ", hcount);
        this.logger.debug((Object)"charge: ", charge);
        boolean elementPlusChargeMatches = false;
        for (int f = 0; f < atomTypes.length; ++f) {
            AtomType type = atomTypes[f];
            if (charge != type.getFormalCharge()) continue;
            if (bondOrderSum + (double)hcount == type.getBondOrderSum() && maxBondOrder <= type.getMaxBondOrder()) {
                this.logger.debug((Object)"We have a match! : ", type);
                return true;
            }
            elementPlusChargeMatches = true;
        }
        if (elementPlusChargeMatches) {
            this.logger.debug("No, atom is not saturated.");
            return false;
        }
        throw new CDKException("The atom with element " + atom.getSymbol() + "and charge " + charge + " is not found.");
    }

    public boolean couldMatchAtomType(AtomContainer container, Atom atom, AtomType type) {
        this.logger.debug("   ... matching atom ", atom.getSymbol(), " vs ", type);
        double bondOrderSum = container.getBondOrderSum(atom);
        double maxBondOrder = container.getMaximumBondOrder(atom);
        int hcount = atom.getHydrogenCount();
        int charge = atom.getFormalCharge();
        if (charge == type.getFormalCharge() && bondOrderSum + (double)hcount <= type.getBondOrderSum() && maxBondOrder <= type.getMaxBondOrder()) {
            this.logger.debug("    We have a match!");
            return true;
        }
        this.logger.debug("    No Match");
        return false;
    }

    public int calculateMissingHydrogen(Atom atom, AtomContainer container) throws CDKException {
        return this.calculateMissingHydrogen(atom, container.getBondOrderSum(atom), container.getMaximumBondOrder(atom));
    }

    public int calculateMissingHydrogen(Atom atom) throws CDKException {
        return this.calculateMissingHydrogen(atom, 0.0, 0.0);
    }

    public int calculateMissingHydrogen(Atom atom, double bondOrderSum, double maxBondOrder) throws CDKException {
        int missingHydrogen = 0;
        if (atom instanceof PseudoAtom) {
            this.logger.debug("don't figure it out... it simply does not lack H's");
            return 0;
        }
        this.logger.debug("Calculating number of missing hydrogen atoms");
        AtomType[] atomTypes = this.structgenATF.getAtomTypes(atom.getSymbol());
        if (atomTypes.length == 0) {
            this.logger.warn((Object)"Element not found in configuration file: ", atom);
            return 0;
        }
        int hcount = atom.getHydrogenCount();
        int charge = atom.getFormalCharge();
        this.logger.debug((Object)"Found atomtypes: ", atomTypes.length);
        for (int f = 0; f < atomTypes.length; ++f) {
            AtomType type = atomTypes[f];
            if (charge != type.getFormalCharge() || !(bondOrderSum + (double)hcount <= type.getBondOrderSum()) || !(maxBondOrder <= type.getMaxBondOrder())) continue;
            this.logger.debug((Object)"This type matches: ", type);
            missingHydrogen = (int)(type.getBondOrderSum() - bondOrderSum);
            break;
        }
        this.logger.debug("missing hydrogens: " + missingHydrogen);
        return missingHydrogen;
    }

    public void saturate(AtomContainer atomContainer) throws CDKException {
        boolean succeeded;
        this.logger.info("Saturating atomContainer by adjusting bond orders...");
        boolean allSaturated = this.allSaturated(atomContainer);
        if (!allSaturated && !(succeeded = this.saturate(atomContainer.getBonds(), atomContainer))) {
            throw new CDKException("Could not saturate this atomContainer!");
        }
    }

    public boolean saturate(Bond[] bonds, AtomContainer atomContainer) throws CDKException {
        this.logger.debug((Object)"Saturating bond set of size: ", bonds.length);
        boolean bondsAreFullySaturated = true;
        if (bonds.length > 0) {
            Bond bond = bonds[0];
            int leftBondCount = bonds.length - 1;
            Bond[] leftBonds = new Bond[leftBondCount];
            System.arraycopy(bonds, 1, leftBonds, 0, leftBondCount);
            if (this.isUnsaturated(bond, atomContainer)) {
                if (leftBondCount > 0) {
                    this.logger.debug((Object)"Recursing with unsaturated bond with #bonds: ", leftBondCount);
                    bondsAreFullySaturated = this.saturate(leftBonds, atomContainer) && !this.isUnsaturated(bond, atomContainer);
                } else {
                    bondsAreFullySaturated = false;
                }
                if (!bondsAreFullySaturated) {
                    this.logger.debug("First try did not work...");
                    boolean couldSaturate = this.saturate(bond, atomContainer);
                    if (couldSaturate) {
                        if (leftBondCount > 0) {
                            this.logger.debug((Object)"Recursing with saturated bond with #bonds: ", leftBondCount);
                            bondsAreFullySaturated = this.saturate(leftBonds, atomContainer);
                        } else {
                            bondsAreFullySaturated = true;
                        }
                    } else {
                        bondsAreFullySaturated = false;
                    }
                }
            } else if (this.isSaturated(bond, atomContainer)) {
                this.logger.debug("This bond is already saturated.");
                if (leftBondCount > 0) {
                    this.logger.debug((Object)"Recursing with #bonds: ", leftBondCount);
                    bondsAreFullySaturated = this.saturate(leftBonds, atomContainer);
                } else {
                    bondsAreFullySaturated = true;
                }
            } else {
                this.logger.debug("Cannot saturate this bond");
                if (leftBondCount > 0) {
                    this.logger.debug((Object)"Recursing with saturated bond with #bonds: ", leftBondCount);
                    bondsAreFullySaturated = this.saturate(leftBonds, atomContainer) && !this.isUnsaturated(bond, atomContainer);
                } else {
                    bondsAreFullySaturated = !this.isUnsaturated(bond, atomContainer);
                }
            }
        }
        this.logger.debug((Object)"Is bond set fully saturated?: ", bondsAreFullySaturated);
        this.logger.debug((Object)"Returning to level: ", bonds.length + 1);
        return bondsAreFullySaturated;
    }

    public boolean saturate(Bond bond, AtomContainer atomContainer) throws CDKException {
        Atom[] atoms = bond.getAtoms();
        Atom atom = atoms[0];
        Atom partner = atoms[1];
        this.logger.debug("  saturating bond: ", atom.getSymbol(), "-", partner.getSymbol());
        AtomType[] atomTypes1 = this.structgenATF.getAtomTypes(atom.getSymbol());
        AtomType[] atomTypes2 = this.structgenATF.getAtomTypes(partner.getSymbol());
        boolean bondOrderIncreased = true;
        while (bondOrderIncreased && !this.isSaturated(bond, atomContainer)) {
            this.logger.debug("Can increase bond order");
            bondOrderIncreased = false;
            for (int atCounter1 = 0; atCounter1 < atomTypes1.length && !bondOrderIncreased; ++atCounter1) {
                AtomType aType1 = atomTypes1[atCounter1];
                this.logger.debug((Object)"  condidering atom type: ", aType1);
                if (!this.couldMatchAtomType(atomContainer, atom, aType1)) continue;
                this.logger.debug((Object)"  trying atom type: ", aType1);
                for (int atCounter2 = 0; atCounter2 < atomTypes2.length && !bondOrderIncreased; ++atCounter2) {
                    AtomType aType2 = atomTypes2[atCounter2];
                    this.logger.debug((Object)"  condidering partner type: ", aType1);
                    if (!this.couldMatchAtomType(atomContainer, partner, atomTypes2[atCounter2])) continue;
                    this.logger.debug((Object)"    with atom type: ", aType2);
                    if (bond.getOrder() >= aType2.getMaxBondOrder() || bond.getOrder() >= aType1.getMaxBondOrder()) {
                        this.logger.debug("Bond order not increased: atoms has reached (or exceeded) maximum bond order for this atom type");
                        continue;
                    }
                    if (!(bond.getOrder() < aType2.getMaxBondOrder()) || !(bond.getOrder() < aType1.getMaxBondOrder())) continue;
                    bond.setOrder(bond.getOrder() + 1.0);
                    this.logger.debug("Bond order now " + bond.getOrder());
                    bondOrderIncreased = true;
                }
            }
        }
        return this.isSaturated(bond, atomContainer);
    }

    public boolean isSaturated(AtomContainer container) throws CDKException {
        return this.allSaturated(container);
    }

    public boolean allSaturated(AtomContainer ac) throws CDKException {
        this.logger.debug("Are all atoms saturated?");
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            if (this.isSaturated(ac.getAtomAt(f), ac)) continue;
            return false;
        }
        return true;
    }

    public boolean isUnsaturated(Bond bond, AtomContainer atomContainer) throws CDKException {
        Atom[] atoms = bond.getAtoms();
        boolean isUnsaturated = true;
        for (int i = 0; i < atoms.length; ++i) {
            isUnsaturated = isUnsaturated && !this.isSaturated(atoms[i], atomContainer);
        }
        return isUnsaturated;
    }

    public boolean isSaturated(Bond bond, AtomContainer atomContainer) throws CDKException {
        Atom[] atoms = bond.getAtoms();
        boolean isSaturated = true;
        for (int i = 0; i < atoms.length; ++i) {
            isSaturated = isSaturated && this.isSaturated(atoms[i], atomContainer);
        }
        return isSaturated;
    }

    public void unsaturate(AtomContainer atomContainer) {
        this.unsaturate(atomContainer.getBonds());
    }

    public void unsaturate(Bond[] bonds) {
        for (int i = 1; i < bonds.length; ++i) {
            bonds[i].setOrder(1.0);
        }
    }
}

