/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ElectronContainer;
import org.openscience.cdk.SetOfAtomContainers;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class SetOfAtomContainersManipulator {
    public static void removeAtomAndConnectedElectronContainers(SetOfAtomContainers set, Atom atom) {
        AtomContainer[] acs = set.getAtomContainers();
        for (int i = 0; i < acs.length; ++i) {
            AtomContainer ac = acs[i];
            if (!ac.contains(atom)) continue;
            ac.removeAtomAndConnectedElectronContainers(atom);
            return;
        }
    }

    public static void removeElectronContainer(SetOfAtomContainers set, ElectronContainer electrons) {
        AtomContainer[] acs = set.getAtomContainers();
        for (int i = 0; i < acs.length; ++i) {
            AtomContainer ac = acs[i];
            if (!ac.contains(electrons)) continue;
            ac.removeElectronContainer(electrons);
            return;
        }
    }

    public static AtomContainer getAllInOneContainer(SetOfAtomContainers set) {
        AtomContainer container = new AtomContainer();
        AtomContainer[] acs = set.getAtomContainers();
        for (int i = 0; i < acs.length; ++i) {
            AtomContainer ac = acs[i];
            container.add(ac);
        }
        return container;
    }

    public static AtomContainer[] getAllAtomContainers(SetOfAtomContainers set) {
        return set.getAtomContainers();
    }

    public static double getTotalCharge(SetOfAtomContainers set) {
        double charge = 0.0;
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            int thisCharge = AtomContainerManipulator.getTotalFormalCharge((AtomContainer)set.getAtomContainer(i));
            double stoich = set.getMultiplier(i);
            charge += stoich * (double)thisCharge;
        }
        return charge;
    }

    public static double getTotalFormalCharge(SetOfAtomContainers set) {
        int charge = 0;
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            int thisCharge = AtomContainerManipulator.getTotalFormalCharge((AtomContainer)set.getAtomContainer(i));
            double stoich = set.getMultiplier(i);
            charge = (int)((double)charge + stoich * (double)thisCharge);
        }
        return charge;
    }

    public static int getTotalHydrogenCount(SetOfAtomContainers set) {
        int hCount = 0;
        for (int i = 0; i < set.getAtomContainerCount(); ++i) {
            AtomContainer ac = set.getAtomContainer(i);
            hCount += AtomContainerManipulator.getTotalHydrogenCount((AtomContainer)ac);
        }
        return hCount;
    }
}

