/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdkplugin.dirbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.applications.plugin.CDKEditBus;
import org.openscience.cdk.applications.plugin.CDKPluginInterface;
import org.openscience.cdk.applications.swing.SortedTableModel;
import org.openscience.cdk.event.ChemObjectChangeEvent;
import org.openscience.cdk.io.ChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.tools.LoggingTool;

public class DirBrowserPlugin
implements CDKPluginInterface {
    private final String implementedCDKPluginAPIVersion = "1.8";
    private final String pluginVersion = "0.8";
    private CDKEditBus editBus = null;
    private ContentModel channelContent = null;
    private SortedTableModel sortedContent = null;
    private JPanel pluginPanel = null;
    private JTextField textField;
    private ReaderFactory readerFactory = null;
    private LoggingTool logger = new LoggingTool(this);
    private File currentDirectory = new File(System.getProperty("user.dir"));
    private Thread fileGuessingThread = null;
    private boolean resetFileGuessing;

    public void start() {
        this.readerFactory = new ReaderFactory(5000);
        this.parseDirectoryIntoTable();
        this.resetFileGuessing = true;
        if (this.fileGuessingThread == null) {
            this.fileGuessingThread = new FileFormatGuessingThread();
            this.fileGuessingThread.start();
        }
    }

    public void stop() {
    }

    public void setEditBus(CDKEditBus editBus) {
        this.editBus = editBus;
    }

    public String getName() {
        return "DirBrowser";
    }

    public String getAPIVersion() {
        return "1.8";
    }

    public String getPluginVersion() {
        return "0.8";
    }

    public void setPropertyDirectory(String dir) {
        Properties props = this.readProperties(dir);
    }

    public JPanel getPluginPanel() {
        if (this.pluginPanel == null) {
            this.pluginPanel = this.createPanel();
        }
        return this.pluginPanel;
    }

    public void stateChanged(ChemObjectChangeEvent event) {
    }

    private JPanel createPanel() {
        JPanel browserPanel = new JPanel(new BorderLayout());
        JPanel dirPanel = new JPanel();
        dirPanel.setLayout(new FlowLayout(2));
        JButton dirSelect = new JButton("Select Directory");
        dirSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser(DirBrowserPlugin.this.currentDirectory);
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0 && chooser.getSelectedFile().isDirectory()) {
                    DirBrowserPlugin.this.currentDirectory = chooser.getSelectedFile();
                    DirBrowserPlugin.this.parseDirectoryIntoTable();
                    DirBrowserPlugin.this.textField.setText(DirBrowserPlugin.this.currentDirectory.toString());
                    DirBrowserPlugin.this.resetFileGuessing = true;
                }
            }
        });
        dirPanel.add(new JLabel("Current directory:"));
        this.textField = new JTextField(this.currentDirectory.toString());
        this.textField.setEditable(false);
        this.textField.setColumns(40);
        dirPanel.add(this.textField);
        dirPanel.add(dirSelect);
        dirPanel.validate();
        this.channelContent = new ContentModel();
        this.sortedContent = new SortedTableModel(this.channelContent);
        JTable channelTable = new JTable(this.sortedContent);
        this.sortedContent.addMouseListenerToHeaderInTable(channelTable);
        channelTable.setSelectionMode(0);
        ListSelectionModel rowSM = channelTable.getSelectionModel();
        rowSM.addListSelectionListener(new ItemsTableListener(this.sortedContent, this.channelContent));
        channelTable.validate();
        JScrollPane contentPane = new JScrollPane(channelTable);
        contentPane.validate();
        browserPanel.add((Component)dirPanel, "North");
        browserPanel.add((Component)contentPane, "Center");
        browserPanel.validate();
        return browserPanel;
    }

    public JPanel getPluginConfigPanel() {
        return null;
    }

    public JMenu getMenu() {
        return null;
    }

    private Properties readProperties(String directory) {
        Properties props = null;
        File uhome = new File(System.getProperty("user.home"));
        File propsFile = new File(directory + "/dirbrowser.props");
        this.logger.debug("User plugin dir: " + propsFile);
        this.logger.debug("         exists: " + propsFile.exists());
        if (propsFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(propsFile);
                props = new Properties();
                props.load(fis);
                fis.close();
            }
            catch (Exception exception) {
                this.logger.error("Error while reading dirbrowser props: " + exception.toString());
            }
        }
        return props;
    }

    private void parseDirectoryIntoTable() {
        File dir = this.currentDirectory;
        if (!dir.exists()) {
            this.logger.warn("File/Directory does not exist");
        } else if (!dir.isDirectory()) {
            this.logger.warn("File is not a directory");
        } else {
            this.channelContent.cleanTable();
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) continue;
                int lastLine = this.channelContent.getRowCount();
                this.channelContent.insertBlankRow(lastLine);
                ChemModel model = new ChemModel();
                model.setProperty("org.openscience.cdk.io.java.io.File", files[i]);
                this.channelContent.setValueAt(model, lastLine);
            }
        }
    }

    class FileFormatGuessingThread
    extends Thread {
        private int currentModel;
        private int formatsToDetermine;

        public FileFormatGuessingThread() {
            super("DirBrowser:FileFormatGuessing");
        }

        public void run() {
            Thread myThread = Thread.currentThread();
            while (DirBrowserPlugin.this.fileGuessingThread == myThread) {
                if (DirBrowserPlugin.this.resetFileGuessing) {
                    this.currentModel = 0;
                    this.formatsToDetermine = DirBrowserPlugin.this.channelContent.getRowCount();
                    DirBrowserPlugin.this.resetFileGuessing = false;
                }
                if (this.currentModel == this.formatsToDetermine) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                this.determineFormatOfNextModel();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        private void determineFormatOfNextModel() {
            ChemModel model = DirBrowserPlugin.this.channelContent.getValueAt(this.currentModel);
            File fileObject = (File)model.getProperty("org.openscience.cdk.io.java.io.File");
            if (fileObject == null) {
                DirBrowserPlugin.this.logger.warn("Thread: Cannot open file if source is not stored");
                return;
            }
            String format = "";
            try {
                ChemObjectReader reader = DirBrowserPlugin.this.readerFactory.createReader(new FileInputStream(fileObject));
                if (reader != null) {
                    format = reader.getFormatName();
                }
            }
            catch (FileNotFoundException exception) {
            }
            catch (IOException exception) {
                format = "IOException";
            }
            model.setProperty("org.openscience.cdk.io.FileFormat", format);
            ++this.currentModel;
            DirBrowserPlugin.this.channelContent.fireTableDataChanged();
        }
    }

    class ItemsTableListener
    implements ListSelectionListener {
        private SortedTableModel sortedModelContent = null;
        private ContentModel modelContent = null;

        public ItemsTableListener(SortedTableModel sortedModelContent, ContentModel modelContent) {
            this.modelContent = modelContent;
            this.sortedModelContent = sortedModelContent;
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int selectedRow = lsm.getMinSelectionIndex();
                ChemModel model = this.modelContent.getValueAt(this.sortedModelContent.getSortedIndex(selectedRow));
                String format = (String)model.getProperty("org.openscience.cdk.io.FileFormat");
                File fileObject = (File)model.getProperty("org.openscience.cdk.io.java.io.File");
                if (fileObject == null) {
                    DirBrowserPlugin.this.logger.warn("Cannot open file if source is not stored");
                    return;
                }
                Object file = null;
                try {
                    FileReader reader = new FileReader(fileObject);
                    DirBrowserPlugin.this.editBus.showChemFile(reader);
                }
                catch (Exception exception) {
                    String error = "Error while reading file: " + exception.getMessage();
                    DirBrowserPlugin.this.logger.error(error);
                    return;
                }
                DirBrowserPlugin.this.logger.warn("Not displaying model with unknown content");
            }
        }
    }

    class ContentModel
    extends AbstractTableModel {
        private Vector models;
        final String[] columnNames = new String[]{"filename", "date", "format", "chemFormula"};

        public ContentModel() {
            this.models = new Vector();
        }

        public void setValueAt(Object value, int row, int column) {
        }

        public void setValueAt(ChemModel model, int row) {
            if (row > this.getRowCount()) {
                return;
            }
            this.models.setElementAt(model, row);
            this.fireTableCellUpdated(row, 1);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.models.size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public Class getColumnClass(int col) {
            Object o = this.getValueAt(0, col);
            if (o == null) {
                return new String().getClass();
            }
            return o.getClass();
        }

        public Object getValueAt(int row, int column) {
            if (row > this.getRowCount() - 1 || column > this.getColumnCount() - 1) {
                return "Error";
            }
            ChemModel model = (ChemModel)this.models.elementAt(row);
            if (model == null) {
                return "";
            }
            File fileObject = (File)model.getProperty("org.openscience.cdk.io.java.io.File");
            if (fileObject == null) {
                return "";
            }
            if (column == 0) {
                return fileObject.getName();
            }
            if (column == 1) {
                return new Date(fileObject.lastModified()).toString();
            }
            if (column == 2) {
                String format = (String)model.getProperty("org.openscience.cdk.io.FileFormat");
                if (format == null) {
                    format = "";
                }
                return format;
            }
            if (column == 3) {
                return "";
            }
            return "";
        }

        public ChemModel getValueAt(int row) {
            return (ChemModel)this.models.elementAt(row);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void cleanTable() {
            this.models.clear();
            this.fireTableDataChanged();
        }

        private void insertBlankRow(int row) {
            this.models.addElement(null);
            this.fireTableRowsInserted(row + 1, row + 1);
        }
    }
}

