/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.openscience.jmol.app.Jmol;
import org.openscience.jmol.app.JmolResourceHandler;
import org.openscience.jmol.app.PovraySaver;
import org.openscience.jmol.viewer.JmolViewer;

public class PovrayDialog
extends JDialog {
    private JmolViewer viewer;
    private boolean callPovray = true;
    private boolean doAntiAlias = true;
    private boolean displayWhileRendering = true;
    String savePath;
    String basename = "I'm a bug";
    String commandLine = "Hello, I'm a bug!!";
    String povrayPath = "I'm a bug, lets party";
    private JButton povrayPathButton;
    private JCheckBox antiAlias;
    private JCheckBox displayWhileRenderingBox;
    private JTextField commandLineField;
    private JButton goButton;
    private JTextField saveField;
    private JLabel savePathLabel;
    private int outputWidth = -1;
    private int outputHeight = -1;
    private JLabel povrayPathLabel;

    public PovrayDialog(JFrame f, JmolViewer viewer) {
        super(f, JmolResourceHandler.getStringX("Povray.povrayDialogTitle"), true);
        this.viewer = viewer;
        this.basename = "jmol";
        int screenWidth = viewer.getScreenWidth();
        int screenHeight = viewer.getScreenHeight();
        this.getPathHistory();
        this.setImageDimensions(screenWidth, screenHeight);
        this.getContentPane().setLayout(new BorderLayout());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        JPanel mainPanel = new JPanel(gridBagLayout);
        JPanel justSavingPanel = new JPanel(new GridLayout(2, 1));
        justSavingPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Povray.savingPov")));
        JPanel savePanel = new JPanel(new BorderLayout());
        savePanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Povray.workingName")));
        savePanel.setToolTipText(JmolResourceHandler.getStringX("Povray.workingNameTip"));
        this.saveField = new JTextField(this.basename, 20);
        this.saveField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.basename = PovrayDialog.this.saveField.getText();
                PovrayDialog.this.updateCommandLine();
            }
        });
        savePanel.add((Component)this.saveField, "Center");
        justSavingPanel.add(savePanel);
        JPanel savePathPanel = new JPanel(new BorderLayout());
        savePathPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Povray.workingDirectory")));
        savePathPanel.setToolTipText(JmolResourceHandler.getStringX("Povray.workingDirectoryTip"));
        this.savePathLabel = new JLabel(this.savePath);
        savePathPanel.add((Component)this.savePathLabel, "Center");
        JButton savePathButton = new JButton(JmolResourceHandler.getStringX("Povray.selectButton"));
        savePathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.showSavePathDialog();
            }
        });
        savePathPanel.add((Component)savePathButton, "East");
        justSavingPanel.add(savePathPanel);
        mainPanel.add(justSavingPanel);
        gridBagLayout.setConstraints(justSavingPanel, gridBagConstraints);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        JPanel povOptionsPanel = new JPanel(gridBagLayout2);
        povOptionsPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Povray.povOptions")));
        JCheckBox runPovCheck = new JCheckBox(JmolResourceHandler.getStringX("Povray.runPov"), true);
        runPovCheck.setToolTipText(JmolResourceHandler.getStringX("Povray.runPovTip"));
        runPovCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PovrayDialog.this.callPovray = true;
                    PovrayDialog.this.goButton.setText(JmolResourceHandler.getStringX("Povray.goLabel"));
                } else if (e.getStateChange() == 2) {
                    PovrayDialog.this.callPovray = false;
                    PovrayDialog.this.goButton.setText(JmolResourceHandler.getStringX("Povray.saveLabel"));
                }
                PovrayDialog.this.povrayPathButton.setEnabled(PovrayDialog.this.callPovray);
                PovrayDialog.this.antiAlias.setEnabled(PovrayDialog.this.callPovray);
                PovrayDialog.this.displayWhileRenderingBox.setEnabled(PovrayDialog.this.callPovray);
                PovrayDialog.this.commandLineField.setEnabled(PovrayDialog.this.callPovray);
            }
        });
        povOptionsPanel.add(runPovCheck);
        gridBagLayout2.setConstraints(runPovCheck, gridBagConstraints);
        this.antiAlias = new JCheckBox(JmolResourceHandler.getStringX("Povray.antiAlias"), this.doAntiAlias);
        this.antiAlias.setToolTipText(JmolResourceHandler.getStringX("Povray.antiAliasTip"));
        this.antiAlias.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PovrayDialog.this.doAntiAlias = true;
                } else if (e.getStateChange() == 2) {
                    PovrayDialog.this.doAntiAlias = false;
                }
                PovrayDialog.this.updateCommandLine();
            }
        });
        povOptionsPanel.add(this.antiAlias);
        gridBagLayout2.setConstraints(this.antiAlias, gridBagConstraints);
        this.displayWhileRenderingBox = new JCheckBox(JmolResourceHandler.getStringX("Povray.displayWhileRendering"), this.displayWhileRendering);
        this.displayWhileRenderingBox.setToolTipText(JmolResourceHandler.getStringX("Povray.displayWhileRenderingTip"));
        this.displayWhileRenderingBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    PovrayDialog.this.displayWhileRendering = true;
                } else if (e.getStateChange() == 2) {
                    PovrayDialog.this.displayWhileRendering = false;
                }
                PovrayDialog.this.updateCommandLine();
            }
        });
        povOptionsPanel.add(this.displayWhileRenderingBox);
        gridBagLayout2.setConstraints(this.displayWhileRenderingBox, gridBagConstraints);
        JPanel povrayPathPanel = new JPanel(new FlowLayout());
        povrayPathPanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Povray.povrayExecutable")));
        povrayPathPanel.setToolTipText(JmolResourceHandler.getStringX("Povray.povrayExecutableTip"));
        this.povrayPathLabel = new JLabel(this.povrayPath);
        povrayPathPanel.add(this.povrayPathLabel);
        this.povrayPathButton = new JButton(JmolResourceHandler.getStringX("Povray.selectButton"));
        this.povrayPathButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.showPovrayPathDialog();
            }
        });
        povrayPathPanel.add(this.povrayPathButton);
        povOptionsPanel.add(povrayPathPanel);
        gridBagLayout2.setConstraints(povrayPathPanel, gridBagConstraints);
        JPanel commandLinePanel = new JPanel();
        commandLinePanel.setBorder(new TitledBorder(JmolResourceHandler.getStringX("Povray.commandLineTitle")));
        commandLinePanel.setToolTipText(JmolResourceHandler.getStringX("Povray.commandLineTip"));
        this.commandLineField = new JTextField(this.commandLine, 30);
        this.commandLineField.setToolTipText(JmolResourceHandler.getStringX("Povray.commandLineTip"));
        this.commandLineField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.commandLine = PovrayDialog.this.commandLineField.getText();
            }
        });
        commandLinePanel.add(this.commandLineField);
        povOptionsPanel.add(commandLinePanel);
        gridBagLayout2.setConstraints(commandLinePanel, gridBagConstraints);
        mainPanel.add(povOptionsPanel);
        gridBagLayout.setConstraints(povOptionsPanel, gridBagConstraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.goButton = new JButton(JmolResourceHandler.getStringX("Povray.goLabel"));
        this.goButton.setToolTipText(JmolResourceHandler.getStringX("Povray.goButtonTip"));
        this.goButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.goPressed();
            }
        });
        buttonPanel.add(this.goButton);
        JButton cancelButton = new JButton(JmolResourceHandler.getStringX("Povray.cancelLabel"));
        cancelButton.setToolTipText(JmolResourceHandler.getStringX("Povray.cancelButtonTip"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PovrayDialog.this.cancelPressed();
            }
        });
        buttonPanel.add(cancelButton);
        this.getContentPane().add("Center", mainPanel);
        this.getContentPane().add("South", buttonPanel);
        this.updateCommandLine();
        this.pack();
        this.centerDialog();
        this.setVisible(true);
    }

    public void setImageDimensions(int imageWidth, int imageHeight) {
        this.outputWidth = imageWidth;
        this.outputHeight = imageHeight;
        this.updateCommandLine();
    }

    private void goPressed() {
        this.commandLine = this.commandLineField.getText();
        String filename = this.basename + ".pov";
        File theFile = new File(this.savePath, filename);
        if (theFile != null) {
            try {
                FileOutputStream os = new FileOutputStream(theFile);
                PovraySaver povs = new PovraySaver(this.viewer, os);
                povs.writeFile();
            }
            catch (FileNotFoundException fnf) {
                System.out.println("Povray Dialog FileNotFoundException:" + theFile);
                return;
            }
        }
        try {
            if (this.callPovray) {
                Runtime.getRuntime().exec(this.commandLine);
            }
        }
        catch (IOException e) {
            System.out.println("Caught IOException in povray exec: " + e);
            System.out.println("CmdLine: " + this.commandLine);
        }
        this.setVisible(false);
        this.saveHistory();
        this.dispose();
    }

    private void cancelPressed() {
        this.setVisible(false);
        this.dispose();
    }

    private void showSavePathDialog() {
        JFileChooser myChooser = new JFileChooser();
        myChooser.setFileSelectionMode(1);
        int button = myChooser.showDialog(this, "Select");
        if (button == 0) {
            File newFile = myChooser.getSelectedFile();
            this.savePath = newFile.isDirectory() ? newFile.toString() : newFile.getParent().toString();
            this.savePathLabel.setText(this.savePath);
            this.updateCommandLine();
            this.pack();
        }
    }

    private void showPovrayPathDialog() {
        JFileChooser myChooser = new JFileChooser();
        int button = myChooser.showDialog(this, "Select");
        if (button == 0) {
            File newFile = myChooser.getSelectedFile();
            this.povrayPath = newFile.toString();
            this.povrayPathLabel.setText(this.povrayPath);
            this.updateCommandLine();
            this.pack();
        }
    }

    protected void updateCommandLine() {
        if (this.savePath == null || this.povrayPath == null || this.basename == null || this.commandLine == null) {
            this.commandLine = "null component string";
        }
        if (!this.savePath.endsWith(File.separator)) {
            this.savePath = this.savePath + File.separator;
        }
        this.commandLine = this.povrayPath + " +I" + this.savePath + this.basename + ".pov" + " +O" + this.savePath + this.basename + ".tga" + " +FT";
        if (this.outputWidth > 0 && this.outputHeight > 0) {
            this.commandLine = this.commandLine + " +H" + this.outputHeight + " +W" + this.outputWidth;
        }
        if (this.doAntiAlias) {
            this.commandLine = this.commandLine + " +A0.1";
        }
        if (this.displayWhileRendering) {
            this.commandLine = this.commandLine + " +D +P";
        }
        this.commandLine = this.commandLine + " -V";
        if (this.commandLineField != null) {
            this.commandLineField.setText(this.commandLine);
        }
    }

    protected void centerDialog() {
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension size = this.getSize();
        screenSize.height /= 2;
        screenSize.width /= 2;
        size.height /= 2;
        size.width /= 2;
        int y = screenSize.height - size.height;
        int x = screenSize.width - size.width;
        this.setLocation(x, y);
    }

    private void getPathHistory() {
        Properties props = Jmol.getHistoryFile().getProperties();
        this.povrayPath = props.getProperty("povrayPath", System.getProperty("user.home"));
        this.savePath = props.getProperty("povraySavePath", System.getProperty("user.home"));
    }

    private void saveHistory() {
        Properties props = new Properties();
        props.setProperty("povrayPath", this.povrayPath);
        props.setProperty("povraySavePath", this.savePath);
        Jmol.getHistoryFile().addProperties(props);
    }

    class PovrayWindowListener
    extends WindowAdapter {
        PovrayWindowListener() {
        }

        public void windowClosing(WindowEvent e) {
            PovrayDialog.this.cancelPressed();
            PovrayDialog.this.setVisible(false);
            PovrayDialog.this.dispose();
        }
    }
}

