/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.viewer.managers;

import java.awt.Rectangle;
import java.util.BitSet;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.api.ModelAdapter;
import org.openscience.jmol.viewer.JmolViewer;
import org.openscience.jmol.viewer.datamodel.Frame;
import org.openscience.jmol.viewer.datamodel.FrameBuilder;

public class ModelManager {
    final JmolViewer viewer;
    final ModelAdapter modelAdapter;
    final Frame nullFrame;
    final FrameBuilder frameBuilder;
    public String fullPathName;
    public String fileName;
    public String modelSetName;
    public String modelFileHeader;
    public boolean haveFile = false;
    public Frame frame;
    private final Point3f pointT = new Point3f();
    public boolean autoBond = true;
    public float bondTolerance = 0.45f;
    public float minBondDistance = 0.4f;
    public float solventProbeRadius = 1.2f;
    public boolean solventOn = false;
    int[] shapeSizes = new int[22];
    Hashtable[] shapeProperties = new Hashtable[22];
    private static final Object NULL_SURROGATE = new Object();

    public ModelManager(JmolViewer viewer, ModelAdapter modelAdapter) {
        this.viewer = viewer;
        this.modelAdapter = modelAdapter;
        this.nullFrame = new Frame(viewer, "null");
        this.frameBuilder = new FrameBuilder(viewer, modelAdapter);
    }

    public void setClientFile(String fullPathName, String fileName, Object clientFile) {
        if (clientFile == null) {
            this.modelFileHeader = null;
            this.modelSetName = null;
            fileName = null;
            fullPathName = null;
            this.frame = null;
            this.haveFile = false;
        } else {
            this.fullPathName = fullPathName;
            this.fileName = fileName;
            this.modelSetName = this.modelAdapter.getModelSetName(clientFile);
            if (this.modelSetName != null) {
                this.modelSetName = this.modelSetName.trim();
                if (this.modelSetName.length() == 0) {
                    this.modelSetName = null;
                }
            }
            this.modelFileHeader = this.modelAdapter.getModelFileHeader(clientFile);
            this.frame = this.frameBuilder.buildFrame(clientFile);
            this.haveFile = true;
        }
    }

    public String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        return this.modelAdapter.getClientAtomStringProperty(clientAtom, propertyName);
    }

    public Frame getFrame() {
        return this.frame == null ? this.nullFrame : this.frame;
    }

    public ModelAdapter getExportModelAdapter() {
        return this.frame == null ? null : this.frame.getExportModelAdapter();
    }

    public String getModelSetName() {
        return this.modelSetName;
    }

    public String getModelFileHeader() {
        return this.modelFileHeader;
    }

    public boolean hasVibrationVectors() {
        return this.frame.hasVibrationVectors();
    }

    public float getRotationRadius() {
        return this.frame == null ? 1.0f : this.frame.getRotationRadius();
    }

    public void increaseRotationRadius(float increaseInAngstroms) {
        if (this.frame != null) {
            this.frame.increaseRotationRadius(increaseInAngstroms);
        }
    }

    public Point3f getBoundingBoxCenter() {
        return this.frame == null ? null : this.frame.getBoundingBoxCenter();
    }

    public Vector3f getBoundingBoxCornerVector() {
        return this.frame == null ? null : this.frame.getBoundingBoxCornerVector();
    }

    public int getModelCount() {
        return this.frame == null ? 0 : this.frame.getModelCount();
    }

    public int getModelIndex(String modelTag) {
        return this.frame == null ? -1 : this.frame.getModelIndex(modelTag);
    }

    public int getChainCount() {
        return this.frame == null ? 0 : this.frame.getChainCount();
    }

    public int getGroupCount() {
        return this.frame == null ? 0 : this.frame.getGroupCount();
    }

    public int getAtomCount() {
        return this.frame == null ? 0 : this.frame.getAtomCount();
    }

    public int getBondCount() {
        return this.frame == null ? 0 : this.frame.getBondCount();
    }

    public void setCenterBitSet(BitSet bsCenter) {
        if (this.frame == null) {
            return;
        }
        Point3f center = null;
        if (bsCenter != null) {
            int countSelected = 0;
            center = this.pointT;
            center.set(0.0f, 0.0f, 0.0f);
            int i = this.getAtomCount();
            while (--i >= 0) {
                if (!bsCenter.get(i)) continue;
                ++countSelected;
                center.add(this.frame.getAtomPoint3f(i));
            }
            if (countSelected > 0) {
                center.scale(1.0f / (float)countSelected);
            } else {
                center = null;
            }
        }
        this.frame.setRotationCenter(center);
    }

    public void setRotationCenter(Point3f center) {
        if (this.frame != null) {
            this.frame.setRotationCenter(center);
        }
    }

    public Point3f getRotationCenter() {
        return this.frame == null ? null : this.frame.getRotationCenter();
    }

    public void rebond() {
        if (this.frame != null) {
            this.frame.rebond();
        }
    }

    public void setAutoBond(boolean ab) {
        this.autoBond = ab;
    }

    public void setBondTolerance(float bondTolerance) {
        this.bondTolerance = bondTolerance;
    }

    public void setMinBondDistance(float minBondDistance) {
        this.minBondDistance = minBondDistance;
    }

    public boolean frankClicked(int x, int y) {
        return this.getShapeSize(18) != 0 && this.frame.frankClicked(x, y);
    }

    public int findNearestAtomIndex(int x, int y) {
        return this.frame == null ? -1 : this.frame.findNearestAtomIndex(x, y);
    }

    public BitSet findAtomsInRectangle(Rectangle rectRubber) {
        return this.frame.findAtomsInRectangle(rectRubber);
    }

    public void setSolventProbeRadius(float radius) {
        this.solventProbeRadius = radius;
    }

    public void setSolventOn(boolean solventOn) {
        this.solventOn = solventOn;
    }

    public void setShapeSize(int shapeType, int size, BitSet bsSelected) {
        this.shapeSizes[shapeType] = size;
        if (this.frame != null) {
            this.frame.setShapeSize(shapeType, size, bsSelected);
        }
    }

    public int getShapeSize(int shapeType) {
        return this.shapeSizes[shapeType];
    }

    public void setShapeProperty(int shapeType, String propertyName, Object value, BitSet bsSelected) {
        Hashtable<String, Object> props = this.shapeProperties[shapeType];
        if (props == null) {
            props = this.shapeProperties[shapeType] = new Hashtable<String, Object>();
        }
        propertyName = propertyName.intern();
        props.put(propertyName, value != null ? value : NULL_SURROGATE);
        if (this.frame != null) {
            this.frame.setShapeProperty(shapeType, propertyName, value, bsSelected);
        }
    }

    public Object getShapeProperty(int shapeType, String propertyName, int index) {
        Hashtable props;
        Object value = null;
        if (this.frame != null) {
            value = this.frame.getShapeProperty(shapeType, propertyName, index);
        }
        if (value == null && (props = this.shapeProperties[shapeType]) != null && (value = props.get(propertyName)) == NULL_SURROGATE) {
            value = null;
            return null;
        }
        return value;
    }

    public int getAtomIndexFromAtomNumber(int atomNumber) {
        return this.frame == null ? -1 : this.frame.getAtomIndexFromAtomNumber(atomNumber);
    }

    public BitSet getElementsPresentBitSet() {
        return this.frame == null ? null : this.frame.getElementsPresentBitSet();
    }

    public BitSet getGroupsPresentBitSet() {
        return this.frame == null ? null : this.frame.getGroupsPresentBitSet();
    }

    public String getAtomInfo(int i) {
        return this.frame.getAtomAt(i).getInfo();
    }

    public String getElementSymbol(int i) {
        return this.frame.getAtomAt(i).getElementSymbol();
    }

    public int getElementNumber(int i) {
        return this.frame.getAtomAt(i).getElementNumber();
    }

    public String getAtomName(int i) {
        return this.frame.getAtomAt(i).getAtomName();
    }

    public int getAtomNumber(int i) {
        return this.frame.getAtomAt(i).getAtomNumber();
    }

    public float getAtomX(int i) {
        return this.frame.getAtomAt(i).getAtomX();
    }

    public float getAtomY(int i) {
        return this.frame.getAtomAt(i).getAtomY();
    }

    public float getAtomZ(int i) {
        return this.frame.getAtomAt(i).getAtomZ();
    }

    public Point3f getAtomPoint3f(int i) {
        return this.frame.getAtomAt(i).getPoint3f();
    }

    public float getAtomRadius(int i) {
        return this.frame.getAtomAt(i).getRadius();
    }

    public short getAtomColix(int i) {
        return this.frame.getAtomAt(i).getColix();
    }

    public Point3f getBondPoint3f1(int i) {
        return this.frame.getBondAt((int)i).atom1.getPoint3f();
    }

    public Point3f getBondPoint3f2(int i) {
        return this.frame.getBondAt((int)i).atom2.getPoint3f();
    }

    public float getBondRadius(int i) {
        return this.frame.getBondAt(i).getRadius();
    }

    public short getBondOrder(int i) {
        return this.frame.getBondAt(i).getOrder();
    }

    public short getBondColix1(int i) {
        return this.frame.getBondAt(i).getColix1();
    }

    public short getBondColix2(int i) {
        return this.frame.getBondAt(i).getColix2();
    }
}

