/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.protocol;

import java.net.ContentHandler;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.osgi.framework.internal.protocol.ContentHandlerProxy;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ContentHandlerFactory
implements java.net.ContentHandlerFactory {
    private ServiceTracker contentHandlerTracker;
    private BundleContext context;
    private static final String contentHandlerClazz = "java.net.ContentHandler";
    private static final String CONTENT_HANDLER_PKGS = "java.content.handler.pkgs";
    private Hashtable proxies;

    public ContentHandlerFactory(BundleContext context) {
        this.context = context;
        this.proxies = new Hashtable(5);
        this.contentHandlerTracker = new ServiceTracker(context, contentHandlerClazz, null);
        this.contentHandlerTracker.open();
    }

    public ContentHandler createContentHandler(String contentType) {
        ContentHandlerProxy proxy;
        String builtInHandlers = System.getProperty(CONTENT_HANDLER_PKGS);
        Class<?> clazz = null;
        if (builtInHandlers != null) {
            String convertedContentType = contentType.replace('.', '_');
            convertedContentType = convertedContentType.replace('/', '.');
            convertedContentType = convertedContentType.replace('-', '_');
            StringTokenizer tok = new StringTokenizer(builtInHandlers, "|");
            while (tok.hasMoreElements()) {
                StringBuffer name = new StringBuffer();
                name.append(tok.nextToken());
                name.append(".");
                name.append(convertedContentType);
                try {
                    clazz = Class.forName(name.toString());
                    if (clazz == null) continue;
                    return null;
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        if ((proxy = (ContentHandlerProxy)this.proxies.get(contentType)) != null) {
            return proxy;
        }
        ServiceReference[] serviceReferences = this.contentHandlerTracker.getServiceReferences();
        if (serviceReferences != null) {
            int i = 0;
            while (i < serviceReferences.length) {
                String[] contentHandler = (String[])serviceReferences[i].getProperty("url.content.mimetype");
                if (contentHandler != null) {
                    int j = 0;
                    while (j < contentHandler.length) {
                        if (contentHandler[j].equals(contentHandler)) {
                            ContentHandler handler = (ContentHandler)this.context.getService(serviceReferences[i]);
                            proxy = new ContentHandlerProxy(contentType, serviceReferences[i], this.context);
                            this.proxies.put(contentType, handler);
                            return proxy;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        proxy = new ContentHandlerProxy(contentType, null, this.context);
        this.proxies.put(contentType, proxy);
        return proxy;
    }
}

