/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.BundleHelper;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Policy;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.ant.AntScript;
import org.eclipse.pde.internal.build.ant.FileSet;
import org.eclipse.pde.internal.build.ant.TarFileSet;
import org.eclipse.pde.internal.build.ant.ZipFileSet;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;

public class AssembleConfigScriptGenerator
extends AbstractScriptGenerator {
    protected String directory;
    protected String featureId;
    protected Config configInfo;
    protected IFeature[] features;
    protected BundleDescription[] plugins;
    protected String filename;
    protected Collection rootFileProviders;
    protected Properties pluginsPostProcessingSteps;
    protected Properties featuresPostProcessingSteps;
    private static final String PROPERTY_SOURCE = "source";
    private static final String PROPERTY_ELEMENT_NAME = "elementName";
    private static final String UPDATEJAR = "updateJar";
    private static final String FLAT = "flat";
    private static final byte BUNDLE = 0;
    private static final byte FEATURE = 1;
    private static final String FOLDER = "folder";
    private static final String FILE = "file";
    private String PROPERTY_ECLIPSE_PLUGINS = "eclipse.plugins";
    private String PROPERTY_ECLIPSE_FEATURES = "eclipse.features";

    public void initialize(String directoryName, String scriptName, String feature, Config configurationInformation, Collection elementList, Collection featureList, Collection rootProviders) throws CoreException {
        this.directory = directoryName;
        this.featureId = feature;
        this.configInfo = configurationInformation;
        this.rootFileProviders = rootProviders;
        this.features = new IFeature[featureList.size()];
        featureList.toArray(this.features);
        this.plugins = new BundleDescription[elementList.size()];
        this.plugins = elementList.toArray(this.plugins);
        this.filename = String.valueOf(this.directory) + '/' + (scriptName != null ? scriptName : this.getFilename());
        try {
            this.script = new AntScript(new FileOutputStream(this.filename));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            String message = Policy.bind("exception.writingFile", this.filename);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.build", 12, message, (Throwable)e));
        }
        this.loadPostProcessingSteps();
    }

    private void loadPostProcessingSteps() {
        try {
            this.pluginsPostProcessingSteps = AbstractScriptGenerator.readProperties(AbstractScriptGenerator.getWorkingDirectory(), "plugins.postProcessingSteps.properties", 1);
            this.featuresPostProcessingSteps = AbstractScriptGenerator.readProperties(AbstractScriptGenerator.getWorkingDirectory(), "features.PostProcessingSteps.properties", 1);
        }
        catch (CoreException coreException) {}
    }

    public void generate() throws CoreException {
        this.generatePrologue();
        this.generateInitializationSteps();
        this.generateGatherBinPartsCalls();
        if (AbstractScriptGenerator.embeddedSource) {
            this.generateGatherSourceCalls();
        }
        this.generatePostProcessingSteps();
        this.generateArchivingSteps();
        this.generateEpilogue();
    }

    private void generateArchivingSteps() {
        if (AbstractScriptGenerator.outputFormat.equalsIgnoreCase(FOLDER)) {
            return;
        }
        if (this.configInfo.getOs().equalsIgnoreCase("win32") || this.configInfo.equals(Config.genericConfig())) {
            if (AbstractScriptGenerator.outputFormat.equalsIgnoreCase("zip")) {
                this.generateZipTarget();
            } else {
                this.generateAntZipTarget();
            }
            return;
        }
        if (!Platform.getOS().equals("win32")) {
            this.generateTarTarget();
            this.generateGZipTarget();
        } else {
            this.generateAntTarTarget();
        }
    }

    private void generateGatherSourceCalls() {
        String placeToGather;
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("destination.temp.folder", this.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS));
        int i = 0;
        while (i < this.plugins.length) {
            BundleDescription plugin = this.plugins[i];
            placeToGather = this.getLocation(plugin);
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(AbstractScriptGenerator.workingDirectory)).toOSString(), "gather.sources", null, null, properties);
            ++i;
        }
        properties = new HashMap(1);
        properties.put("feature.base", this.getPropertyFormat("eclipse.base"));
        i = 0;
        while (i < this.features.length) {
            IFeature feature = this.features[i];
            placeToGather = feature.getURL().getPath();
            int j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(AbstractScriptGenerator.workingDirectory)).toOSString(), "gather.sources", null, null, properties);
            ++i;
        }
    }

    private void generatePackagingTargets() {
        String fileName = String.valueOf(this.getPropertyFormat(PROPERTY_SOURCE)) + '/' + this.getPropertyFormat(PROPERTY_ELEMENT_NAME);
        String fileExists = String.valueOf(this.getPropertyFormat(PROPERTY_SOURCE)) + '/' + this.getPropertyFormat(PROPERTY_ELEMENT_NAME) + "_exists";
        this.script.printComment("Beginning of the jarUp task");
        this.script.printTargetDeclaration("jarUp", null, null, null, Policy.bind("assemble.jarUp"));
        this.script.printAvailableTask(fileExists, fileName);
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put(PROPERTY_SOURCE, this.getPropertyFormat(PROPERTY_SOURCE));
        params.put(PROPERTY_ELEMENT_NAME, this.getPropertyFormat(PROPERTY_ELEMENT_NAME));
        this.script.printAntCallTask("jarIng", null, params);
        this.script.printTargetEnd();
        this.script.printTargetDeclaration("jarIng", null, fileExists, null, null);
        this.script.printZipTask(String.valueOf(fileName) + ".jar", fileName, false, false, null);
        this.script.printDeleteTask(fileName, null, null);
        this.script.printTargetEnd();
        this.script.printComment("End of the jarUp task");
    }

    private void generateGZipTarget() {
        this.script.println("<move file=\"" + this.getPropertyFormat("archiveFullPath") + "\" tofile=\"" + this.getPropertyFormat("assemblyTempDir") + '/' + this.getPropertyFormat("collectingFolder") + "/tmp.tar\"/>");
        this.script.printGZip(String.valueOf(this.getPropertyFormat("assemblyTempDir")) + '/' + this.getPropertyFormat("collectingFolder") + "/tmp.tar", this.getPropertyFormat("archiveFullPath"));
        ArrayList<String> args = new ArrayList<String>(2);
        args.add("-rf");
        args.add(this.getPropertyFormat("assemblyTempDir"));
        this.script.printExecTask("rm", null, args, null);
    }

    private void generatePrologue() {
        this.script.printProjectDeclaration("Assemble " + this.featureId, "main", null);
        this.script.printProperty("archiveName", this.computeArchiveName());
        this.script.printProperty("os", this.configInfo.getOs());
        this.script.printProperty("ws", this.configInfo.getWs());
        this.script.printProperty("arch", this.configInfo.getArch());
        this.script.printProperty("assemblyTempDir", String.valueOf(this.getPropertyFormat("buildDirectory")) + "/tmp");
        this.script.printProperty("eclipse.base", String.valueOf(this.getPropertyFormat("assemblyTempDir")) + '/' + this.getPropertyFormat("collectingFolder"));
        this.script.printProperty(this.PROPERTY_ECLIPSE_PLUGINS, String.valueOf(this.getPropertyFormat("eclipse.base")) + '/' + "plugins");
        this.script.printProperty(this.PROPERTY_ECLIPSE_FEATURES, String.valueOf(this.getPropertyFormat("eclipse.base")) + '/' + "features");
        this.script.printProperty("archiveFullPath", String.valueOf(this.getPropertyFormat("basedir")) + '/' + this.getPropertyFormat("buildLabel") + '/' + this.getPropertyFormat("archiveName"));
        this.generatePackagingTargets();
        this.script.printTargetDeclaration("main", null, null, null, null);
    }

    private void generateInitializationSteps() {
        if (BundleHelper.getDefault().isDebugging()) {
            this.script.printEchoTask("basedir : " + this.getPropertyFormat("basedir"));
            this.script.printEchoTask("assemblyTempDir : " + this.getPropertyFormat("assemblyTempDir"));
            this.script.printEchoTask("eclipse.base : " + this.getPropertyFormat("eclipse.base"));
            this.script.printEchoTask("collectingFolder : " + this.getPropertyFormat("collectingFolder"));
            this.script.printEchoTask("archivePrefix : " + this.getPropertyFormat("archivePrefix"));
        }
        this.script.println("<condition property=\"pluginArchivePrefix\" value=\"plugins\">");
        this.script.println("\t<equals arg1=\"" + this.getPropertyFormat("archivePrefix") + "\"  arg2=\"\" trim=\"true\"/>");
        this.script.println("</condition>");
        this.script.printProperty("pluginArchivePrefix", String.valueOf(this.getPropertyFormat("archivePrefix")) + '/' + "plugins");
        this.script.println();
        this.script.println("<condition property=\"featureArchivePrefix\" value=\"features\">");
        this.script.println("\t<equals arg1=\"" + this.getPropertyFormat("archivePrefix") + "\"  arg2=\"\" trim=\"true\"/>");
        this.script.println("</condition>");
        this.script.printProperty("featureArchivePrefix", String.valueOf(this.getPropertyFormat("archivePrefix")) + '/' + "features");
        this.script.println();
        if (!FOLDER.equalsIgnoreCase(AbstractScriptGenerator.outputFormat)) {
            this.script.printDeleteTask(this.getPropertyFormat("assemblyTempDir"), null, null);
        }
        this.script.printDirName("archiveParentFolder", this.getPropertyFormat("archiveFullPath"));
        this.script.printMkdirTask(this.getPropertyFormat("archiveParentFolder"));
        this.script.printMkdirTask(this.getPropertyFormat("assemblyTempDir"));
        this.script.printMkdirTask(this.getPropertyFormat("buildLabel"));
    }

    private void generatePostProcessingSteps() {
        int i = 0;
        while (i < this.plugins.length) {
            BundleDescription plugin = this.plugins[i];
            if (AbstractScriptGenerator.forceUpdateJarFormat) {
                this.pluginsPostProcessingSteps.put(plugin.getSymbolicName(), UPDATEJAR);
            }
            this.generatePostProcessingSteps(plugin.getSymbolicName(), plugin.getVersion().toString(), (byte)0);
            ++i;
        }
        i = 0;
        while (i < this.features.length) {
            IFeature feature = this.features[i];
            if (AbstractScriptGenerator.forceUpdateJarFormat) {
                this.featuresPostProcessingSteps.put(feature.getVersionedIdentifier().getIdentifier(), UPDATEJAR);
            }
            this.generatePostProcessingSteps(feature.getVersionedIdentifier().getIdentifier(), feature.getVersionedIdentifier().getVersion().toString(), (byte)1);
            ++i;
        }
    }

    private void generateGatherBinPartsCalls() {
        int j;
        IFeature feature;
        String placeToGather;
        HashMap<String, String> properties = new HashMap<String, String>(1);
        properties.put("destination.temp.folder", this.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS));
        int i = 0;
        while (i < this.plugins.length) {
            BundleDescription plugin = this.plugins[i];
            placeToGather = this.getLocation(plugin);
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(AbstractScriptGenerator.workingDirectory)).toOSString(), "gather.bin.parts", null, null, properties);
            ++i;
        }
        properties = new HashMap(1);
        properties.put("feature.base", this.getPropertyFormat("eclipse.base"));
        i = 0;
        while (i < this.features.length) {
            feature = this.features[i];
            placeToGather = feature.getURL().getPath();
            j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(AbstractScriptGenerator.workingDirectory)).toOSString(), "gather.bin.parts", null, null, properties);
            ++i;
        }
        properties = new HashMap(1);
        properties.put("feature.base", this.getPropertyFormat("eclipse.base"));
        Iterator iter = this.rootFileProviders.iterator();
        while (iter.hasNext()) {
            feature = (IFeature)iter.next();
            placeToGather = feature.getURL().getPath();
            j = placeToGather.lastIndexOf("feature.xml");
            if (j != -1) {
                placeToGather = placeToGather.substring(0, j);
            }
            this.script.printAntTask("build.xml", Utils.makeRelative((IPath)new Path(placeToGather), (IPath)new Path(AbstractScriptGenerator.workingDirectory)).toOSString(), "gather.bin.parts", null, null, properties);
        }
    }

    private void generatePostProcessingSteps(String name, String version, byte type) {
        String style = (String)this.getFinalShape(name, version, type)[1];
        if (FOLDER.equalsIgnoreCase(style)) {
            return;
        }
        if (FILE.equalsIgnoreCase(style)) {
            this.generateJarUpCall(name, version, type);
            return;
        }
    }

    private String getPluginUnpackClause(String name, String version) {
        int i = 0;
        while (i < this.features.length) {
            IPluginEntry[] entries = this.features[i].getPluginEntries();
            int j = 0;
            while (j < entries.length) {
                if (entries[j].getVersionedIdentifier().getIdentifier().equals(name)) {
                    return ((PluginEntry)entries[j]).isUnpack() ? FLAT : UPDATEJAR;
                }
                ++j;
            }
            ++i;
        }
        return FLAT;
    }

    private Object[] getFinalShape(String name, String version, byte type) {
        Properties currentProperties;
        String style = this.getPluginUnpackClause(name, version);
        Properties properties = currentProperties = type == 0 ? this.pluginsPostProcessingSteps : this.featuresPostProcessingSteps;
        if (currentProperties.size() != 0) {
            String styleFromFile = currentProperties.getProperty(name);
            if (styleFromFile == null) {
                styleFromFile = currentProperties.getProperty("*");
            }
            style = styleFromFile;
        }
        if (FLAT.equalsIgnoreCase(style)) {
            return new Object[]{String.valueOf(name) + '_' + version, FOLDER};
        }
        if (UPDATEJAR.equalsIgnoreCase(style)) {
            return new Object[]{String.valueOf(name) + '_' + version + ".jar", FILE};
        }
        return new Object[]{String.valueOf(name) + '_' + version, FOLDER};
    }

    private void generateJarUpCall(String name, String version, byte type) {
        HashMap<String, String> properties = new HashMap<String, String>(2);
        properties.put(PROPERTY_SOURCE, type == 0 ? this.getPropertyFormat(this.PROPERTY_ECLIPSE_PLUGINS) : this.getPropertyFormat(this.PROPERTY_ECLIPSE_FEATURES));
        properties.put(PROPERTY_ELEMENT_NAME, String.valueOf(name) + '_' + version);
        this.script.printAntCallTask("jarUp", null, properties);
    }

    private void generateEpilogue() {
        this.script.printTargetEnd();
        this.script.printProjectEnd();
        this.script.close();
    }

    public String getFilename() {
        return String.valueOf(this.getTargetName()) + ".xml";
    }

    public String getTargetName() {
        return "assemble" + (this.featureId.equals("") ? "" : String.valueOf('.') + this.featureId) + (this.configInfo.equals(Config.genericConfig()) ? "" : String.valueOf('.') + this.configInfo.toStringReplacingAny(".", "ANY"));
    }

    private void generateZipTarget() {
        ArrayList<String> parameters = new ArrayList<String>(16);
        int i = 0;
        while (i < this.plugins.length) {
            parameters.add(String.valueOf(this.getPropertyFormat("pluginArchivePrefix")) + '/' + (String)this.getFinalShape(this.plugins[i].getSymbolicName(), this.plugins[i].getVersion().toString(), (byte)0)[0]);
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        i = 0;
        while (i < this.features.length) {
            parameters.add(String.valueOf(this.getPropertyFormat("featureArchivePrefix")) + '/' + (String)this.getFinalShape(this.features[i].getVersionedIdentifier().getIdentifier(), this.features[i].getVersionedIdentifier().getVersion().toString(), (byte)1)[0]);
            if (i % 15 == 0) {
                this.createZipExecCommand(parameters);
                parameters.clear();
            }
            ++i;
        }
        if (!parameters.isEmpty()) {
            this.createZipExecCommand(parameters);
            parameters.clear();
        }
        this.createZipRootFileCommand();
    }

    private void createZipRootFileCommand() {
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        ArrayList<String> parameters = new ArrayList<String>(1);
        parameters.add("-r -q ${zipargs} " + this.getPropertyFormat("archiveFullPath") + " . ");
        this.script.printExecTask("zip", String.valueOf(this.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY"), parameters, null);
    }

    private void createZipExecCommand(List parameters) {
        parameters.add(0, "-r -q " + this.getPropertyFormat("zipargs") + " " + this.getPropertyFormat("archiveFullPath"));
        this.script.printExecTask("zip", this.getPropertyFormat("assemblyTempDir"), parameters, null);
    }

    protected String computeArchiveName() {
        return String.valueOf(this.featureId) + "-" + this.getPropertyFormat("buildId") + (this.configInfo.equals(Config.genericConfig()) ? "" : "-" + this.configInfo.toStringReplacingAny(".", "ANY")) + ".zip";
    }

    public void generateTarTarget() {
        ArrayList<String> parameters = new ArrayList<String>(2);
        if (this.rootFileProviders.size() > 0) {
            parameters.add("-r " + this.getPropertyFormat("assemblyTempDir") + '/' + this.getPropertyFormat("collectingFolder") + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + this.getPropertyFormat("collectingFolder") + ' ' + this.getPropertyFormat("assemblyTempDir"));
            this.script.printExecTask("cp", this.getPropertyFormat("basedir"), parameters, null);
            parameters.clear();
            parameters.add("-rf " + this.getPropertyFormat("assemblyTempDir") + '/' + this.getPropertyFormat("collectingFolder") + '/' + this.configInfo.toStringReplacingAny(".", "ANY"));
            this.script.printExecTask("rm", this.getPropertyFormat("basedir"), parameters, null);
        }
        parameters.clear();
        parameters.add("-cvf " + this.getPropertyFormat("archiveFullPath") + ' ' + this.getPropertyFormat("archivePrefix") + ' ');
        this.script.printExecTask("tar", this.getPropertyFormat("assemblyTempDir"), parameters, null);
    }

    private void generateAntZipTarget() {
        FileSet[] filesPlugins = new FileSet[this.plugins.length];
        int i = 0;
        while (i < this.plugins.length) {
            Object[] shape = this.getFinalShape(this.plugins[i].getSymbolicName(), this.plugins[i].getVersion().toString(), (byte)0);
            filesPlugins[i] = new ZipFileSet(String.valueOf(this.getPropertyFormat("eclipse.base")) + '/' + "plugins" + '/' + (String)shape[0], shape[1] == FILE, null, null, null, null, null, String.valueOf(this.getPropertyFormat("pluginArchivePrefix")) + '/' + (String)shape[0], null);
            ++i;
        }
        if (this.plugins.length != 0) {
            this.script.printZipTask(this.getPropertyFormat("archiveFullPath"), null, false, true, filesPlugins);
        }
        FileSet[] filesFeatures = new FileSet[this.features.length];
        int i2 = 0;
        while (i2 < this.features.length) {
            Object[] shape = this.getFinalShape(this.features[i2].getVersionedIdentifier().getIdentifier(), this.features[i2].getVersionedIdentifier().getVersion().toString(), (byte)1);
            filesFeatures[i2] = new ZipFileSet(String.valueOf(this.getPropertyFormat("eclipse.base")) + '/' + "features" + '/' + (String)shape[0], shape[1] == FILE, null, null, null, null, null, String.valueOf(this.getPropertyFormat("featureArchivePrefix")) + '/' + (String)shape[0], null);
            ++i2;
        }
        if (this.features.length != 0) {
            this.script.printZipTask(this.getPropertyFormat("archiveFullPath"), null, false, true, filesFeatures);
        }
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        FileSet[] rootFiles = new FileSet[]{new ZipFileSet(String.valueOf(this.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + this.getPropertyFormat("collectingFolder"), false, null, "**/**", null, null, null, this.getPropertyFormat("archivePrefix"), null)};
        this.script.printZipTask(this.getPropertyFormat("archiveFullPath"), null, false, true, rootFiles);
    }

    private void generateAntTarTarget() {
        FileSet[] filesPlugins = new FileSet[this.plugins.length];
        int i = 0;
        while (i < this.plugins.length) {
            Object[] shape = this.getFinalShape(this.plugins[i].getSymbolicName(), this.plugins[i].getVersion().toString(), (byte)0);
            filesPlugins[i] = new TarFileSet(String.valueOf(this.getPropertyFormat("eclipse.base")) + '/' + "plugins" + '/' + (String)shape[0], shape[1] == FILE, null, null, null, null, null, String.valueOf(this.getPropertyFormat("pluginArchivePrefix")) + '/' + (String)shape[0], null);
            ++i;
        }
        if (this.plugins.length != 0) {
            this.script.printTarTask(this.getPropertyFormat("archiveFullPath"), null, false, true, filesPlugins);
        }
        FileSet[] filesFeatures = new FileSet[this.features.length];
        int i2 = 0;
        while (i2 < this.features.length) {
            Object[] shape = this.getFinalShape(this.features[i2].getVersionedIdentifier().getIdentifier(), this.features[i2].getVersionedIdentifier().getVersion().toString(), (byte)1);
            filesFeatures[i2] = new TarFileSet(String.valueOf(this.getPropertyFormat("eclipse.base")) + '/' + "features" + '/' + (String)shape[0], shape[1] == FILE, null, null, null, null, null, String.valueOf(this.getPropertyFormat("featureArchivePrefix")) + '/' + (String)shape[0], null);
            ++i2;
        }
        if (this.features.length != 0) {
            this.script.printTarTask(this.getPropertyFormat("archiveFullPath"), null, false, true, filesFeatures);
        }
        if (this.rootFileProviders.size() == 0) {
            return;
        }
        FileSet[] rootFiles = new FileSet[]{new TarFileSet(String.valueOf(this.getPropertyFormat("eclipse.base")) + '/' + this.configInfo.toStringReplacingAny(".", "ANY") + '/' + this.getPropertyFormat("collectingFolder"), false, null, "**/**", null, null, null, this.getPropertyFormat("archivePrefix"), null)};
        this.script.printTarTask(this.getPropertyFormat("archiveFullPath"), null, false, true, rootFiles);
    }
}

