/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.site.BuildTimeFeature;
import org.eclipse.update.core.IFeature;

public class AssemblyInformation {
    private Map assembleInformation = new HashMap(8);

    public AssemblyInformation() {
        Iterator iter = AbstractScriptGenerator.getConfigInfos().iterator();
        while (iter.hasNext()) {
            this.assembleInformation.put(iter.next(), new AssemblyLevelConfigInfo());
        }
    }

    public void addFeature(Config config, IFeature feature) {
        AssemblyLevelConfigInfo entry = (AssemblyLevelConfigInfo)this.assembleInformation.get(config);
        entry.addFeature(feature);
    }

    public void removeFeature(Config config, IFeature feature) {
        AssemblyLevelConfigInfo entry = (AssemblyLevelConfigInfo)this.assembleInformation.get(config);
        entry.removeFeature(feature);
    }

    public void addPlugin(Config config, BundleDescription plugin) {
        AssemblyLevelConfigInfo entry = (AssemblyLevelConfigInfo)this.assembleInformation.get(config);
        entry.addPlugin(plugin);
    }

    public Collection getPlugins(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).getPlugins();
    }

    public Collection getFeatures(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).getFeatures();
    }

    public boolean copyRootFile(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).hasRootFile();
    }

    public Collection getRootFileProviders(Config config) {
        return ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).getRootFileProvider();
    }

    public void addRootFileProvider(Config config, IFeature feature) {
        ((AssemblyLevelConfigInfo)this.assembleInformation.get(config)).addRootFileProvider(feature);
    }

    private class AssemblyLevelConfigInfo {
        private Collection plugins = new HashSet(20);
        private Collection features = new HashSet(7);
        private Collection rootFileProviders = new HashSet(7);

        AssemblyLevelConfigInfo() {
        }

        public void addRootFileProvider(IFeature feature) {
            Iterator iter = this.rootFileProviders.iterator();
            while (iter.hasNext()) {
                BuildTimeFeature featureDescriptor = (BuildTimeFeature)((Object)iter.next());
                if (!((BuildTimeFeature)feature).getFeatureIdentifier().equals(featureDescriptor.getFeatureIdentifier()) || !((BuildTimeFeature)feature).getFeatureVersion().equals(featureDescriptor.getFeatureVersion())) continue;
                return;
            }
            this.rootFileProviders.add(feature);
        }

        public Collection getRootFileProvider() {
            return this.rootFileProviders;
        }

        public boolean hasRootFile() {
            return this.rootFileProviders.size() > 0;
        }

        public Collection getFeatures() {
            return this.features;
        }

        public Collection getPlugins() {
            return this.plugins;
        }

        public void addFeature(IFeature feature) {
            Iterator iter = this.features.iterator();
            while (iter.hasNext()) {
                BuildTimeFeature featureDescriptor = (BuildTimeFeature)((Object)iter.next());
                if (!((BuildTimeFeature)feature).getFeatureIdentifier().equals(featureDescriptor.getFeatureIdentifier()) || !((BuildTimeFeature)feature).getFeatureVersion().equals(featureDescriptor.getFeatureVersion())) continue;
                return;
            }
            this.features.add(feature);
        }

        public void addPlugin(BundleDescription plugin) {
            this.plugins.add(plugin);
        }

        public void removeFeature(IFeature feature) {
            Iterator iter = this.features.iterator();
            while (iter.hasNext()) {
                BuildTimeFeature featureDescriptor = (BuildTimeFeature)((Object)iter.next());
                if (!((BuildTimeFeature)feature).getFeatureIdentifier().equals(featureDescriptor.getFeatureIdentifier()) || !((BuildTimeFeature)feature).getFeatureVersion().equals(featureDescriptor.getFeatureVersion())) continue;
                this.features.remove((Object)featureDescriptor);
                return;
            }
        }
    }
}

