/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.builder;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.DevClassPathHelper;
import org.eclipse.pde.internal.build.site.BuildTimeSite;
import org.eclipse.pde.internal.build.site.BuildTimeSiteFactory;
import org.eclipse.update.core.IPlatformEnvironment;

public abstract class AbstractBuildScriptGenerator
extends AbstractScriptGenerator {
    protected String[] pluginPath;
    protected DevClassPathHelper devEntries;
    protected AssemblyInformation assemblyData;
    protected Properties buildProperties;
    protected BuildTimeSiteFactory siteFactory;
    private Set compiledElements;
    private boolean includePlatformIndependent = true;

    protected abstract Properties getBuildProperties() throws CoreException;

    public void setDevEntries(String entries) {
        this.devEntries = new DevClassPathHelper(entries);
    }

    public void setDevEntries(DevClassPathHelper entries) {
        this.devEntries = entries;
    }

    public void includePlatformIndependent(boolean value) {
        this.includePlatformIndependent = value;
    }

    public boolean isPlatformIndependentIncluded() {
        return this.includePlatformIndependent;
    }

    protected String[] getPluginPath() {
        return this.pluginPath;
    }

    public void setPluginPath(String[] path) {
        this.pluginPath = path;
    }

    public BuildTimeSite getSite(boolean refresh) throws CoreException {
        if (this.siteFactory != null && !refresh) {
            return (BuildTimeSite)this.siteFactory.createSite();
        }
        if (this.siteFactory == null || refresh) {
            this.siteFactory = new BuildTimeSiteFactory();
        }
        this.siteFactory.setSitePaths(this.getPaths());
        return (BuildTimeSite)this.siteFactory.createSite();
    }

    private String[] getPaths() {
        if (this.pluginPath != null) {
            return this.pluginPath;
        }
        return new String[]{AbstractScriptGenerator.workingDirectory};
    }

    public void setBuildSiteFactory(BuildTimeSiteFactory siteFactory) {
        this.siteFactory = siteFactory;
    }

    protected int scan(StringBuffer buf, int start, String target) {
        return this.scan(buf, start, new String[]{target});
    }

    protected int scan(StringBuffer buf, int start, String[] targets) {
        int i = start;
        while (i < buf.length()) {
            int j = 0;
            while (j < targets.length) {
                String match;
                if (i < buf.length() - targets[j].length() && targets[j].equals(match = buf.substring(i, i + targets[j].length()))) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return -1;
    }

    protected StringBuffer readFile(File target) throws IOException {
        return this.readFile(new FileInputStream(target));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected StringBuffer readFile(InputStream stream) throws IOException {
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(stream));
        StringBuffer result = new StringBuffer();
        char[] buf = new char[4096];
        try {
            int count = reader.read(buf, 0, buf.length);
            while (count != -1) {
                result.append(buf, 0, count);
                count = reader.read(buf, 0, buf.length);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                reader.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        reader.close();
        return result;
    }

    protected void updateVersion(File buildFile, String propertyName, String version) throws IOException {
        String newVersion;
        int end;
        StringBuffer buffer = this.readFile(buildFile);
        int pos = this.scan(buffer, 0, propertyName);
        if (pos == -1) {
            return;
        }
        if ((pos = this.scan(buffer, pos, "value")) == -1) {
            return;
        }
        int begin = this.scan(buffer, pos, "\"");
        if (begin == -1) {
            return;
        }
        if ((end = this.scan(buffer, ++begin, "\"")) == -1) {
            return;
        }
        String currentVersion = buffer.substring(begin, end);
        if (currentVersion.equals(newVersion = "_" + version)) {
            return;
        }
        buffer.replace(begin, end, newVersion);
        Utils.transferStreams(new ByteArrayInputStream(buffer.toString().getBytes()), new FileOutputStream(buildFile));
    }

    public List selectConfigs(IPlatformEnvironment element) {
        Config config;
        Iterator iter;
        ArrayList result = new ArrayList(AbstractScriptGenerator.getConfigInfos());
        if (!(element.getOS() != null && !element.getOS().equals(Config.ANY) || this.includePlatformIndependent || element.getWS() != null && !element.getWS().equals(Config.ANY) || this.includePlatformIndependent || element.getOSArch() != null && !element.getOSArch().equals(Config.ANY) || this.includePlatformIndependent)) {
            result.clear();
            return result;
        }
        if (element.getOS() != null && !element.getOS().equals(Config.ANY)) {
            iter = result.iterator();
            while (iter.hasNext()) {
                config = (Config)iter.next();
                if (element.getOS().indexOf(config.getOs()) != -1) continue;
                iter.remove();
            }
        }
        if (element.getWS() != null && !element.getWS().equals(Config.ANY)) {
            iter = result.iterator();
            while (iter.hasNext()) {
                config = (Config)iter.next();
                if (element.getWS().indexOf(config.getWs()) != -1) continue;
                iter.remove();
            }
        }
        if (element.getOSArch() != null && !element.getOSArch().equals(Config.ANY)) {
            iter = result.iterator();
            while (iter.hasNext()) {
                config = (Config)iter.next();
                if (element.getOSArch().indexOf(config.getArch()) != -1) continue;
                iter.remove();
            }
        }
        return result;
    }

    public Set getCompiledElements() {
        if (this.compiledElements == null) {
            this.compiledElements = new HashSet();
        }
        return this.compiledElements;
    }

    public void setCompiledElements(Set compiledElements) {
        this.compiledElements = compiledElements;
    }
}

