/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.packager;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.internal.build.AbstractScriptGenerator;
import org.eclipse.pde.internal.build.AssemblyInformation;
import org.eclipse.pde.internal.build.Config;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.pde.internal.build.builder.FeatureBuildScriptGenerator;
import org.eclipse.pde.internal.build.packager.PackagingConfigScriptGenerator;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IPlatformEnvironment;
import org.eclipse.update.core.model.IncludedFeatureReferenceModel;

public class PackagerBuildScriptGenerator
extends FeatureBuildScriptGenerator {
    boolean zipWithEclipse = false;
    private String packagingPropertiesLocation;
    private String[] featureList;
    private String[] rootFiles;
    private String[] rootDirs;
    private String outputFormat = "zip";
    private boolean groupConfigs = false;

    public void groupConfigs(boolean group) {
        this.groupConfigs = group;
    }

    public PackagerBuildScriptGenerator() {
    }

    public PackagerBuildScriptGenerator(String featureId, AssemblyInformation assemblageInformation) throws CoreException {
        super(featureId, null, assemblageInformation);
    }

    public void run() throws CoreException {
        AssemblyInformation assemblageInformation = new AssemblyInformation();
        int i = 0;
        while (i < this.featureList.length) {
            PackagerBuildScriptGenerator generator = new PackagerBuildScriptGenerator(this.featureList[i], assemblageInformation);
            generator.setGenerateIncludedFeatures(true);
            generator.setAnalyseChildren(true);
            generator.setSourceFeatureGeneration(false);
            generator.setBinaryFeatureGeneration(true);
            generator.setScriptGeneration(false);
            generator.setPluginPath(this.pluginPath);
            generator.setBuildSiteFactory(this.siteFactory);
            generator.setDevEntries(this.devEntries);
            generator.setCompiledElements(this.getCompiledElements());
            generator.setBuildingOSGi(AbstractScriptGenerator.isBuildingOSGi());
            generator.includePlatformIndependent(this.isPlatformIndependentIncluded());
            this.setFeature(this.featureList[i]);
            generator.generate();
            ++i;
        }
        PackagingConfigScriptGenerator configAssembler = new PackagingConfigScriptGenerator();
        HashSet allPlugins = new HashSet();
        HashSet allFeatures = new HashSet();
        HashSet allRootFiles = new HashSet();
        Iterator allConfigs = AbstractScriptGenerator.getConfigInfos().iterator();
        while (allConfigs.hasNext()) {
            Config element = (Config)allConfigs.next();
            allPlugins.addAll(assemblageInformation.getPlugins(element));
            allFeatures.addAll(assemblageInformation.getFeatures(element));
            allRootFiles.addAll(assemblageInformation.getRootFileProviders(element));
            if (!this.groupConfigs) break;
        }
        configAssembler.initialize(AbstractScriptGenerator.workingDirectory, "assemble.xml", "", this.groupConfigs ? new Config("delta", "delta", "delta") : (Config)AbstractScriptGenerator.getConfigInfos().get(0), allPlugins, allFeatures, allRootFiles);
        configAssembler.setPackagingPropertiesLocation(this.packagingPropertiesLocation);
        configAssembler.rootFiles(this.rootFiles);
        configAssembler.rootDirs(this.rootDirs);
        configAssembler.setOutput(this.outputFormat);
        configAssembler.generate();
    }

    protected void generateIncludedFeatureBuildFile() throws CoreException {
        IIncludedFeatureReference[] referencedFeatures = this.feature.getIncludedFeatureReferences();
        int i = 0;
        while (i < referencedFeatures.length) {
            block3: {
                String featureId = ((IncludedFeatureReferenceModel)referencedFeatures[i]).getFeatureIdentifier();
                PackagerBuildScriptGenerator generator = new PackagerBuildScriptGenerator(featureId, this.assemblyData);
                generator.setGenerateIncludedFeatures(true);
                generator.setAnalyseChildren(true);
                generator.setSourceFeatureGeneration(false);
                generator.setBinaryFeatureGeneration(true);
                generator.setScriptGeneration(false);
                generator.setPluginPath(this.pluginPath);
                generator.setBuildSiteFactory(this.siteFactory);
                generator.setDevEntries(this.devEntries);
                generator.setCompiledElements(this.getCompiledElements());
                generator.setBuildingOSGi(AbstractScriptGenerator.isBuildingOSGi());
                generator.includePlatformIndependent(this.isPlatformIndependentIncluded());
                try {
                    generator.generate();
                }
                catch (CoreException exception) {
                    if (exception.getStatus().getCode() != 1 || referencedFeatures[i].isOptional()) break block3;
                    throw exception;
                }
            }
            ++i;
        }
    }

    public void setPropertyFile(String propertyFile) {
        this.packagingPropertiesLocation = propertyFile;
    }

    public void setFeatureList(String features) {
        this.featureList = Utils.getArrayFromString(features, ",");
    }

    public void setRootFiles(String[] rootFiles) {
        this.rootFiles = rootFiles;
    }

    public void setRootDirs(String[] rootDirs) {
        this.rootDirs = rootDirs;
    }

    public void setOutput(String format) {
        this.outputFormat = format;
    }

    protected void collectElementToAssemble(IFeature featureToCollect) {
        if (this.assemblyData == null) {
            return;
        }
        List correctConfigs = this.selectConfigs((IPlatformEnvironment)featureToCollect);
        Iterator iter = correctConfigs.iterator();
        while (iter.hasNext()) {
            Config config = (Config)iter.next();
            this.assemblyData.addFeature(config, this.feature);
        }
    }
}

