/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.console;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.ui.console.FileLink;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleHyperlink;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.externaltools.internal.model.StringMatcher;

public class JavacLineTracker
implements IConsoleLineTracker {
    private IConsole fConsole;
    private IFile fLastFile;
    private StringMatcher fEclipseCompilerMatcher;
    private StringMatcher fEclipseCompilerTaskEndMatcher;
    private StringMatcher fJavacMatcher;
    private StringMatcher fJavacTaskEndMatcher;
    private StringMatcher fJikesMatcher;
    private StringMatcher fJikesTrollingTaskEndMatcher;
    private boolean fTrolling = false;

    public void init(IConsole console) {
        this.fConsole = console;
        this.fEclipseCompilerMatcher = new StringMatcher("*[*javac*]*ERROR in*.java*(at line*)*", false, false);
        this.fEclipseCompilerTaskEndMatcher = new StringMatcher("javac*]*ERROR in", false, false);
        this.fJavacMatcher = new StringMatcher("*[*javac*] *.java:*:*", false, false);
        this.fJavacTaskEndMatcher = new StringMatcher("javac*] ", false, false);
        this.fJikesMatcher = new StringMatcher("*[*javac*] *\"*.java\":", false, false);
        this.fJikesTrollingTaskEndMatcher = new StringMatcher("javac*]", false, false);
    }

    public void lineAppended(IRegion line) {
        block28: {
            try {
                int index;
                int lineOffset = line.getOffset();
                int lineLength = line.getLength();
                String text = this.fConsole.getDocument().get(lineOffset, lineLength);
                String fileName = null;
                String lineNumber = "";
                int fileStart = -1;
                if (this.fEclipseCompilerMatcher.match(text)) {
                    this.fTrolling = false;
                    StringMatcher.Position matchPos = this.fEclipseCompilerMatcher.find(text, 0, text.length());
                    StringMatcher.Position taskEndPos = this.fEclipseCompilerTaskEndMatcher.find(text, matchPos.getStart(), matchPos.getEnd());
                    if (taskEndPos != null) {
                        fileStart = taskEndPos.getEnd();
                        index = text.lastIndexOf("(at line ");
                        if (index > 0) {
                            int fileEnd = index - 1;
                            int numberStart = index + 9;
                            index = text.lastIndexOf(41);
                            if (index > 0) {
                                int numberEnd = index;
                                fileName = text.substring(fileStart, fileEnd).trim();
                                lineNumber = text.substring(numberStart, numberEnd).trim();
                            }
                        }
                    }
                } else if (this.fJavacMatcher.match(text)) {
                    this.fTrolling = false;
                    StringMatcher.Position matchPos = this.fJavacMatcher.find(text, 0, text.length());
                    StringMatcher.Position taskEndPos = this.fJavacTaskEndMatcher.find(text, matchPos.getStart(), matchPos.getEnd());
                    if (taskEndPos != null && (index = text.indexOf(".java:", fileStart = taskEndPos.getEnd())) > 0) {
                        int numberStart = index + 6;
                        fileName = text.substring(fileStart, numberStart - 1).trim();
                        index = text.indexOf(":", numberStart);
                        if (index > numberStart) {
                            lineNumber = text.substring(numberStart, index);
                        }
                    }
                } else if (this.fJikesMatcher.match(text)) {
                    int index2;
                    fileStart = text.indexOf(34);
                    if ((index2 = text.indexOf(".java\"", ++fileStart)) > 0) {
                        fileName = text.substring(fileStart, index2 += 5).trim();
                        this.fTrolling = true;
                    }
                } else if (this.fTrolling) {
                    StringMatcher.Position taskEndPos = this.fJikesTrollingTaskEndMatcher.find(text, 0, text.length());
                    if (taskEndPos != null) {
                        int index3 = taskEndPos.getEnd();
                        int numEnd = text.indexOf(".", index3);
                        if (numEnd > 0) {
                            String number = text.substring(index3, numEnd).trim();
                            try {
                                int num = Integer.parseInt(number);
                                int numStart = text.indexOf(number, index3);
                                if (this.fLastFile != null && this.fLastFile.exists()) {
                                    FileLink link = new FileLink(this.fLastFile, null, -1, -1, num);
                                    this.fConsole.addLink((IConsoleHyperlink)link, lineOffset + numStart, lineLength - numStart);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else {
                        this.fTrolling = false;
                    }
                }
                if (fileName == null) break block28;
                int num = -1;
                try {
                    num = Integer.parseInt(lineNumber);
                }
                catch (NumberFormatException numberFormatException) {}
                IFile file = null;
                Path filePath = new Path(fileName);
                if (this.fLastFile != null && this.fLastFile.getLocation().equals((Object)filePath)) {
                    file = this.fLastFile;
                } else {
                    IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)filePath);
                    if (files.length != 0) {
                        file = files[0];
                    }
                }
                this.fLastFile = file;
                if (file != null && file.exists()) {
                    FileLink link = new FileLink(file, null, -1, -1, num);
                    this.fConsole.addLink((IConsoleHyperlink)link, lineOffset + fileStart, lineLength - fileStart);
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public void dispose() {
        this.fConsole = null;
    }
}

