/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.debug.model;

import org.eclipse.ant.internal.ui.debug.model.AntDebugElement;
import org.eclipse.ant.internal.ui.debug.model.AntDebugTarget;
import org.eclipse.ant.internal.ui.debug.model.AntThread;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;

public class AntStackFrame
extends AntDebugElement
implements IStackFrame {
    private AntThread fThread;
    private String fName;
    private int fLineNumber;
    private String fFileName;
    private String fFilePath;
    private int fId;

    public AntStackFrame(AntThread thread, int id, String name, String filePath, int lineNumber) {
        super((AntDebugTarget)thread.getDebugTarget());
        this.fId = id;
        this.fThread = thread;
        this.fLineNumber = lineNumber;
        this.fName = name;
        this.fFilePath = filePath;
        this.fFileName = new Path(this.fFilePath).lastSegment();
    }

    public IThread getThread() {
        return this.fThread;
    }

    public IVariable[] getVariables() {
        return this.fThread.getVariables();
    }

    public boolean hasVariables() {
        return this.isSuspended();
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getCharStart() {
        return -1;
    }

    public int getCharEnd() {
        return -1;
    }

    public String getName() {
        return this.fName;
    }

    public IRegisterGroup[] getRegisterGroups() {
        return null;
    }

    public boolean hasRegisterGroups() {
        return false;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().stepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public String getSourceName() {
        return this.fFileName;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AntStackFrame) {
            AntStackFrame sf = (AntStackFrame)((Object)obj);
            if (this.getSourceName() != null) {
                return this.getSourceName().equals(sf.getSourceName()) && sf.getLineNumber() == this.getLineNumber() && sf.fId == this.fId;
            }
            return sf.fId == this.fId;
        }
        return false;
    }

    public int hashCode() {
        if (this.getSourceName() == null) {
            return this.fId;
        }
        return this.getSourceName().hashCode() + this.fId;
    }

    protected int getIdentifier() {
        return this.fId;
    }
}

