/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsMainTab;
import org.eclipse.ui.externaltools.internal.ui.FileSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class AntMainTab
extends ExternalToolsMainTab {
    private String fCurrentLocation = null;
    private Button fSetInputHandlerButton;

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.fCurrentLocation = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        }
        catch (CoreException coreException) {}
        this.updateCheckButtons(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        try {
            String newLocation = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
            if (newLocation != null) {
                if (!newLocation.equals(this.fCurrentLocation)) {
                    this.updateTargetsTab();
                    this.fCurrentLocation = newLocation;
                }
            } else if (this.fCurrentLocation != null) {
                this.updateTargetsTab();
                this.fCurrentLocation = newLocation;
            }
        }
        catch (CoreException coreException) {}
        this.setAttribute("org.eclipse.ant.uiSET_INPUTHANDLER", configuration, this.fSetInputHandlerButton.getSelection(), true);
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        WorkbenchHelp.setHelp((Control)mainComposite, (String)"org.eclipse.ant.ui.ant_main_tab_context");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createLocationComponent(mainComposite);
        this.createWorkDirectoryComponent(mainComposite);
        this.createArgumentComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 2);
        this.createSetInputHandlerComponent(mainComposite);
        Dialog.applyDialogFont((Control)parent);
    }

    private void createSetInputHandlerComponent(Composite parent) {
        this.fSetInputHandlerButton = this.createCheckButton(parent, AntLaunchConfigurationMessages.getString("AntMainTab.0"));
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.fSetInputHandlerButton.setLayoutData((Object)data);
        this.fSetInputHandlerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void updateCheckButtons(ILaunchConfiguration configuration) {
        boolean setInputHandler = true;
        try {
            setInputHandler = configuration.getAttribute("org.eclipse.ant.uiSET_INPUTHANDLER", true);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(AntLaunchConfigurationMessages.getString("AntMainTab.1"), ce);
        }
        this.fSetInputHandlerButton.setSelection(setInputHandler);
    }

    protected void handleWorkspaceLocationButtonSelected() {
        FileSelectionDialog dialog = new FileSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), AntLaunchConfigurationMessages.getString("AntMainTab.&Select_a_build_file__1"));
        dialog.setFileFilter("*.xml", true);
        dialog.open();
        IStructuredSelection result = dialog.getResult();
        if (result == null) {
            return;
        }
        Object file = result.getFirstElement();
        if (file instanceof IFile) {
            this.locationField.setText(VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", ((IFile)file).getFullPath().toString()));
        }
    }

    protected String getWorkingDirectoryLabel() {
        return AntLaunchConfigurationMessages.getString("AntMainTab.Base_&Directory__3");
    }

    private void updateTargetsTab() {
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
        int i = 0;
        while (i < tabs.length) {
            ILaunchConfigurationTab tab = tabs[i];
            if (tab instanceof AntTargetsTab) {
                ((AntTargetsTab)tab).setDirty(true);
                break;
            }
            ++i;
        }
    }

    protected String getLocationLabel() {
        return AntLaunchConfigurationMessages.getString("AntMainTab.6");
    }
}

