/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.core.AntObject;
import org.eclipse.ant.internal.ui.AntUIImages;
import org.eclipse.ant.internal.ui.preferences.AntPreferencesMessages;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class AntObjectLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    public void dispose() {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof Property) {
            return AntObjectLabelProvider.getPropertyImage();
        }
        if (element instanceof Type) {
            return this.getTypeImage();
        }
        if (element instanceof Task) {
            return this.getTaskImage();
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof Property) {
            Property property = (Property)element;
            if (property.isDefault()) {
                return String.valueOf(element.toString()) + MessageFormat.format(AntPreferencesMessages.getString("AntObjectLabelProvider.10"), property.getPluginLabel());
            }
        } else if (element instanceof AntObject) {
            AntObject object = (AntObject)element;
            StringBuffer text = new StringBuffer(object.toString());
            text.append(" (");
            text.append(object.getLibraryEntry().getLabel());
            text.append(": ");
            text.append(object.getClassName());
            text.append(')');
            if (object.isDefault()) {
                text.append(MessageFormat.format(AntPreferencesMessages.getString("AntObjectLabelProvider.10"), object.getPluginLabel()));
            }
            return text.toString();
        }
        return element.toString();
    }

    public Image getTypeImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.type");
    }

    public Image getTaskImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_TASK_TSK");
    }

    public static Image getPropertyImage() {
        return AntUIImages.getImage("org.eclipse.ant.ui.IMG_PROPERTY");
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof AntObject) {
            if (((AntObject)element).isDefault()) {
                Display display = Display.getCurrent();
                return display.getSystemColor(29);
            }
        } else if (element instanceof Property && ((Property)element).isDefault()) {
            Display display = Display.getCurrent();
            return display.getSystemColor(29);
        }
        return null;
    }
}

