/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.preferences.AbstractClasspathEntry;
import org.eclipse.ant.internal.ui.preferences.IClasspathEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;

public class ClasspathEntry
extends AbstractClasspathEntry {
    private URL url = null;
    private String variableString = null;
    private IAntClasspathEntry entry = null;

    public ClasspathEntry(Object o, IClasspathEntry parent) {
        this.parent = parent;
        if (o instanceof URL) {
            this.url = (URL)o;
        } else if (o instanceof String) {
            this.variableString = (String)o;
        } else if (o instanceof IAntClasspathEntry) {
            this.entry = (IAntClasspathEntry)o;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof IAntClasspathEntry) {
            IAntClasspathEntry other = (IAntClasspathEntry)obj;
            return other.getLabel().equals(this.getLabel());
        }
        return false;
    }

    public int hashCode() {
        return this.getLabel().hashCode();
    }

    public String toString() {
        if (this.entry != null) {
            return this.entry.getLabel();
        }
        if (this.getURL() != null) {
            return this.getURL().getFile();
        }
        return this.getVariableString();
    }

    protected URL getURL() {
        return this.url;
    }

    protected String getVariableString() {
        return this.variableString;
    }

    public String getLabel() {
        if (this.entry == null) {
            return this.toString();
        }
        return this.entry.getLabel();
    }

    public URL getEntryURL() {
        if (this.entry != null) {
            return this.entry.getEntryURL();
        }
        if (this.url != null) {
            return this.url;
        }
        try {
            String expanded = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(this.variableString);
            return new URL("file:" + expanded);
        }
        catch (CoreException e) {
            AntUIPlugin.log(e);
        }
        catch (MalformedURLException e) {
            AntUIPlugin.log(e);
        }
        return null;
    }
}

