/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PlatformConfiguration;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;

public class TargetPlatform
implements IEnvironmentVariables {
    private static final String BOOT_ID = "org.eclipse.core.boot";

    public static String[] createPluginPath() throws CoreException {
        return TargetPlatform.createPluginPath(TargetPlatform.getVisibleModels());
    }

    public static String[] createPluginPath(IPluginModelBase[] models) throws CoreException {
        String[] paths = new String[models.length];
        int i = 0;
        while (i < models.length) {
            paths[i] = models[i].getInstallLocation();
            ++i;
        }
        return paths;
    }

    private static IPluginModelBase[] getVisibleModels() {
        Vector result = new Vector();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        TargetPlatform.addFromList(result, manager.getPlugins());
        IPluginModelBase[] array = result.toArray(new IPluginModelBase[result.size()]);
        return array;
    }

    private static void addFromList(Vector result, IPluginModelBase[] list) {
        int i = 0;
        while (i < list.length) {
            IPluginModelBase model = list[i];
            if (model.isEnabled()) {
                result.add(list[i]);
            }
            ++i;
        }
    }

    public static void createPlatformConfigurationArea(Map pluginMap, File configDir, String brandingPluginID) throws CoreException {
        try {
            if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
                if (pluginMap.containsKey("org.eclipse.update.configurator")) {
                    TargetPlatform.savePlatformConfiguration(ConfiguratorUtils.getPlatformConfiguration(null), configDir, pluginMap, brandingPluginID);
                }
            } else {
                TargetPlatform.savePlatformConfiguration(new PlatformConfiguration(null), new File(configDir, "platform.cfg"), pluginMap, brandingPluginID);
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.length() == 0) {
                message = PDECore.getResourceString("TargetPlatform.exceptionThrown");
            }
            throw new CoreException((IStatus)new Status(4, PDECore.getPluginId(), 4, message, (Throwable)e));
        }
    }

    public static String getBundleURL(String id, Map pluginMap) {
        IPluginModelBase model = (IPluginModelBase)pluginMap.get(id);
        if (model == null) {
            return null;
        }
        return "file:" + new Path(model.getInstallLocation()).addTrailingSeparator().toString();
    }

    private static void savePlatformConfiguration(IPlatformConfiguration platformConfiguration, File configFile, Map pluginMap, String primaryFeatureId) throws IOException, CoreException, MalformedURLException {
        PluginVersionIdentifier bootVid;
        PluginVersionIdentifier breakVid;
        String version;
        ArrayList sites = new ArrayList();
        Iterator iter = pluginMap.values().iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            IPath sitePath = TargetPlatform.getTransientSitePath(model);
            TargetPlatform.addToSite(sitePath, model, sites);
        }
        IPluginModelBase bootModel = (IPluginModelBase)pluginMap.get(BOOT_ID);
        URL configURL = new URL("file:" + configFile.getPath());
        TargetPlatform.createConfigurationEntries(platformConfiguration, bootModel, sites);
        TargetPlatform.createFeatureEntries(platformConfiguration, pluginMap, primaryFeatureId);
        platformConfiguration.refresh();
        platformConfiguration.save(configURL);
        if (bootModel != null && (version = bootModel.getPluginBase().getVersion()) != null && (breakVid = new PluginVersionIdentifier("2.0.3")).isGreaterThan(bootVid = new PluginVersionIdentifier(version))) {
            TargetPlatform.repairConfigurationVersion(configURL);
        }
    }

    private static IPath getTransientSitePath(IPluginModelBase model) {
        return new Path(model.getInstallLocation()).removeLastSegments(2);
    }

    private static void repairConfigurationVersion(URL url) throws IOException {
        File file = new File(url.getFile());
        if (file.exists()) {
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            p.setProperty("version", "1.0");
            fis.close();
            FileOutputStream fos = new FileOutputStream(file);
            p.store(fos, new Date().toString());
            fos.close();
        }
    }

    private static void addToSite(IPath path, IPluginModelBase model, ArrayList sites) {
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = (LocalSite)sites.get(i);
            if (localSite.getPath().equals((Object)path)) {
                localSite.add(model);
                return;
            }
            ++i;
        }
        LocalSite localSite = new LocalSite(path);
        localSite.add(model);
        sites.add(localSite);
    }

    private static void createConfigurationEntries(IPlatformConfiguration config, IPluginModelBase bootModel, ArrayList sites) throws CoreException, MalformedURLException {
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = (LocalSite)sites.get(i);
            String[] plugins = localSite.getRelativePluginList();
            int policy = 0;
            IPlatformConfiguration.ISitePolicy sitePolicy = config.createSitePolicy(policy, plugins);
            IPlatformConfiguration.ISiteEntry siteEntry = config.createSiteEntry(localSite.getURL(), sitePolicy);
            config.configureSite(siteEntry);
            ++i;
        }
        if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            URL bootURL = new URL("file:" + bootModel.getInstallLocation());
            config.setBootstrapPluginLocation(BOOT_ID, bootURL);
        }
        config.isTransient(true);
    }

    private static void createFeatureEntries(IPlatformConfiguration config, Map pluginMap, String primaryFeatureId) throws MalformedURLException {
        IPath targetPath = ExternalModelManager.getEclipseHome();
        if (primaryFeatureId == null) {
            return;
        }
        IFeatureModel featureModel = TargetPlatform.loadPrimaryFeatureModel(targetPath, primaryFeatureId);
        if (featureModel == null) {
            return;
        }
        IFeature feature = featureModel.getFeature();
        String featureVersion = feature.getVersion();
        String pluginId = primaryFeatureId;
        IPluginModelBase primaryPlugin = (IPluginModelBase)pluginMap.get(pluginId);
        if (primaryPlugin == null) {
            return;
        }
        URL pluginURL = new URL("file:" + primaryPlugin.getInstallLocation());
        URL[] root = new URL[]{pluginURL};
        IPlatformConfiguration.IFeatureEntry featureEntry = config.createFeatureEntry(primaryFeatureId, featureVersion, pluginId, primaryPlugin.getPluginBase().getVersion(), true, null, root);
        config.configureFeatureEntry(featureEntry);
        featureModel.dispose();
    }

    private static IFeatureModel loadPrimaryFeatureModel(IPath targetPath, String featureId) {
        File mainFeatureDir = targetPath.append("features").toFile();
        if (!mainFeatureDir.exists() || !mainFeatureDir.isDirectory()) {
            return null;
        }
        File[] featureDirs = mainFeatureDir.listFiles();
        PluginVersionIdentifier bestVid = null;
        File bestDir = null;
        int i = 0;
        while (i < featureDirs.length) {
            int loc;
            File featureDir = featureDirs[i];
            String name = featureDir.getName();
            if (featureDir.isDirectory() && name.startsWith(featureId) && (loc = name.lastIndexOf("_")) != -1) {
                String version = name.substring(loc + 1);
                PluginVersionIdentifier vid = new PluginVersionIdentifier(version);
                if (bestVid == null || vid.isGreaterThan(bestVid)) {
                    bestVid = vid;
                    bestDir = featureDir;
                }
            }
            ++i;
        }
        if (bestVid == null) {
            return null;
        }
        File manifest = new File(bestDir, "feature.xml");
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(bestDir.getAbsolutePath());
        FileInputStream stream = null;
        boolean error = false;
        try {
            stream = new FileInputStream(manifest);
            model.load(stream, false);
        }
        catch (Exception exception) {
            error = true;
        }
        if (stream != null) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        if (error || !model.isLoaded()) {
            return null;
        }
        return model;
    }

    public static String getOS() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.os");
    }

    public static String getWS() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.ws");
    }

    public static String getNL() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.nl");
    }

    public static String getOSArch() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.arch");
    }

    private static String getProperty(String key) {
        return PDECore.getDefault().getPluginPreferences().getString(key);
    }

    static class LocalSite {
        private ArrayList plugins;
        private IPath path;

        public LocalSite(IPath path) {
            this.path = path;
            this.plugins = new ArrayList();
        }

        public IPath getPath() {
            return this.path;
        }

        public URL getURL() throws MalformedURLException {
            return new URL("file:" + this.path.addTrailingSeparator().toString());
        }

        public void add(IPluginModelBase model) {
            this.plugins.add(model);
        }

        public String[] getRelativePluginList() {
            String[] list = new String[this.plugins.size()];
            int i = 0;
            while (i < this.plugins.size()) {
                IPluginModelBase model = (IPluginModelBase)this.plugins.get(i);
                Path location = new Path(model.getInstallLocation());
                if (location.segmentCount() > 2) {
                    location = location.removeFirstSegments(location.segmentCount() - 2);
                }
                if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
                    location = location.append(model.isFragmentModel() ? "fragment.xml" : "plugin.xml");
                }
                list[i] = location.setDevice(null).makeRelative().toString();
                ++i;
            }
            return list;
        }
    }
}

