/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;

public class TracingOptionsManager {
    private Properties template;

    private void createTemplate() {
        this.template = new Properties();
        IPluginModelBase[] models = PDECore.getDefault().getModelManager().getPlugins();
        int i = 0;
        while (i < models.length) {
            this.addToTemplate(models[i]);
            ++i;
        }
    }

    private void addToTemplate(IPluginModelBase model) {
        Properties modelOptions = this.getOptions(model);
        if (modelOptions == null) {
            return;
        }
        Enumeration<Object> keys = modelOptions.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            String value = modelOptions.getProperty(key);
            if (key == null || value == null) continue;
            this.template.setProperty(key, value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties getOptions(IPluginModelBase model) {
        InputStream stream;
        block9: {
            Properties properties;
            stream = null;
            try {
                try {
                    URL url = model.getResourceURL(".options");
                    if (url == null) break block9;
                    stream = url.openStream();
                    Properties modelOptions = new Properties();
                    modelOptions.load(stream);
                    properties = modelOptions;
                    Object var5_6 = null;
                }
                catch (IOException iOException) {
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            if (stream == null) return properties;
            stream.close();
            return properties;
        }
        Object var5_8 = null;
        try {}
        catch (IOException iOException) {
            return null;
        }
        if (stream == null) return null;
        stream.close();
        return null;
    }

    public Hashtable getTemplateTable(String pluginId) {
        if (this.template == null) {
            this.createTemplate();
        }
        Hashtable<String, Object> defaults = new Hashtable<String, Object>();
        Enumeration<Object> keys = this.template.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!this.belongsTo(key, pluginId)) continue;
            defaults.put(key, this.template.get(key));
        }
        return defaults;
    }

    private boolean belongsTo(String option, String pluginId) {
        Path path = new Path(option);
        String firstSegment = path.segment(0);
        return pluginId.equalsIgnoreCase(firstSegment);
    }

    public Properties getTracingOptions(Map storedOptions) {
        Properties defaults = this.getTracingTemplateCopy();
        if (storedOptions != null) {
            Iterator iter = storedOptions.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                if (!defaults.containsKey(key)) continue;
                defaults.setProperty(key, (String)storedOptions.get(key));
            }
        }
        return defaults;
    }

    public Properties getTracingTemplateCopy() {
        if (this.template == null) {
            this.createTemplate();
        }
        return (Properties)this.template.clone();
    }

    public static boolean isTraceable(IPluginModelBase model) {
        return model.getResourceURL(".options") != null;
    }

    public void reset() {
        this.template = null;
    }

    private void save(String fileName, Properties properties) {
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            properties.store(stream, "Master Tracing Options");
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    public void save(String filename, Map map, HashSet selected) {
        Properties properties = this.getTracingOptions(map);
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            Path path = new Path(key);
            if (path.segmentCount() >= 1 && selected.contains(path.segment(0).toString())) continue;
            properties.remove(key);
        }
        this.save(filename, properties);
    }

    public void save(String filename, Map map) {
        this.save(filename, this.getTracingOptions(map));
    }
}

