/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.schema;

import java.io.PrintWriter;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.schema.SchemaObject;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;

public class SchemaAttribute
extends SchemaObject
implements ISchemaAttribute {
    private static final long serialVersionUID = 1L;
    private int kind = 0;
    private int use = 0;
    private String valueFilter;
    private ISchemaSimpleType type;
    private String basedOn;
    private Object value;
    public static final String P_USE = "useProperty";
    public static final String P_VALUE_FILTER = "valueFilterProperty";
    public static final String P_VALUE = "value";
    public static final String P_KIND = "kindProperty";
    public static final String P_TYPE = "typeProperty";
    public static final String P_BASED_ON = "basedOnProperty";
    private boolean verifying;
    private boolean fTranslatable;
    private boolean fDeprecated;

    public SchemaAttribute(ISchemaAttribute att, String newName) {
        super(att.getParent(), newName);
        this.kind = att.getKind();
        this.use = att.getUse();
        this.value = att.getValue();
        this.type = new SchemaSimpleType(att.getType());
        this.basedOn = att.getBasedOn();
    }

    public SchemaAttribute(ISchemaObject parent, String name) {
        super(parent, name);
    }

    public String getBasedOn() {
        return this.basedOn;
    }

    public int getKind() {
        return this.kind;
    }

    public ISchemaSimpleType getType() {
        return this.type;
    }

    public int getUse() {
        return this.use;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueFilter() {
        return this.valueFilter;
    }

    public void setBasedOn(String newBasedOn) {
        String oldValue = this.basedOn;
        this.basedOn = newBasedOn;
        this.getSchema().fireModelObjectChanged(this, P_BASED_ON, oldValue, this.basedOn);
        this.verifyProperties();
    }

    public void setKind(int newKind) {
        Integer oldValue = new Integer(this.kind);
        this.kind = newKind;
        this.getSchema().fireModelObjectChanged(this, P_KIND, oldValue, new Integer(this.kind));
        this.verifyProperties();
    }

    public void setTranslatableProperty(boolean translatable) {
        boolean oldValue = this.fTranslatable;
        this.fTranslatable = translatable;
        this.getSchema().fireModelObjectChanged(this, "translatable", oldValue, translatable);
    }

    public void setDeprecatedProperty(boolean deprecated) {
        boolean oldValue = this.fDeprecated;
        this.fDeprecated = deprecated;
        this.getSchema().fireModelObjectChanged(this, "deprecated", oldValue, deprecated);
    }

    public void setType(ISchemaSimpleType newType) {
        ISchemaSimpleType oldValue = this.type;
        this.type = newType;
        this.getSchema().fireModelObjectChanged(this, P_TYPE, oldValue, this.type);
        this.verifyProperties();
    }

    public void setParent(ISchemaObject obj) {
        super.setParent(obj);
        if (this.type != null) {
            this.type.setSchema(this.getSchema());
        }
    }

    public void setUse(int newUse) {
        Integer oldValue = new Integer(this.use);
        this.use = newUse;
        this.getSchema().fireModelObjectChanged(this, P_USE, oldValue, new Integer(this.use));
        this.verifyProperties();
    }

    public void setValue(String value) {
        String oldValue = (String)this.value;
        this.value = value;
        this.getSchema().fireModelObjectChanged(this, P_VALUE, oldValue, value);
        this.verifyProperties();
    }

    public void setValueFilter(String valueFilter) {
        String oldValue = this.valueFilter;
        this.valueFilter = valueFilter;
        this.getSchema().fireModelObjectChanged(this, P_VALUE_FILTER, oldValue, valueFilter);
    }

    private void verifyProperties() {
        if (this.verifying) {
            return;
        }
        this.verifying = true;
        if (this.kind != 0) {
            this.ensureStringType();
            this.ensureNoRestriction();
        }
        if (this.kind != 1) {
            this.setBasedOn(null);
        }
        if (this.type != null && this.type.getName().equals("boolean")) {
            this.ensureNoRestriction();
        }
        if (this.use != 2) {
            this.setValue(null);
        }
        this.verifying = false;
    }

    private void ensureStringType() {
        if (this.type == null || this.type.getName().equals("boolean")) {
            this.setType(new SchemaSimpleType(this.getSchema(), "string"));
        }
    }

    private void ensureNoRestriction() {
        if (this.type instanceof SchemaSimpleType && ((SchemaSimpleType)this.type).getRestriction() != null) {
            SchemaSimpleType simpleType = (SchemaSimpleType)this.type;
            simpleType.setRestriction(null);
            this.setType(simpleType);
        }
    }

    public void write(String indent, PrintWriter writer) {
        String documentation;
        boolean annotation = false;
        ISchemaSimpleType type = this.getType();
        String typeName = type.getName();
        writer.print(indent);
        writer.print("<attribute name=\"" + this.getName() + "\"");
        if (type.getRestriction() == null) {
            writer.print(" type=\"" + typeName + "\"");
        }
        String useString = null;
        switch (this.getUse()) {
            case 0: {
                break;
            }
            case 2: {
                useString = "default";
                break;
            }
            case 1: {
                useString = "required";
            }
        }
        if (useString != null) {
            writer.print(" use=\"" + useString + "\"");
        }
        if (this.value != null) {
            writer.print(" value=\"" + this.value + "\"");
        }
        if ((documentation = this.getWritableDescription()) != null || this.getBasedOn() != null || this.getKind() != 0) {
            annotation = true;
            writer.println(">");
            String annIndent = String.valueOf(indent) + "   ";
            String indent2 = String.valueOf(annIndent) + "   ";
            String indent3 = String.valueOf(indent2) + "   ";
            writer.print(annIndent);
            writer.println("<annotation>");
            if (documentation != null) {
                writer.println(String.valueOf(indent2) + "<documentation>");
                writer.println(String.valueOf(indent3) + documentation);
                writer.println(String.valueOf(indent2) + "</documentation>");
            }
            if (this.getBasedOn() != null || this.getKind() != 0 || this.isDeprecated() || this.isTranslatable()) {
                writer.println(String.valueOf(indent2) + "<appInfo>");
                writer.print(String.valueOf(indent3) + "<meta.attribute");
                String kindValue = null;
                switch (this.getKind()) {
                    case 1: {
                        kindValue = "java";
                        break;
                    }
                    case 2: {
                        kindValue = "resource";
                    }
                }
                if (kindValue != null) {
                    writer.print(" kind=\"" + kindValue + "\"");
                }
                if (this.getBasedOn() != null) {
                    writer.print(" basedOn=\"" + this.getBasedOn() + "\"");
                }
                if (this.isTranslatable()) {
                    writer.print(" translatable=\"true\"");
                }
                if (this.isDeprecated()) {
                    writer.print(" deprecated=\"true\"");
                }
                writer.println("/>");
                writer.println(String.valueOf(indent2) + "</appInfo>");
            }
            writer.println(String.valueOf(annIndent) + "</annotation>");
        }
        if (type.getRestriction() != null) {
            type.write(String.valueOf(indent) + "   ", writer);
        }
        if (annotation || type.getRestriction() != null) {
            writer.println(String.valueOf(indent) + "</attribute>");
        } else {
            writer.println("/>");
        }
    }

    public boolean isTranslatable() {
        return this.fTranslatable;
    }

    public boolean isDeprecated() {
        return this.fDeprecated;
    }
}

