/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.IWritable;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.site.SiteBuildFeature;
import org.eclipse.pde.internal.core.site.SiteBuildObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteBuild
extends SiteBuildObject
implements ISiteBuild {
    private static final long serialVersionUID = 1L;
    static final String INDENT = "   ";
    private Vector features = new Vector();
    public static final String DEFAULT_PLUGIN_DIR = "plugins";
    public static final String DEFAULT_FEATURE_DIR = "features";
    private final IPath pluginLocation = new Path("plugins");
    private final IPath featureLocation = new Path("features");
    private boolean useConsole;
    private boolean autobuild;
    private boolean scrubOutput;

    public IPath getPluginLocation() {
        return this.pluginLocation;
    }

    public IPath getFeatureLocation() {
        return this.featureLocation;
    }

    public void setAutobuild(boolean value) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = new Boolean(this.autobuild);
        this.autobuild = value;
        this.firePropertyChanged("autobuild", oldValue, new Boolean(value));
    }

    public boolean isAutobuild() {
        return this.autobuild;
    }

    public void setScrubOutput(boolean value) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = new Boolean(this.scrubOutput);
        this.scrubOutput = value;
        this.firePropertyChanged("autobuild", oldValue, new Boolean(value));
    }

    public boolean getScrubOutput() {
        return this.scrubOutput;
    }

    public void setShowConsole(boolean value) throws CoreException {
        this.ensureModelEditable();
        Boolean oldValue = new Boolean(this.useConsole);
        this.useConsole = value;
        this.firePropertyChanged("show-console", oldValue, new Boolean(value));
    }

    public boolean getShowConsole() {
        return this.useConsole;
    }

    public void addFeatures(ISiteBuildFeature[] newFeatures) throws CoreException {
        this.ensureModelEditable();
        int i = 0;
        while (i < newFeatures.length) {
            ISiteBuildFeature feature = newFeatures[i];
            ((SiteBuildFeature)feature).setInTheModel(true);
            this.features.add(newFeatures[i]);
            ++i;
        }
        this.fireStructureChanged(newFeatures, 1);
    }

    public void removeFeatures(ISiteBuildFeature[] newFeatures) throws CoreException {
        this.ensureModelEditable();
        int i = 0;
        while (i < newFeatures.length) {
            ISiteBuildFeature feature = newFeatures[i];
            ((SiteBuildFeature)feature).setInTheModel(false);
            this.features.remove(newFeatures[i]);
            ++i;
        }
        this.fireStructureChanged(newFeatures, 2);
    }

    public ISiteBuildFeature[] getFeatures() {
        return this.features.toArray(new ISiteBuildFeature[this.features.size()]);
    }

    protected void reset() {
        this.features.clear();
        this.useConsole = false;
        this.autobuild = false;
        this.scrubOutput = false;
    }

    protected void parse(Node node) {
        this.autobuild = this.getBooleanAttribute(node, "autobuild");
        this.scrubOutput = this.getBooleanAttribute(node, "scrub-output");
        this.useConsole = this.getBooleanAttribute(node, "use-console");
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                this.parseChild(child);
            }
            ++i;
        }
    }

    protected void parseChild(Node child) {
        String tag = child.getNodeName().toLowerCase();
        if (tag.equals("feature")) {
            ISiteBuildFeature feature = this.getModel().createFeature();
            ((SiteBuildFeature)feature).parse(child);
            ((SiteBuildFeature)feature).setInTheModel(true);
            this.features.add(feature);
        }
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
        if (name.equals("autobuild")) {
            this.setAutobuild(newValue != null ? (Boolean)newValue : false);
        } else if (name.equals("scrub-output")) {
            this.setScrubOutput(newValue != null ? (Boolean)newValue : false);
        } else if (name.equals("show-console")) {
            this.setShowConsole(newValue != null ? (Boolean)newValue : false);
        } else {
            super.restoreProperty(name, oldValue, newValue);
        }
    }

    public void write(String indent, PrintWriter writer) {
        writer.print(String.valueOf(indent) + "<site-build");
        String indent2 = String.valueOf(indent) + INDENT;
        String indenta = String.valueOf(indent) + INDENT + INDENT;
        this.writeIfDefined(indenta, writer, "autobuild", this.autobuild ? "true" : "false");
        this.writeIfDefined(indenta, writer, "scrub-output", this.scrubOutput ? "true" : "false");
        this.writeIfDefined(indenta, writer, "use-console", this.useConsole ? "true" : "false");
        writer.println(">");
        this.writeChildren(indent2, this.features, writer);
        writer.println(String.valueOf(indent) + "</site-build>");
    }

    private void writeChildren(String indent, Vector children, PrintWriter writer) {
        int i = 0;
        while (i < children.size()) {
            IWritable writable = (IWritable)children.get(i);
            writable.write(indent, writer);
            ++i;
        }
    }

    public void resetReferences() {
        int i = 0;
        while (i < this.features.size()) {
            ISiteBuildFeature sbfeature = (ISiteBuildFeature)this.features.get(i);
            sbfeature.setReferencedFeature(null);
            ++i;
        }
    }

    private void writeIfDefined(String indent, PrintWriter writer, String attName, String attValue) {
        if (attValue == null) {
            return;
        }
        writer.println();
        writer.print(String.valueOf(indent) + attName + "=\"" + attValue + "\"");
    }
}

