/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.site;

import java.io.PrintWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteBuildObject;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class SiteBuildObject
extends PlatformObject
implements ISiteBuildObject {
    transient ISiteBuildModel model;
    transient ISiteBuildObject parent;
    boolean inTheModel;

    void setInTheModel(boolean value) {
        this.inTheModel = value;
    }

    public boolean isInTheModel() {
        return this.inTheModel;
    }

    protected void ensureModelEditable() throws CoreException {
        if (!this.model.isEditable()) {
            this.throwCoreException(PDECore.getResourceString("SiteBuildObject.readOnlyException"));
        }
    }

    protected void firePropertyChanged(String property, Object oldValue, Object newValue) {
        this.firePropertyChanged(this, property, oldValue, newValue);
    }

    protected void firePropertyChanged(ISiteBuildObject object, String property, Object oldValue, Object newValue) {
        if (this.model.isEditable() && this.model instanceof IModelChangeProvider) {
            ISiteBuildModel provider = this.model;
            provider.fireModelObjectChanged(object, property, oldValue, newValue);
        }
    }

    protected void fireStructureChanged(ISiteBuildObject child, int changeType) {
        this.fireStructureChanged(new ISiteBuildObject[]{child}, changeType);
    }

    protected void fireStructureChanged(ISiteBuildObject[] children, int changeType) {
        ISiteBuildModel model = this.getModel();
        if (model.isEditable() && model instanceof IModelChangeProvider) {
            ISiteBuildModel provider = model;
            provider.fireModelChanged(new ModelChangedEvent(provider, changeType, children, null));
        }
    }

    public ISiteBuild getSiteBuild() {
        return this.model.getSiteBuild();
    }

    public ISiteBuildModel getModel() {
        return this.model;
    }

    String getNodeAttribute(Node node, String name) {
        NamedNodeMap atts = node.getAttributes();
        Node attribute = null;
        if (atts != null) {
            attribute = atts.getNamedItem(name);
        }
        if (attribute != null) {
            return attribute.getNodeValue();
        }
        return null;
    }

    int getIntegerAttribute(Node node, String name) {
        String value = this.getNodeAttribute(node, name);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    boolean getBooleanAttribute(Node node, String name) {
        String value = this.getNodeAttribute(node, name);
        if (value != null) {
            return value.equalsIgnoreCase("true");
        }
        return false;
    }

    public ISiteBuildObject getParent() {
        return this.parent;
    }

    protected void reset() {
    }

    protected void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, PDECore.getPluginId(), 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public static String getWritableString(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public void restoreProperty(String name, Object oldValue, Object newValue) throws CoreException {
    }

    public void write(String indent, PrintWriter writer) {
    }

    public void setModel(ISiteBuildModel model) {
        this.model = model;
    }

    public void setParent(ISiteBuildObject parent) {
        this.parent = parent;
    }
}

