/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import org.eclipse.ui.internal.intro.impl.model.AbstractTextElement;
import org.eclipse.ui.internal.intro.impl.model.IntroImage;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class IntroHTML
extends AbstractTextElement {
    protected static final String TAG_HTML = "html";
    private static final String ATT_SRC = "src";
    private static final String ATT_TYPE = "type";
    private static final String ATT_ENCODING = "encoding";
    private String src;
    private String html_type;
    private String encoding;
    private IntroImage introImage;

    IntroHTML(Element element, Bundle bundle) {
        super(element, bundle);
        this.src = this.getAttribute(element, ATT_SRC);
        this.html_type = this.getAttribute(element, ATT_TYPE);
        this.encoding = this.getAttribute(element, ATT_ENCODING);
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        if (this.html_type != null && !this.html_type.equalsIgnoreCase("inline") && !this.html_type.equalsIgnoreCase("embed")) {
            this.html_type = null;
        }
        this.introImage = this.getIntroImage(element);
        this.src = IntroModelRoot.getPluginLocation(this.src, bundle);
    }

    private IntroImage getIntroImage(Element element) {
        try {
            NodeList imageElements = element.getElementsByTagName("img");
            if (imageElements.getLength() == 0) {
                return null;
            }
            IntroImage image = new IntroImage((Element)imageElements.item(0), this.getBundle());
            image.setParent(this);
            return image;
        }
        catch (Exception e) {
            Util.handleException(e.getMessage(), e);
            return null;
        }
    }

    public boolean isInlined() {
        return this.html_type != null && this.html_type.equalsIgnoreCase("inline");
    }

    public String getSrc() {
        return this.src;
    }

    public String getInlineEncoding() {
        return this.encoding;
    }

    public IntroImage getIntroImage() {
        return this.introImage;
    }

    public int getType() {
        return 32;
    }

    public Object clone() throws CloneNotSupportedException {
        IntroHTML clone = (IntroHTML)super.clone();
        if (this.introImage != null) {
            IntroImage cloneIntroImage = (IntroImage)this.introImage.clone();
            cloneIntroImage.setParent(clone);
            clone.introImage = cloneIntroImage;
        }
        return clone;
    }
}

