/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.ui.internal.intro.impl.model.IntroURL;

public class IntroURLParser {
    private String url_string = null;
    private boolean hasProtocol = false;
    private boolean isIntroUrl = false;
    private String action = null;
    private Properties parameters = null;
    private IntroURL introURL = null;

    public IntroURLParser(String url) {
        this.url_string = url;
        this.parseUrl(url);
        if (this.isIntroUrl) {
            this.introURL = new IntroURL(this.action, this.parameters);
        }
    }

    private void parseUrl(String url) {
        if (url == null) {
            return;
        }
        URL url_inst = null;
        try {
            url_inst = new URL(url);
        }
        catch (MalformedURLException malformedURLException) {
            return;
        }
        if (url_inst.getProtocol() != null) {
            this.hasProtocol = true;
            this.isIntroUrl = this.isIntoUrl(url_inst);
            if (this.isIntroUrl) {
                this.action = this.getPathAsAction(url_inst);
                this.parameters = this.getQueryParameters(url_inst);
            }
            return;
        }
    }

    private boolean isIntoUrl(URL url) {
        if (!url.getProtocol().equalsIgnoreCase("http")) {
            return false;
        }
        return url.getHost().equalsIgnoreCase("org.eclipse.ui.intro");
    }

    private String getPathAsAction(URL url) {
        String action = url.getPath();
        if (action != null) {
            action = action.substring(1);
        }
        return action;
    }

    public Properties getQueryParameters(URL url) {
        Properties properties = new Properties();
        String query = url.getQuery();
        if (query == null) {
            return properties;
        }
        String[] params = query.split("&");
        int i = 0;
        while (i < params.length) {
            String[] keyValuePair = params[i].split("=");
            properties.setProperty(keyValuePair[0], keyValuePair[1]);
            ++i;
        }
        return properties;
    }

    public boolean hasProtocol() {
        return this.hasProtocol;
    }

    public boolean hasIntroUrl() {
        return this.isIntroUrl;
    }

    public IntroURL getIntroURL() {
        return this.introURL;
    }
}

