/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model.loader;

import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.intro.impl.model.AbstractBaseIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroIdElement;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.StringUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ModelLoaderUtil {
    public static boolean isValidElementName(IConfigurationElement element, String validName) {
        return element.getName().equals(validName);
    }

    public static IConfigurationElement validateSingleContribution(IConfigurationElement[] configElements, String logAttribute) {
        int arraySize = configElements.length;
        if (arraySize == 0) {
            return null;
        }
        IConfigurationElement configElement = configElements[0];
        String msg = StringUtil.concat("Loaded ", configElement.getName(), " from ", ModelLoaderUtil.getLogString(configElement, logAttribute)).toString();
        Log.info(msg);
        if (arraySize != 1) {
            int i = 1;
            while (i < arraySize) {
                Log.warning(String.valueOf(ModelLoaderUtil.getLogString(configElements[i], logAttribute)) + " ignored due to multiple contributions");
                ++i;
            }
        }
        return configElement;
    }

    public static String getLogString(IConfigurationElement element, String logAttribute) {
        StringBuffer buffer = new StringBuffer("Bundle:");
        buffer.append(element.getNamespace());
        buffer.append("  Extension:");
        buffer.append(element.getDeclaringExtension().getExtensionPointUniqueIdentifier());
        buffer.append("  element:");
        buffer.append(element.getName());
        if (logAttribute != null) {
            buffer.append("  ");
            buffer.append(logAttribute);
            buffer.append(":");
            buffer.append(element.getAttribute(logAttribute));
        }
        return buffer.toString();
    }

    public static Element validateSingleContribution(Element[] elements, String logAttribute) {
        int arraySize = elements.length;
        if (arraySize == 0) {
            return null;
        }
        Element element = elements[0];
        String msg = StringUtil.concat("Loaded ", element.getNodeName(), " from ", ModelLoaderUtil.getLogString(element, logAttribute)).toString();
        Log.info(msg);
        if (arraySize != 1) {
            int i = 1;
            while (i < arraySize) {
                Log.warning(String.valueOf(ModelLoaderUtil.getLogString(element, logAttribute)) + " ignored due to multiple contributions");
                ++i;
            }
        }
        return element;
    }

    public static String getLogString(Element element, String logAttribute) {
        StringBuffer buffer = new StringBuffer("XML document:");
        buffer.append(element.getOwnerDocument().toString());
        buffer.append("  Parent:");
        buffer.append(element.getParentNode().getNodeName());
        buffer.append("  element:");
        buffer.append(element.getNodeName());
        if (logAttribute != null) {
            buffer.append("  ");
            buffer.append(logAttribute);
            buffer.append(":");
            buffer.append(element.getAttribute(logAttribute));
        }
        return buffer.toString();
    }

    public static Element[] getElementsByTagName(Element parent, String tagName) {
        NodeList allChildElements = parent.getElementsByTagName(tagName);
        Vector<Element> vector = new Vector<Element>();
        int i = 0;
        while (i < allChildElements.getLength()) {
            Element aElement = (Element)allChildElements.item(i);
            if (aElement.getParentNode().equals(parent)) {
                vector.add(aElement);
            }
            ++i;
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        return filteredElements;
    }

    public static Element[] getElementsByTagName(Document dom, String tagName) {
        NodeList allChildElements = dom.getElementsByTagName(tagName);
        Vector<Element> vector = new Vector<Element>();
        int i = 0;
        while (i < allChildElements.getLength()) {
            Element aElement = (Element)allChildElements.item(i);
            if (aElement.getParentNode().equals(dom.getDocumentElement())) {
                vector.add(aElement);
            }
            ++i;
        }
        Object[] filteredElements = new Element[vector.size()];
        vector.copyInto(filteredElements);
        return filteredElements;
    }

    public static Bundle getBundleFromConfigurationElement(IConfigurationElement cfg) {
        return Platform.getBundle((String)cfg.getNamespace());
    }

    public static boolean bundleHasValidState(Bundle bundle) {
        if (bundle == null || bundle.getState() == 1 || bundle.getState() == 2) {
            if (bundle == null) {
                Log.error("Intro tried accessing a NULL bundle.", null);
            } else {
                String msg = StringUtil.concat("Intro tried accessing Bundle: ", ModelLoaderUtil.getBundleHeader(bundle, "Bundle-Name"), " vendor: ", ModelLoaderUtil.getBundleHeader(bundle, "Bundle-Vendor"), " bundle state: ", String.valueOf(bundle.getState())).toString();
                Log.error(msg, null);
            }
            return false;
        }
        return true;
    }

    public static String getBundleHeader(Bundle bundle, String key) {
        return (String)bundle.getHeaders().get(key);
    }

    public static Object createClassInstance(String pluginId, String className) {
        if (pluginId == null | className == null) {
            return null;
        }
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (!ModelLoaderUtil.bundleHasValidState(bundle)) {
            return null;
        }
        try {
            Class aClass = bundle.loadClass(className);
            Object aObject = aClass.newInstance();
            return aObject;
        }
        catch (Exception e) {
            Log.error("Intro Could not instantiate: " + className + " in " + pluginId, e);
            return null;
        }
    }

    public static StringBuffer createPathToElementKey(AbstractIntroIdElement element) {
        if (element.getId() == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(element.getId());
        AbstractBaseIntroElement parent = (AbstractBaseIntroElement)element.getParent();
        while (parent != null && !parent.isOfType(1)) {
            if (parent.getId() == null) {
                return null;
            }
            buffer.insert(0, String.valueOf(parent.getId()) + ".");
            parent = (AbstractBaseIntroElement)parent.getParent();
        }
        return buffer;
    }
}

