/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.hyperlink;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlink;

public class URLHyperlinkDetector
implements IHyperlinkDetector {
    private ITextViewer fTextViewer;

    public URLHyperlinkDetector(ITextViewer textViewer) {
        Assert.isNotNull((Object)textViewer);
        this.fTextViewer = textViewer;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        char ch;
        String line;
        IRegion lineInfo;
        if (region == null || this.fTextViewer == null) {
            return null;
        }
        IDocument document = this.fTextViewer.getDocument();
        int offset = region.getOffset();
        String urlString = null;
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        int offsetInLine = offset - lineInfo.getOffset();
        int urlSeparatorOffset = line.indexOf("://");
        if (urlSeparatorOffset < 0) {
            return null;
        }
        boolean startDoubleQuote = false;
        int urlOffsetInLine = urlSeparatorOffset;
        do {
            ch = ' ';
            if (--urlOffsetInLine > -1) {
                ch = line.charAt(urlOffsetInLine);
            }
            boolean bl = startDoubleQuote = ch == '\"';
        } while (!Character.isWhitespace(ch) && !startDoubleQuote);
        ++urlOffsetInLine;
        StringTokenizer tokenizer = new StringTokenizer(line.substring(urlSeparatorOffset + 3));
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        int urlLength = tokenizer.nextToken().length() + 3 + urlSeparatorOffset - urlOffsetInLine;
        if (offsetInLine < urlOffsetInLine || offsetInLine > urlOffsetInLine + urlLength) {
            return null;
        }
        if (startDoubleQuote && line.charAt(urlOffsetInLine + urlLength - 1) == '\"') {
            --urlLength;
        }
        try {
            urlString = line.substring(urlOffsetInLine, urlOffsetInLine + urlLength);
            new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            urlString = null;
            return null;
        }
        Region urlRegion = new Region(lineInfo.getOffset() + urlOffsetInLine, urlLength);
        return new IHyperlink[]{new URLHyperlink((IRegion)urlRegion, urlString)};
    }
}

