/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.pde.internal.ui.IPDEUIConstants;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdapterFactory;
import org.eclipse.pde.internal.ui.editor.schema.SchemaAdapterFactory;
import org.eclipse.pde.internal.ui.launcher.LaunchConfigurationListener;
import org.eclipse.pde.internal.ui.launcher.LaunchListener;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.view.PluginsViewAdapterFactory;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class PDEPlugin
extends AbstractUIPlugin
implements IPDEUIConstants {
    private static PDEPlugin inst;
    private ResourceBundle resourceBundle;
    private LaunchListener fLaunchListener;
    private BundleContext fBundleContext;
    private Hashtable counters;
    private FormColors fFormColors;
    private PDELabelProvider fLabelProvider;
    private ILaunchConfigurationListener fLaunchConfigurationListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    public PDEPlugin() {
        inst = this;
    }

    public URL getInstallURL() {
        try {
            return Platform.resolve((URL)PDEPlugin.getDefault().getBundle().getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.pde.internal.ui.pderesources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static IWorkbenchPage getActivePage() {
        return PDEPlugin.getDefault().internalGetActivePage();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = PDEPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PDEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static PDEPlugin getDefault() {
        return inst;
    }

    public Hashtable getDefaultNameCounters() {
        if (this.counters == null) {
            this.counters = new Hashtable();
        }
        return this.counters;
    }

    public static String getFormattedMessage(String key, String[] args) {
        String text = PDEPlugin.getResourceString(key);
        return MessageFormat.format(text, args);
    }

    public static String getFormattedMessage(String key, String arg) {
        String text = PDEPlugin.getResourceString(key);
        return MessageFormat.format(text, arg);
    }

    public static String getPluginId() {
        return PDEPlugin.getDefault().getBundle().getSymbolicName();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = PDEPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private IWorkbenchPage internalGetActivePage() {
        return this.getWorkbench().getActiveWorkbenchWindow().getActivePage();
    }

    public static void log(IStatus status) {
        ResourcesPlugin.getPlugin().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        PDEPlugin.log((IStatus)new Status(4, PDEPlugin.getPluginId(), 4, message, null));
    }

    public static void logException(Throwable e, final String title, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PDEPlugin.getPluginId(), 0, message, e);
        }
        ResourcesPlugin.getPlugin().getLog().log(status);
        Display display = SWTUtil.getStandardDisplay();
        final IStatus fstatus = status;
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)title, null, (IStatus)fstatus);
            }
        });
    }

    public static void logException(Throwable e) {
        PDEPlugin.logException(e, null, null);
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        Object status = null;
        status = e instanceof CoreException ? ((CoreException)e).getStatus() : new Status(4, PDEPlugin.getPluginId(), 0, e.getMessage(), e);
        PDEPlugin.log(status);
    }

    public FormColors getFormColors(Display display) {
        if (this.fFormColors == null) {
            this.fFormColors = new FormColors(display);
            this.fFormColors.markShared();
        }
        return this.fFormColors;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        IAdapterManager manager = Platform.getAdapterManager();
        SchemaAdapterFactory schemaFactory = new SchemaAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.ischema.ISchemaObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)schemaFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.pde.internal.core.ischema.ISchemaObjectReference");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)schemaFactory, (Class)clazz2);
        FeatureAdapterFactory featureAdapterFactory = new FeatureAdapterFactory();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.pde.internal.core.ifeature.IFeatureObject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)featureAdapterFactory, (Class)clazz3);
        PluginsViewAdapterFactory factory = new PluginsViewAdapterFactory();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.pde.internal.core.ModelEntry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)factory, (Class)clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.pde.internal.core.FileAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)factory, (Class)clazz5);
        this.fLaunchConfigurationListener = new LaunchConfigurationListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(this.fLaunchConfigurationListener);
    }

    public BundleContext getBundleContext() {
        return this.fBundleContext;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.fLaunchListener != null) {
            this.fLaunchListener.shutdown();
        }
        if (this.fFormColors != null) {
            this.fFormColors.dispose();
            this.fFormColors = null;
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        if (this.fLaunchConfigurationListener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(this.fLaunchConfigurationListener);
            this.fLaunchConfigurationListener = null;
        }
        super.stop(context);
    }

    public PDELabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new PDELabelProvider();
        }
        return this.fLabelProvider;
    }

    public LaunchListener getLaunchListener() {
        if (this.fLaunchListener == null) {
            this.fLaunchListener = new LaunchListener();
        }
        return this.fLaunchListener;
    }

    public static boolean isFullNameModeEnabled() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        return store.getString("Preferences.MainPage.showObjects").equals("useNames");
    }
}

