/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ISortableContentOutlinePage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.SourceOutlinePage;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.model.IDocumentRange;
import org.eclipse.pde.internal.ui.model.IEditingModel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;

public abstract class PDESourcePage
extends TextEditor
implements IFormPage,
IGotoMarker {
    private PDESourcePageChangedListener fEditorSelectionChangedListener;
    private PDEFormEditor editor;
    private Control control;
    private int index;
    private String id;
    private InputContext inputContext;
    private ISortableContentOutlinePage outlinePage;
    private ISelectionChangedListener outlineSelectionChangedListener;

    public PDESourcePage(PDEFormEditor editor, String id, String title) {
        this.id = id;
        this.initialize(editor);
        IPreferenceStore[] stores = new IPreferenceStore[]{PDEPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(stores));
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
    }

    public void initialize(FormEditor editor) {
        this.editor = (PDEFormEditor)editor;
    }

    public void dispose() {
        if (this.fEditorSelectionChangedListener != null) {
            this.fEditorSelectionChangedListener.uninstall(this.getSelectionProvider());
            this.fEditorSelectionChangedListener = null;
        }
        if (this.outlinePage != null) {
            this.outlinePage.dispose();
            this.outlinePage = null;
        }
        super.dispose();
    }

    protected void editorSaved() {
        super.editorSaved();
    }

    protected abstract ILabelProvider createOutlineLabelProvider();

    protected abstract ITreeContentProvider createOutlineContentProvider();

    protected abstract ViewerSorter createOutlineSorter();

    protected abstract void outlineSelectionChanged(SelectionChangedEvent var1);

    protected ViewerSorter createDefaultOutlineSorter() {
        return null;
    }

    protected ISortableContentOutlinePage createOutlinePage() {
        SourceOutlinePage sourceOutlinePage = new SourceOutlinePage((IEditingModel)this.getInputContext().getModel(), (IBaseLabelProvider)this.createOutlineLabelProvider(), (IContentProvider)this.createOutlineContentProvider(), this.createDefaultOutlineSorter(), this.createOutlineSorter());
        this.outlinePage = sourceOutlinePage;
        this.outlineSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PDESourcePage.this.outlineSelectionChanged(event);
            }
        };
        this.outlinePage.addSelectionChangedListener(this.outlineSelectionChangedListener);
        this.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)sourceOutlinePage);
        this.fEditorSelectionChangedListener = new PDESourcePageChangedListener();
        this.fEditorSelectionChangedListener.install(this.getSelectionProvider());
        return this.outlinePage;
    }

    public ISortableContentOutlinePage getContentOutline() {
        if (this.outlinePage == null) {
            this.outlinePage = this.createOutlinePage();
        }
        return this.outlinePage;
    }

    public FormEditor getEditor() {
        return this.editor;
    }

    public IManagedForm getManagedForm() {
        return null;
    }

    protected void firePropertyChange(int type) {
        if (type == 257) {
            this.editor.fireSaveNeeded(this.getEditorInput(), true);
        } else {
            super.firePropertyChange(type);
        }
    }

    public void setActive(boolean active) {
        this.inputContext.setSourceEditingMode(active);
    }

    public boolean canLeaveThePage() {
        return true;
    }

    public boolean isActive() {
        return ((Object)((Object)this)).equals(this.editor.getActivePageInstance());
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        Control[] children = parent.getChildren();
        this.control = children[children.length - 1];
        WorkbenchHelp.setHelp((Control)this.control, (String)"org.eclipse.pde.doc.user.manifest_source_page");
    }

    public Control getPartControl() {
        return this.control;
    }

    public String getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean isEditor() {
        return true;
    }

    public InputContext getInputContext() {
        return this.inputContext;
    }

    public void setInputContext(InputContext inputContext) {
        this.inputContext = inputContext;
        this.setDocumentProvider(inputContext.getDocumentProvider());
    }

    public boolean selectReveal(Object object) {
        if (object instanceof IMarker) {
            IDE.gotoMarker((IEditorPart)this, (IMarker)((IMarker)object));
            return true;
        }
        return false;
    }

    protected IDocumentRange getRangeElement(ITextSelection selection) {
        return null;
    }

    public void setHighlightRange(IDocumentRange node, boolean moveCursor) {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer == null) {
            return;
        }
        IDocument document = sourceViewer.getDocument();
        if (document == null) {
            return;
        }
        int offset = node.getOffset();
        int length = node.getLength();
        this.setHighlightRange(offset, length == -1 ? 1 : length, moveCursor);
    }

    private class PDESourcePageChangedListener
    implements ISelectionChangedListener {
        PDESourcePageChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (!selection.isEmpty() && selection instanceof ITextSelection) {
                IDocumentRange rangeElement = PDESourcePage.this.getRangeElement((ITextSelection)selection);
                if (rangeElement != null) {
                    PDESourcePage.this.setHighlightRange(rangeElement, false);
                } else {
                    PDESourcePage.this.resetHighlightRange();
                }
                if (PDEPlugin.getDefault().getPreferenceStore().getBoolean("ToggleLinkWithEditorAction.isChecked")) {
                    PDESourcePage.this.outlinePage.removeSelectionChangedListener(PDESourcePage.this.outlineSelectionChangedListener);
                    if (rangeElement != null) {
                        PDESourcePage.this.outlinePage.setSelection((ISelection)new StructuredSelection((Object)rangeElement));
                    } else {
                        PDESourcePage.this.outlinePage.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                    PDESourcePage.this.outlinePage.addSelectionChangedListener(PDESourcePage.this.outlineSelectionChangedListener);
                }
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }
    }
}

