/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;

public class SystemFileMarkerAnnotationModel
extends AbstractMarkerAnnotationModel {
    private IWorkspace fWorkspace;
    private IResource fResource;
    private IResourceChangeListener fResourceChangeListener = new ResourceChangeListener();
    private IResourceDeltaVisitor fResourceDeltaVisitor = new ResourceDeltaVisitor();
    private File file;

    public SystemFileMarkerAnnotationModel(File file) {
        this.fWorkspace = PDEPlugin.getWorkspace();
        this.fResource = this.fWorkspace.getRoot();
        this.file = file;
    }

    protected boolean isAcceptable(IMarker marker) {
        if (marker == null) {
            return false;
        }
        if (!this.fResource.equals((Object)marker.getResource())) {
            return false;
        }
        try {
            String path = (String)marker.getAttribute("org.eclipse.pde.ui.systemFilePath");
            if (path == null) {
                return false;
            }
            return new Path(path).equals((Object)new Path(this.file.getPath()));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void update(IMarkerDelta[] markerDeltas) {
        if (markerDeltas.length == 0) {
            return;
        }
        int i = 0;
        while (i < markerDeltas.length) {
            IMarkerDelta delta = markerDeltas[i];
            switch (delta.getKind()) {
                case 1: {
                    this.addMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 2: {
                    this.removeMarkerAnnotation(delta.getMarker());
                    break;
                }
                case 4: {
                    this.modifyMarkerAnnotation(delta.getMarker());
                }
            }
            ++i;
        }
        this.fireModelChanged();
    }

    protected void listenToMarkerChanges(boolean listen) {
        if (listen) {
            this.fWorkspace.addResourceChangeListener(this.fResourceChangeListener);
        } else {
            this.fWorkspace.removeResourceChangeListener(this.fResourceChangeListener);
        }
    }

    protected void deleteMarkers(final IMarker[] markers) throws CoreException {
        this.fWorkspace.run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int i = 0;
                while (i < markers.length) {
                    markers[i].delete();
                    ++i;
                }
            }
        }, null);
    }

    protected IMarker[] retrieveMarkers() throws CoreException {
        IMarker[] markers = this.fResource.findMarkers("org.eclipse.core.resources.marker", true, 0);
        if (markers.length == 0) {
            return markers;
        }
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            String path = (String)marker.getAttribute("org.eclipse.pde.ui.systemFilePath");
            if (path != null && new Path(path).equals((Object)new Path(this.file.getPath()))) {
                result.add(marker);
            }
            ++i;
        }
        return result.toArray(new IMarker[result.size()]);
    }

    protected IResource getResource() {
        return this.fResource;
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta delta = e.getDelta();
            try {
                if (delta != null) {
                    delta.accept(SystemFileMarkerAnnotationModel.this.fResourceDeltaVisitor);
                }
            }
            catch (CoreException x) {
                PDEPlugin.logException(x);
            }
        }
    }

    class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta != null && SystemFileMarkerAnnotationModel.this.fResource.equals((Object)delta.getResource())) {
                SystemFileMarkerAnnotationModel.this.update(delta.getMarkerDeltas());
                return false;
            }
            return true;
        }
    }
}

