/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.plugin.GeneralInfoSection;
import org.eclipse.pde.internal.ui.editor.plugin.PluginExportAction;
import org.eclipse.pde.internal.ui.launcher.RuntimeWorkbenchShortcut;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.help.WorkbenchHelp;

public class OverviewPage
extends PDEFormPage
implements IHyperlinkListener {
    public static final String PAGE_ID = "overview";
    private static final String contentText = PDEPlugin.getResourceString("OverviewPage.content");
    private static final String testingText = PDEPlugin.getResourceString("OverviewPage.testing");
    private static final String deployingText = PDEPlugin.getResourceString("OverviewPage.deploying");
    private static final String fcontentText = PDEPlugin.getResourceString("OverviewPage.fContent");
    private static final String ftestingText = PDEPlugin.getResourceString("OverviewPage.fTesting");
    private static final String fdeployingText = PDEPlugin.getResourceString("OverviewPage.fDeploying");
    private RuntimeWorkbenchShortcut fLaunchShortcut;
    private PluginExportAction fExportAction;

    public OverviewPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEPlugin.getResourceString("OverviewPage.tabName"));
    }

    protected String getHelpResource() {
        return PDEPlugin.getResourceString("OverviewPage.help.manifest");
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        form.setText(PDEPlugin.getResourceString("ManifestEditor.OverviewPage.title"));
        this.fillBody(managedForm, toolkit);
        managedForm.refresh();
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.bottomMargin = 10;
        layout.topMargin = 5;
        layout.leftMargin = 10;
        layout.rightMargin = 10;
        layout.numColumns = 2;
        layout.verticalSpacing = 20;
        layout.horizontalSpacing = 10;
        body.setLayout((Layout)layout);
        this.createGeneralInfoSection(managedForm, body, toolkit);
        this.createContentSection(managedForm, body, toolkit);
        this.createTestingSection(managedForm, body, toolkit);
        this.createDeployingSection(managedForm, body, toolkit);
    }

    private void createGeneralInfoSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        managedForm.addPart((IFormPart)new GeneralInfoSection(this, parent));
    }

    private void createContentSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        FormText text;
        Section section = this.createStaticSection(parent, toolkit);
        if (this.isFragment()) {
            section.setText(PDEPlugin.getResourceString("ManifestEditor.ContentSection.ftitle"));
            text = this.createClient(section, fcontentText, toolkit);
        } else {
            section.setText(PDEPlugin.getResourceString("ManifestEditor.ContentSection.title"));
            text = this.createClient(section, contentText, toolkit);
        }
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        text.setImage("page", lp.get(PDEPluginImages.DESC_PAGE_OBJ, 8));
    }

    private void createTestingSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(parent, toolkit);
        section.setText(PDEPlugin.getResourceString("ManifestEditor.TestingSection.title"));
        ImageHyperlink info = new ImageHyperlink((Composite)section, 0);
        toolkit.adapt((Control)info, true, true);
        Image image = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_HELP);
        info.setImage(image);
        info.setBackground(section.getTitleBarGradientBackground());
        info.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                WorkbenchHelp.displayHelpResource((String)PDEPlugin.getResourceString("OverviewPage.help.pdeRunning"));
            }
        });
        section.setTextClient((Control)info);
        FormText text = this.isFragment() ? this.createClient(section, ftestingText, toolkit) : this.createClient(section, testingText, toolkit);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        text.setImage("run", lp.get(PDEPluginImages.DESC_RUN_EXC));
        text.setImage("debug", lp.get(PDEPluginImages.DESC_DEBUG_EXC));
        text.setImage("workbench", lp.get(PDEPluginImages.DESC_WORKBENCH_LAUNCHER_WIZ));
    }

    private void createDeployingSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(parent, toolkit);
        section.setText(PDEPlugin.getResourceString("ManifestEditor.DeployingSection.title"));
        ImageHyperlink info = new ImageHyperlink((Composite)section, 0);
        toolkit.adapt((Control)info, true, true);
        Image image = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_HELP);
        info.setImage(image);
        info.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                WorkbenchHelp.displayHelpResource((String)PDEPlugin.getResourceString("OverviewPage.help.deploy"));
            }
        });
        info.setBackground(section.getTitleBarGradientBackground());
        section.setTextClient((Control)info);
        if (this.isFragment()) {
            this.createClient(section, fdeployingText, toolkit);
        } else {
            this.createClient(section, deployingText, toolkit);
        }
    }

    private Section createStaticSection(Composite parent, FormToolkit toolkit) {
        Section section = toolkit.createSection(parent, 256);
        section.clientVerticalSpacing = 4;
        return section;
    }

    private FormText createClient(Section section, String content, FormToolkit toolkit) {
        FormText text = toolkit.createFormText((Composite)section, true);
        try {
            text.setText(content, true, false);
        }
        catch (SWTException e) {
            text.setText(e.getMessage(), false, false);
        }
        section.setClient((Control)text);
        section.setLayoutData((Object)new TableWrapData(256));
        text.addHyperlinkListener((IHyperlinkListener)this);
        return text;
    }

    private boolean isFragment() {
        IPluginModelBase model = (IPluginModelBase)this.getPDEEditor().getContextManager().getAggregateModel();
        return model.isFragmentModel();
    }

    public void linkActivated(HyperlinkEvent e) {
        String href = (String)e.getHref();
        if (href.equals("dependencies")) {
            this.getEditor().setActivePage("dependencies");
        } else if (href.equals("runtime")) {
            this.getEditor().setActivePage("runtime");
        } else if (href.equals("extensions")) {
            this.getEditor().setActivePage("extensions");
        } else if (href.equals("ex-points")) {
            this.getEditor().setActivePage("ex-points");
        } else if (href.equals("build")) {
            this.getEditor().setActivePage("build");
        } else if (href.equals("action.run")) {
            this.getEditor().doSave(null);
            this.getLaunchShortcut().run((IPluginModelBase)this.getModel());
        } else if (href.equals("action.debug")) {
            this.getEditor().doSave(null);
            this.getLaunchShortcut().debug((IPluginModelBase)this.getModel());
        } else if (href.equals("export")) {
            this.getExportAction().run();
        }
    }

    public void linkEntered(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(e.getLabel());
    }

    public void linkExited(HyperlinkEvent e) {
        IStatusLineManager mng = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        mng.setMessage(null);
    }

    private RuntimeWorkbenchShortcut getLaunchShortcut() {
        if (this.fLaunchShortcut == null) {
            this.fLaunchShortcut = new RuntimeWorkbenchShortcut();
        }
        return this.fLaunchShortcut;
    }

    private PluginExportAction getExportAction() {
        if (this.fExportAction == null) {
            this.fExportAction = new PluginExportAction((PDEFormEditor)this.getEditor());
        }
        return this.fExportAction;
    }
}

