/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaCompositor;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaElementReference;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;

public class NewCompositorAction
extends Action {
    public static final String KEY_TOOLTIP = "SchemaEditor.NewCompositor.tooltip";
    private ISchemaElement source;
    private Object object;
    private int kind;

    public NewCompositorAction(ISchemaElement source, Object object, int kind) {
        this.source = source;
        this.object = object;
        this.kind = kind;
        this.setText("&" + ISchemaCompositor.kindTable[kind]);
        this.setToolTipText(PDEPlugin.getFormattedMessage(KEY_TOOLTIP, ISchemaCompositor.kindTable[kind]));
        ImageDescriptor desc = null;
        switch (kind) {
            case 0: {
                desc = PDEPluginImages.DESC_ALL_SC_OBJ;
                break;
            }
            case 3: {
                desc = PDEPluginImages.DESC_GROUP_SC_OBJ;
                break;
            }
            case 2: {
                desc = PDEPluginImages.DESC_SEQ_SC_OBJ;
                break;
            }
            case 1: {
                desc = PDEPluginImages.DESC_CHOICE_SC_OBJ;
            }
        }
        this.setImageDescriptor(desc);
        this.setEnabled(source.getSchema().isEditable());
    }

    public void run() {
        SchemaCompositor compositor = new SchemaCompositor((ISchemaObject)this.source, this.kind);
        if (this.object == null) {
            SchemaComplexType type = null;
            SchemaElement element = (SchemaElement)this.source;
            if (element.getType() instanceof SchemaComplexType) {
                type = (SchemaComplexType)element.getType();
                type.setCompositor((ISchemaCompositor)compositor);
            } else {
                type = new SchemaComplexType(this.source.getSchema());
                type.setCompositor((ISchemaCompositor)compositor);
                ((SchemaElement)this.source).setType((ISchemaType)type);
            }
        } else if (this.object instanceof SchemaCompositor) {
            ((SchemaCompositor)this.object).addChild((ISchemaObject)compositor);
        } else if (this.object instanceof SchemaElementReference) {
            ISchemaCompositor comp = ((SchemaElementReference)this.object).getCompositor();
            ((SchemaCompositor)comp).addChild((ISchemaObject)compositor);
        }
    }
}

