/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ModelEntry;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModelBase;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.launcher.AbstractLauncherTab;
import org.eclipse.pde.internal.ui.launcher.ILauncherSettings;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;
import org.eclipse.pde.internal.ui.launcher.PluginStatusDialog;
import org.eclipse.pde.internal.ui.launcher.PluginValidationOperation;
import org.eclipse.pde.internal.ui.util.PersistablePluginObject;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class AdvancedLauncherTab
extends AbstractLauncherTab
implements ILaunchConfigurationTab,
ILauncherSettings {
    private Button fUseDefaultRadio;
    private Button fUseFeaturesRadio;
    private Button fUseListRadio;
    private Button fAddRequiredButton;
    private CheckboxTreeViewer fPluginTreeViewer;
    private NamedElement fWorkspacePlugins;
    private NamedElement fExternalPlugins;
    private IPluginModelBase[] fExternalModels;
    private IPluginModelBase[] fWorkspaceModels;
    private Button fDefaultsButton;
    private int fNumExternalChecked = 0;
    private int fNumWorkspaceChecked = 0;
    private Image fImage;
    private boolean fShowFeatures = true;
    private Button fSelectAllButton;
    private Button fDeselectButton;
    private Button fWorkingSetButton;
    private Button fIncludeFragmentsButton;
    private Button fAddWorkspaceButton;
    private String fProductID;
    private String fApplicationID;

    public AdvancedLauncherTab() {
        this(true);
    }

    public AdvancedLauncherTab(boolean showFeatures) {
        this.fShowFeatures = showFeatures;
        PDEPlugin.getDefault().getLabelProvider().connect(this);
        this.fImage = PDEPluginImages.DESC_REQ_PLUGINS_OBJ.createImage();
        this.fExternalModels = PDECore.getDefault().getExternalModelManager().getAllModels();
        this.fWorkspaceModels = PDECore.getDefault().getWorkspaceModelManager().getAllModels();
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect(this);
        this.fImage.dispose();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.fUseDefaultRadio = new Button(composite, 16);
        this.fUseDefaultRadio.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.useDefault"));
        if (this.fShowFeatures) {
            this.fUseFeaturesRadio = new Button(composite, 16);
            this.fUseFeaturesRadio.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.useFeatures"));
        }
        this.fUseListRadio = new Button(composite, 16);
        this.fUseListRadio.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.useList"));
        this.createPluginList(composite);
        this.createSeparator(composite, 1);
        Button button = new Button(composite, 8);
        button.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.validatePlugins"));
        button.setLayoutData((Object)new GridData(128));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.handleValidatePlugins();
            }
        });
        SWTUtil.setButtonDimensionHint(button);
        this.hookListeners();
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        WorkbenchHelp.setHelp((Control)composite, (String)"org.eclipse.pde.doc.user.launcher_advanced");
    }

    private void hookListeners() {
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.useDefaultChanged();
            }
        };
        this.fUseDefaultRadio.addSelectionListener((SelectionListener)adapter);
        if (this.fShowFeatures) {
            this.fUseFeaturesRadio.addSelectionListener((SelectionListener)adapter);
        }
        this.fDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.computeInitialCheckState();
                AdvancedLauncherTab.this.updateStatus();
            }
        });
        this.fWorkingSetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.handleWorkingSets();
                AdvancedLauncherTab.this.updateStatus();
            }
        });
        this.fAddRequiredButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)AdvancedLauncherTab.this.getControl().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        AdvancedLauncherTab.access$9(5.access$0(this.this$1));
                        AdvancedLauncherTab.access$7(5.access$0(this.this$1));
                    }
                });
            }

            static /* synthetic */ AdvancedLauncherTab access$0(5 var0) {
                return var0.AdvancedLauncherTab.this;
            }
        });
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.toggleGroups(true);
                AdvancedLauncherTab.this.updateStatus();
            }
        });
        this.fDeselectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.toggleGroups(false);
                AdvancedLauncherTab.this.updateStatus();
            }
        });
        this.fIncludeFragmentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.updateStatus();
            }
        });
        this.fAddWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedLauncherTab.this.updateStatus();
            }
        });
    }

    private void handleWorkingSets() {
        IWorkingSetManager workingSetManager = PlatformUI.getWorkbench().getWorkingSetManager();
        IWorkingSetSelectionDialog dialog = workingSetManager.createWorkingSetSelectionDialog(this.getControl().getShell(), true);
        if (dialog.open() == 0) {
            String[] ids = this.getPluginIDs(dialog.getSelection());
            PluginModelManager manager = PDECore.getDefault().getModelManager();
            int i = 0;
            while (i < ids.length) {
                IPluginModelBase model;
                ModelEntry entry = manager.findEntry(ids[i]);
                if (entry != null && !this.fPluginTreeViewer.getChecked((Object)(model = entry.getActiveModel()))) {
                    this.fPluginTreeViewer.setChecked((Object)model, true);
                    if (model.getUnderlyingResource() == null) {
                        ++this.fNumExternalChecked;
                    } else {
                        ++this.fNumWorkspaceChecked;
                    }
                }
                ++i;
            }
            this.adjustGroupState();
        }
    }

    private String[] getPluginIDs(IWorkingSet[] workingSets) {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < workingSets.length) {
            IAdaptable[] elements = workingSets[i].getElements();
            int j = 0;
            while (j < elements.length) {
                IAdaptable element = elements[j];
                if (element instanceof PersistablePluginObject) {
                    set.add(((PersistablePluginObject)element).getPluginID());
                } else {
                    IPluginModelBase model;
                    if (element instanceof IJavaProject) {
                        element = ((IJavaProject)element).getProject();
                    }
                    if (element instanceof IProject && (model = PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModel((IProject)element)) != null) {
                        set.add(model.getPluginBase().getId());
                    }
                }
                ++j;
            }
            ++i;
        }
        return set.toArray(new String[set.size()]);
    }

    protected void toggleGroups(boolean select) {
        this.handleGroupStateChanged(this.fWorkspacePlugins, select);
        this.handleGroupStateChanged(this.fExternalPlugins, select);
    }

    private void useDefaultChanged() {
        this.adjustCustomControlEnableState(this.fUseListRadio.getSelection());
        this.updateStatus();
    }

    private void adjustCustomControlEnableState(boolean enable) {
        this.fPluginTreeViewer.getTree().setEnabled(enable);
        this.fAddRequiredButton.setEnabled(enable);
        this.fDefaultsButton.setEnabled(enable);
        this.fWorkingSetButton.setEnabled(enable);
        this.fSelectAllButton.setEnabled(enable);
        this.fDeselectButton.setEnabled(enable);
        this.fIncludeFragmentsButton.setEnabled(enable);
        this.fAddWorkspaceButton.setEnabled(enable);
    }

    private void createPluginList(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalIndent = 30;
        composite.setLayoutData((Object)gd);
        this.createPluginViewer(composite);
        this.createButtonContainer(composite);
        this.fIncludeFragmentsButton = new Button(composite, 32);
        this.fIncludeFragmentsButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.includeFragments"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fIncludeFragmentsButton.setLayoutData((Object)gd);
        this.fAddWorkspaceButton = new Button(composite, 32);
        this.fAddWorkspaceButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.addNew"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fAddWorkspaceButton.setLayoutData((Object)gd);
    }

    private void computeSubset() {
        Object[] checked = this.fPluginTreeViewer.getCheckedElements();
        TreeMap map = new TreeMap();
        int i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)checked[i];
                this.addPluginAndDependencies(model, map);
            }
            ++i;
        }
        if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            this.addPluginAndDependencies(this.findPlugin("org.eclipse.core.runtime"), map);
        }
        checked = map.values().toArray();
        this.fPluginTreeViewer.setCheckedElements(map.values().toArray());
        this.fNumExternalChecked = 0;
        this.fNumWorkspaceChecked = 0;
        i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof WorkspacePluginModelBase) {
                ++this.fNumWorkspaceChecked;
            } else {
                ++this.fNumExternalChecked;
            }
            ++i;
        }
        this.adjustGroupState();
    }

    private void addPluginAndDependencies(IPluginModelBase model, TreeMap map) {
        if (model == null) {
            return;
        }
        String id = model.getPluginBase().getId();
        if (map.containsKey(id)) {
            return;
        }
        map.put(id, model);
        if (model instanceof IFragmentModel) {
            IPluginModelBase parent = this.findPlugin(((IFragmentModel)model).getFragment().getPluginId());
            this.addPluginAndDependencies(parent, map);
        } else {
            boolean addFragments = this.fIncludeFragmentsButton.getSelection();
            IPluginLibrary[] libs = model.getPluginBase().getLibraries();
            int i = 0;
            while (i < libs.length) {
                if (ClasspathUtilCore.containsVariables((String)libs[i].getName())) {
                    addFragments = true;
                    break;
                }
                ++i;
            }
            if (addFragments) {
                IFragmentModel[] fragments = this.findFragments(model.getPluginBase());
                int i2 = 0;
                while (i2 < fragments.length) {
                    this.addPluginAndDependencies((IPluginModelBase)fragments[i2], map);
                    ++i2;
                }
            }
        }
        IPluginImport[] imports = model.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            this.addPluginAndDependencies(this.findPlugin(imports[i].getId()), map);
            ++i;
        }
    }

    private IPluginModelBase findPlugin(String id) {
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        ModelEntry entry = manager.findEntry(id);
        if (entry != null) {
            IPluginModelBase model = entry.getActiveModel();
            if (this.fPluginTreeViewer.getChecked((Object)model)) {
                return model;
            }
            model = entry.getExternalModel();
            if (model != null && this.fPluginTreeViewer.getChecked((Object)model)) {
                return model;
            }
            return entry.getActiveModel();
        }
        return null;
    }

    private IFragmentModel[] findFragments(IPluginBase plugin) {
        ModelEntry[] entries = PDECore.getDefault().getModelManager().getEntries();
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        int i = 0;
        while (i < entries.length) {
            String id;
            ModelEntry entry = entries[i];
            IPluginModelBase model = entry.getActiveModel();
            if (model instanceof IFragmentModel && (id = ((IFragmentModel)model).getFragment().getPluginId()).equals(plugin.getId())) {
                if (this.fPluginTreeViewer.getChecked((Object)model)) {
                    result.add(model);
                } else {
                    model = entry.getExternalModel();
                    if (model != null && this.fPluginTreeViewer.getChecked((Object)model)) {
                        result.add(model);
                    } else {
                        result.add(entry.getActiveModel());
                    }
                }
            }
            ++i;
        }
        return result.toArray(new IFragmentModel[result.size()]);
    }

    private void adjustGroupState() {
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.fWorkspaceModels.length);
    }

    private void createPluginViewer(Composite composite) {
        this.fPluginTreeViewer = new CheckboxTreeViewer(composite, 2048);
        this.fPluginTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.fPluginTreeViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fPluginTreeViewer.setAutoExpandLevel(2);
        this.fPluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IPluginModelBase) {
                    AdvancedLauncherTab.this.handleCheckStateChanged((IPluginModelBase)element, event.getChecked());
                } else {
                    AdvancedLauncherTab.this.handleGroupStateChanged(element, event.getChecked());
                }
                AdvancedLauncherTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fPluginTreeViewer.setSorter((ViewerSorter)new ListUtil.PluginSorter(){

            public int category(Object obj) {
                if (obj == AdvancedLauncherTab.this.fWorkspacePlugins) {
                    return -1;
                }
                return 0;
            }
        });
        this.fPluginTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
        Image pluginsImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
        this.fWorkspacePlugins = new NamedElement(PDEPlugin.getResourceString("AdvancedLauncherTab.workspacePlugins"), pluginsImage);
        this.fExternalPlugins = new NamedElement(PDEPlugin.getResourceString("AdvancedLauncherTab.externalPlugins"), pluginsImage);
    }

    private void createButtonContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1040));
        this.fSelectAllButton = new Button(composite, 8);
        this.fSelectAllButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.selectAll"));
        this.fSelectAllButton.setLayoutData((Object)new GridData(770));
        SWTUtil.setButtonDimensionHint(this.fSelectAllButton);
        this.fDeselectButton = new Button(composite, 8);
        this.fDeselectButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.deselectAll"));
        this.fDeselectButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fDeselectButton);
        this.fWorkingSetButton = new Button(composite, 8);
        this.fWorkingSetButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.workingSet"));
        this.fWorkingSetButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fWorkingSetButton);
        this.fAddRequiredButton = new Button(composite, 8);
        this.fAddRequiredButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.subset"));
        this.fAddRequiredButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fAddRequiredButton);
        this.fDefaultsButton = new Button(composite, 8);
        this.fDefaultsButton.setText(PDEPlugin.getResourceString("AdvancedLauncherTab.defaults"));
        this.fDefaultsButton.setLayoutData((Object)new GridData(768));
        SWTUtil.setButtonDimensionHint(this.fDefaultsButton);
    }

    private void initWorkspacePluginsState(ILaunchConfiguration config) throws CoreException {
        boolean automaticAdd = config.getAttribute("automaticAdd", true);
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, automaticAdd);
        this.fNumWorkspaceChecked = automaticAdd ? this.fWorkspaceModels.length : 0;
        TreeSet ids = LauncherUtils.parseWorkspacePluginIds(config);
        int i = 0;
        while (i < this.fWorkspaceModels.length) {
            String id = this.fWorkspaceModels[i].getPluginBase().getId();
            if (id != null) {
                if (automaticAdd && ids.contains(id)) {
                    if (this.fPluginTreeViewer.setChecked((Object)this.fWorkspaceModels[i], false)) {
                        --this.fNumWorkspaceChecked;
                    }
                } else if (!automaticAdd && ids.contains(id) && this.fPluginTreeViewer.setChecked((Object)this.fWorkspaceModels[i], true)) {
                    ++this.fNumWorkspaceChecked;
                }
            }
            ++i;
        }
        this.fPluginTreeViewer.setChecked((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fWorkspacePlugins, this.fNumWorkspaceChecked > 0 && this.fNumWorkspaceChecked < this.fWorkspaceModels.length);
    }

    private void initExternalPluginsState(ILaunchConfiguration config) throws CoreException {
        this.fNumExternalChecked = 0;
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fExternalPlugins, false);
        TreeSet selected = LauncherUtils.parseExternalPluginIds(config);
        int i = 0;
        while (i < this.fExternalModels.length) {
            if (selected.contains(this.fExternalModels[i].getPluginBase().getId()) && this.fPluginTreeViewer.setChecked((Object)this.fExternalModels[i], true)) {
                ++this.fNumExternalChecked;
            }
            ++i;
        }
        this.fPluginTreeViewer.setChecked((Object)this.fExternalPlugins, this.fNumExternalChecked > 0);
        this.fPluginTreeViewer.setGrayed((Object)this.fExternalPlugins, this.fNumExternalChecked > 0 && this.fNumExternalChecked < this.fExternalModels.length);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fUseDefaultRadio.setSelection(config.getAttribute("default", true));
            if (this.fShowFeatures) {
                this.fUseFeaturesRadio.setSelection(config.getAttribute("usefeatures", false));
                this.fUseListRadio.setSelection(!this.fUseDefaultRadio.getSelection() && !this.fUseFeaturesRadio.getSelection());
            } else {
                this.fUseListRadio.setSelection(!this.fUseDefaultRadio.getSelection());
            }
            this.fIncludeFragmentsButton.setSelection(config.getAttribute("includeFragments", false));
            this.fAddWorkspaceButton.setSelection(config.getAttribute("automaticAdd", true));
            if (this.fPluginTreeViewer.getInput() == null) {
                this.fPluginTreeViewer.setUseHashlookup(true);
                this.fPluginTreeViewer.setInput((Object)PDEPlugin.getDefault());
                this.fPluginTreeViewer.reveal((Object)this.fWorkspacePlugins);
            }
            if (this.fUseDefaultRadio.getSelection()) {
                this.computeInitialCheckState();
            } else if (this.fUseListRadio.getSelection()) {
                this.initWorkspacePluginsState(config);
                this.initExternalPluginsState(config);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.adjustCustomControlEnableState(this.fUseListRadio.getSelection());
        this.updateStatus();
    }

    private void computeInitialCheckState() {
        IPluginModelBase model;
        TreeSet<String> wtable = new TreeSet<String>();
        this.fNumWorkspaceChecked = 0;
        this.fNumExternalChecked = 0;
        int i = 0;
        while (i < this.fWorkspaceModels.length) {
            model = this.fWorkspaceModels[i];
            ++this.fNumWorkspaceChecked;
            String id = model.getPluginBase().getId();
            if (id != null) {
                wtable.add(model.getPluginBase().getId());
            }
            ++i;
        }
        this.fPluginTreeViewer.setSubtreeChecked((Object)this.fWorkspacePlugins, true);
        this.fNumExternalChecked = 0;
        i = 0;
        while (i < this.fExternalModels.length) {
            model = this.fExternalModels[i];
            boolean masked = wtable.contains(model.getPluginBase().getId());
            if (!masked && model.isEnabled()) {
                this.fPluginTreeViewer.setChecked((Object)model, true);
                ++this.fNumExternalChecked;
            }
            ++i;
        }
        this.adjustGroupState();
    }

    private void handleCheckStateChanged(IPluginModelBase model, boolean checked) {
        if (model.getUnderlyingResource() == null) {
            this.fNumExternalChecked = checked ? ++this.fNumExternalChecked : --this.fNumExternalChecked;
        } else {
            this.fNumWorkspaceChecked = checked ? ++this.fNumWorkspaceChecked : --this.fNumWorkspaceChecked;
        }
        this.adjustGroupState();
    }

    private void handleGroupStateChanged(Object group, boolean checked) {
        this.fPluginTreeViewer.setSubtreeChecked(group, checked);
        this.fPluginTreeViewer.setGrayed(group, false);
        if (group == this.fWorkspacePlugins) {
            this.fNumWorkspaceChecked = checked ? this.fWorkspaceModels.length : 0;
        } else if (group == this.fExternalPlugins) {
            this.fNumExternalChecked = checked ? this.fExternalModels.length : 0;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleValidatePlugins() {
        block7: {
            PluginValidationOperation op = new PluginValidationOperation(this.getPluginsToValidate(), this.fProductID, this.fApplicationID);
            try {
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (op.hasErrors()) {
                    new PluginStatusDialog(this.getControl().getShell(), op).open();
                    throw throwable;
                }
                MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)PDEPlugin.getResourceString("AdvancedLauncherTab.pluginValidation"), (String)PDEPlugin.getResourceString("AdvancedLauncherTab.noProblems"));
                throw throwable;
            }
            {
                Object var2_4 = null;
                if (!op.hasErrors()) break block7;
            }
            new PluginStatusDialog(this.getControl().getShell(), op).open();
            return;
        }
        MessageDialog.openInformation((Shell)this.getControl().getShell(), (String)PDEPlugin.getResourceString("AdvancedLauncherTab.pluginValidation"), (String)PDEPlugin.getResourceString("AdvancedLauncherTab.noProblems"));
    }

    private IPluginModelBase[] getPluginsToValidate() {
        if (!this.fUseListRadio.getSelection()) {
            return PDECore.getDefault().getModelManager().getPlugins();
        }
        HashMap<String, IPluginModelBase> map = new HashMap<String, IPluginModelBase>();
        Object[] objects = this.fPluginTreeViewer.getCheckedElements();
        int i = 0;
        while (i < objects.length) {
            IPluginModelBase model;
            String id;
            if (objects[i] instanceof IPluginModelBase && (id = (model = (IPluginModelBase)objects[i]).getPluginBase().getId()) != null && (!map.containsKey(id) || model.getUnderlyingResource() != null)) {
                map.put(id, model);
            }
            ++i;
        }
        return map.values().toArray(new IPluginModelBase[map.size()]);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        if (this.fShowFeatures) {
            config.setAttribute("default", true);
            config.setAttribute("usefeatures", false);
        } else {
            config.setAttribute("default", true);
        }
        config.setAttribute("includeFragments", false);
        config.setAttribute("automaticAdd", true);
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("default", this.fUseDefaultRadio.getSelection());
        if (this.fShowFeatures) {
            config.setAttribute("usefeatures", this.fUseFeaturesRadio.getSelection());
        }
        config.setAttribute("includeFragments", this.fIncludeFragmentsButton.getSelection());
        config.setAttribute("automaticAdd", this.fAddWorkspaceButton.getSelection());
        if (this.fUseListRadio.getSelection()) {
            StringBuffer wbuf = new StringBuffer();
            int i = 0;
            while (i < this.fWorkspaceModels.length) {
                IPluginModelBase model = this.fWorkspaceModels[i];
                if (this.fPluginTreeViewer.getChecked((Object)model) != this.fAddWorkspaceButton.getSelection()) {
                    wbuf.append(String.valueOf(model.getPluginBase().getId()) + File.pathSeparatorChar);
                }
                ++i;
            }
            config.setAttribute("wsproject", wbuf.toString());
            StringBuffer exbuf = new StringBuffer();
            Object[] checked = this.fPluginTreeViewer.getCheckedElements();
            int i2 = 0;
            while (i2 < checked.length) {
                if (checked[i2] instanceof ExternalPluginModelBase) {
                    IPluginModelBase model = (IPluginModelBase)checked[i2];
                    exbuf.append(String.valueOf(model.getPluginBase().getId()) + File.pathSeparatorChar);
                }
                ++i2;
            }
            config.setAttribute("extplugins", exbuf.toString());
        } else {
            config.setAttribute("wsproject", null);
            config.setAttribute("extplugins", null);
        }
    }

    private void updateStatus() {
        this.updateStatus(this.validate());
    }

    private IStatus validate() {
        if (this.fShowFeatures && this.fUseFeaturesRadio.getSelection()) {
            IPath workspacePath = PDEPlugin.getWorkspace().getRoot().getLocation();
            IPath featurePath = workspacePath.removeLastSegments(1).append("features");
            if (!workspacePath.lastSegment().equalsIgnoreCase("plugins") || !featurePath.toFile().exists()) {
                return AbstractLauncherTab.createStatus(4, PDEPlugin.getResourceString("AdvancedLauncherTab.error.featureSetup"));
            }
        }
        return AbstractLauncherTab.createStatus(0, "");
    }

    public String getName() {
        return PDEPlugin.getResourceString("AdvancedLauncherTab.name");
    }

    public Image getImage() {
        return this.fImage;
    }

    public void activated(ILaunchConfigurationWorkingCopy config) {
        try {
            if (config.getAttribute("useProduct", false)) {
                this.fProductID = config.getAttribute("product", null);
                this.fApplicationID = null;
            } else {
                this.fApplicationID = this.fUseFeaturesRadio != null ? config.getAttribute("application", LauncherUtils.getDefaultApplicationName()) : config.getAttribute("testApplication", LauncherUtils.getDefaultApplicationName());
                this.fProductID = null;
            }
        }
        catch (CoreException coreException) {}
    }

    static /* synthetic */ void access$9(AdvancedLauncherTab advancedLauncherTab) {
        advancedLauncherTab.computeSubset();
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModelBase);
        }

        public Object[] getChildren(Object parent) {
            if (parent == AdvancedLauncherTab.this.fExternalPlugins) {
                return AdvancedLauncherTab.this.fExternalModels;
            }
            if (parent == AdvancedLauncherTab.this.fWorkspacePlugins) {
                return AdvancedLauncherTab.this.fWorkspaceModels;
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getElements(Object input) {
            return new Object[]{AdvancedLauncherTab.this.fWorkspacePlugins, AdvancedLauncherTab.this.fExternalPlugins};
        }
    }
}

