/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.internal.PDE;
import org.eclipse.pde.internal.builders.CompilerFlags;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class CompilersConfigurationBlock {
    private Set fBuilders = new HashSet();
    private Set fChangedControls = new HashSet();
    private Composite fFeaturePage;
    private List fFlagControls;
    private Composite fPluginPage;
    private Composite fSchemaPage;
    private Shell fShell;
    private IProject project;

    public CompilersConfigurationBlock(IProject project) {
        this.project = project;
    }

    private void addChangedConrol(Control control) {
        String flagId = (String)control.getData();
        boolean doAdd = false;
        if (control instanceof Combo) {
            int oldIndex;
            int newIndex = ((Combo)control).getSelectionIndex();
            doAdd = newIndex != (oldIndex = CompilerFlags.getFlag((IProject)this.project, (String)flagId));
        } else if (control instanceof Button) {
            boolean newValue = ((Button)control).getSelection();
            boolean oldValue = CompilerFlags.getBoolean((IProject)this.project, (String)flagId);
            doAdd = oldValue != newValue;
        } else if (control instanceof Text) {
            String oldValue;
            String newValue = ((Text)control).getText();
            boolean bl = doAdd = !newValue.equals(oldValue = CompilerFlags.getString((IProject)this.project, (String)flagId));
        }
        if (doAdd) {
            this.fChangedControls.add(control);
        } else if (this.fChangedControls.contains(control)) {
            this.fChangedControls.remove(control);
        }
    }

    public Control createContents(Composite parent) {
        this.setShell(parent.getShell());
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        this.fFlagControls = new ArrayList();
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompilersConfigurationBlock.this.addChangedConrol((Control)e.widget);
            }
        };
        ModifyListener mlistener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CompilersConfigurationBlock.this.addChangedConrol((Control)e.widget);
            }
        };
        String[] choices = new String[]{PDEPlugin.getResourceString("CompilersConfigurationBlock.error"), PDEPlugin.getResourceString("CompilersConfigurationBlock.warning"), PDEPlugin.getResourceString("CompilersConfigurationBlock.ignore")};
        if (this.project != null) {
            try {
                if (this.project.hasNature("org.eclipse.pde.PluginNature")) {
                    this.fPluginPage = this.createPage(container, PDEPlugin.getResourceString("CompilersConfigurationBlock.plugins"), 0, choices);
                }
            }
            catch (CoreException coreException) {}
        } else {
            TabFolder folder = new TabFolder(container, 0);
            GridData gd = new GridData(1808);
            folder.setLayoutData((Object)gd);
            this.fPluginPage = this.createPage(folder, PDEPlugin.getResourceString("CompilersConfigurationBlock.plugins"), 0, choices);
            this.fSchemaPage = this.createPage(folder, PDEPlugin.getResourceString("CompilersConfigurationBlock.schemas"), 1, choices);
            this.fFeaturePage = this.createPage(folder, PDEPlugin.getResourceString("CompilersConfigurationBlock.features"), 2, choices);
        }
        int i = 0;
        while (i < this.fFlagControls.size()) {
            Control control = (Control)this.fFlagControls.get(i);
            if (control instanceof Combo) {
                ((Combo)control).addSelectionListener((SelectionListener)listener);
            } else if (control instanceof Button) {
                ((Button)control).addSelectionListener((SelectionListener)listener);
            } else if (control instanceof Text) {
                ((Text)control).addModifyListener(mlistener);
            }
            ++i;
        }
        Dialog.applyDialogFont((Control)parent);
        return container;
    }

    private Control createFlag(Composite page, String flagId, String[] choices) {
        Combo control = null;
        if (CompilerFlags.getFlagType((String)flagId) == 0) {
            Label label = new Label(page, 0);
            label.setText(PDEPlugin.getResourceString(flagId));
            Combo combo = new Combo(page, 8);
            combo.setItems(choices);
            combo.select(CompilerFlags.getFlag((IProject)this.project, (String)flagId));
            control = combo;
        } else if (CompilerFlags.getFlagType((String)flagId) == 1) {
            Button button = new Button(page, 32);
            button.setText(PDEPlugin.getResourceString(flagId));
            button.setSelection(CompilerFlags.getBoolean((IProject)this.project, (String)flagId));
            GridData gd = new GridData();
            gd.horizontalSpan = 2;
            button.setLayoutData((Object)gd);
            control = button;
        } else if (CompilerFlags.getFlagType((String)flagId) == 2) {
            Label label = new Label(page, 0);
            label.setText(PDEPlugin.getResourceString(flagId));
            Text text = new Text(page, 2052);
            text.setText(CompilerFlags.getString((IProject)this.project, (String)flagId));
            GridData gd = new GridData(768);
            gd.widthHint = 50;
            text.setLayoutData((Object)gd);
            new Label(page, 0).setLayoutData((Object)new GridData());
            GridData sgd = new GridData();
            Label slabel = new Label(page, 0);
            slabel.setText(PDEPlugin.getResourceString("CompilersConfigurationBlock.label"));
            sgd.horizontalSpan = 2;
            slabel.setLayoutData((Object)sgd);
            control = text;
        }
        control.setData((Object)flagId);
        return control;
    }

    private Composite createPage(Composite parent, String name, int index, String[] choices) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        String textKey = index == 1 ? "CompilersConfigurationBlock.altlabel" : "CompilersConfigurationBlock.label";
        group.setText(PDEPlugin.getResourceString(textKey));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)gd);
        String[] flagIds = CompilerFlags.getFlags((int)index);
        int i = 0;
        while (i < flagIds.length) {
            Control control = this.createFlag((Composite)group, flagIds[i], choices);
            this.fFlagControls.add(control);
            ++i;
        }
        return group;
    }

    private Composite createPage(TabFolder folder, String name, int index, String[] choices) {
        Composite page = new Composite((Composite)folder, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        page.setLayout((Layout)layout);
        TabItem tab = new TabItem(folder, 0);
        tab.setText(name);
        tab.setControl((Control)page);
        Label label = new Label(page, 0);
        String textKey = index == 1 ? "CompilersConfigurationBlock.altlabel" : "CompilersConfigurationBlock.label";
        label.setText(PDEPlugin.getResourceString(textKey));
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        String[] flagIds = CompilerFlags.getFlags((int)index);
        int i = 0;
        while (i < flagIds.length) {
            Control control = this.createFlag(page, flagIds[i], choices);
            this.fFlagControls.add(control);
            ++i;
        }
        return page;
    }

    private void doFullBuild() {
        Job buildJob = new Job(PDEPlugin.getResourceString("CompilersConfigurationBlock.building")){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    try {
                        IProject[] projects = null;
                        projects = CompilersConfigurationBlock.this.project == null ? PDE.getWorkspace().getRoot().getProjects() : new IProject[]{CompilersConfigurationBlock.this.project};
                        monitor.beginTask("", projects.length * 2);
                        int i = 0;
                        while (i < projects.length) {
                            IProject projectToBuild = projects[i];
                            if (projectToBuild.isOpen()) {
                                if (projectToBuild.hasNature("org.eclipse.pde.PluginNature")) {
                                    if (CompilersConfigurationBlock.this.fBuilders.contains("org.eclipse.pde.ManifestBuilder")) {
                                        projectToBuild.build(6, "org.eclipse.pde.ManifestBuilder", null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else {
                                        monitor.worked(1);
                                    }
                                    if (CompilersConfigurationBlock.this.fBuilders.contains("org.eclipse.pde.SchemaBuilder")) {
                                        projectToBuild.build(6, "org.eclipse.pde.SchemaBuilder", null, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else {
                                        monitor.worked(1);
                                    }
                                } else if (projectToBuild.hasNature("org.eclipse.pde.FeatureNature")) {
                                    if (CompilersConfigurationBlock.this.fBuilders.contains("org.eclipse.pde.FeatureBuilder")) {
                                        projectToBuild.build(6, "org.eclipse.pde.FeatureBuilder", null, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                                    }
                                } else {
                                    monitor.worked(2);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (CoreException e) {
                        IStatus iStatus = e.getStatus();
                        Object var5_8 = null;
                        monitor.done();
                        return iStatus;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        Object var5_9 = null;
                        monitor.done();
                        return iStatus;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var5_11 = null;
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        buildJob.schedule();
    }

    protected Shell getShell() {
        return this.fShell;
    }

    public void performDefaults() {
        this.fChangedControls.clear();
        int i = 0;
        while (i < this.fFlagControls.size()) {
            boolean hasChange = false;
            Control control = (Control)this.fFlagControls.get(i);
            String flagId = (String)control.getData();
            if (control instanceof Combo) {
                hasChange = this.project != null ? CompilerFlags.getFlag((IProject)this.project, (String)flagId) != CompilerFlags.getDefaultFlag((String)flagId) : ((Combo)control).getSelectionIndex() != CompilerFlags.getDefaultFlag((String)flagId);
                ((Combo)control).select(CompilerFlags.getDefaultFlag((String)flagId));
            } else if (control instanceof Button) {
                hasChange = this.project != null ? CompilerFlags.getBoolean((IProject)this.project, (String)flagId) != CompilerFlags.getDefaultBoolean((String)flagId) : ((Button)control).getSelection() != CompilerFlags.getDefaultBoolean((String)flagId);
                ((Button)control).setSelection(CompilerFlags.getDefaultBoolean((String)flagId));
            } else if (control instanceof Text) {
                hasChange = this.project != null ? !CompilerFlags.getString((IProject)this.project, (String)flagId).equals(CompilerFlags.getDefaultString((String)flagId)) : ((Text)control).getText() != CompilerFlags.getDefaultString((String)flagId);
                ((Text)control).setText(CompilerFlags.getDefaultString((String)flagId));
            }
            if (hasChange) {
                this.fChangedControls.add(control);
            }
            ++i;
        }
    }

    public boolean performOk(boolean enabled) {
        String flagId;
        Control control;
        Iterator iter;
        HashSet<Control> changedControls = this.fChangedControls;
        if (!enabled) {
            changedControls = new HashSet<Control>();
            Iterator iter2 = this.fFlagControls.iterator();
            while (iter2.hasNext()) {
                Control control2 = (Control)iter2.next();
                String flagId2 = (String)control2.getData();
                if (CompilerFlags.getString((IProject)this.project, (String)flagId2).equals(CompilerFlags.getString(null, (String)flagId2))) continue;
                changedControls.add(control2);
                break;
            }
        }
        boolean build = false;
        if (changedControls.size() > 0) {
            String message;
            String title;
            if (this.project != null) {
                title = PDEPlugin.getResourceString("CompilersConfigurationBlock.rebuild.title");
                message = PDEPlugin.getResourceString("CompilersConfigurationBlock.rebuild.message");
            } else {
                title = PDEPlugin.getResourceString("CompilersConfigurationBlock.rebuild.many.title");
                message = PDEPlugin.getResourceString("CompilersConfigurationBlock.rebuild.many.message");
            }
            MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
            int res = dialog.open();
            if (res == 2) {
                return false;
            }
            if (res == 0) {
                build = true;
            }
        }
        if (this.project != null && enabled != CompilerFlags.getBoolean((IProject)this.project, (String)"compilers.use-project")) {
            if (enabled) {
                CompilerFlags.setBoolean((IProject)this.project, (String)"compilers.use-project", (boolean)true);
            } else {
                CompilerFlags.clear((IProject)this.project, (String)"compilers.use-project");
            }
        }
        if (changedControls.size() > 0) {
            this.fBuilders = new HashSet();
            iter = changedControls.iterator();
            while (iter.hasNext()) {
                control = (Control)iter.next();
                flagId = (String)control.getData();
                if (control instanceof Combo) {
                    int index = ((Combo)control).getSelectionIndex();
                    if (this.project == null) {
                        CompilerFlags.setFlag((String)flagId, (int)index);
                    }
                } else if (control instanceof Button) {
                    boolean value = ((Button)control).getSelection();
                    if (this.project == null) {
                        CompilerFlags.setBoolean((String)flagId, (boolean)value);
                    }
                } else if (control instanceof Text) {
                    String value = ((Text)control).getText();
                    if (this.project == null) {
                        CompilerFlags.setString((String)flagId, (String)value);
                    }
                }
                if (control.getParent().equals(this.fPluginPage)) {
                    this.fBuilders.add("org.eclipse.pde.ManifestBuilder");
                    continue;
                }
                if (control.getParent().equals(this.fSchemaPage)) {
                    this.fBuilders.add("org.eclipse.pde.SchemaBuilder");
                    continue;
                }
                if (!control.getParent().equals(this.fFeaturePage)) continue;
                this.fBuilders.add("org.eclipse.pde.FeatureBuilder");
                this.fBuilders.add("org.eclipse.pde.UpdateSiteBuilder");
            }
            if (this.project == null) {
                CompilerFlags.save();
            }
        }
        if (this.project != null) {
            iter = this.fFlagControls.iterator();
            while (iter.hasNext()) {
                control = (Control)iter.next();
                flagId = (String)control.getData();
                if (control instanceof Combo) {
                    int index = ((Combo)control).getSelectionIndex();
                    if (enabled) {
                        CompilerFlags.setFlag((IProject)this.project, (String)flagId, (int)index);
                        continue;
                    }
                    CompilerFlags.clear((IProject)this.project, (String)flagId);
                    continue;
                }
                if (control instanceof Button) {
                    boolean value = ((Button)control).getSelection();
                    if (enabled) {
                        CompilerFlags.setBoolean((IProject)this.project, (String)flagId, (boolean)value);
                        continue;
                    }
                    CompilerFlags.clear((IProject)this.project, (String)flagId);
                    continue;
                }
                if (!(control instanceof Text)) continue;
                String value = ((Text)control).getText();
                if (enabled) {
                    CompilerFlags.setString((IProject)this.project, (String)flagId, (String)value);
                    continue;
                }
                CompilerFlags.clear((IProject)this.project, (String)flagId);
            }
        }
        if (build && this.fBuilders.size() > 0) {
            this.doFullBuild();
        }
        this.fChangedControls.clear();
        return true;
    }

    protected void setShell(Shell shell) {
        this.fShell = shell;
    }
}

