/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.search.PluginSearchInput;
import org.eclipse.pde.internal.core.search.PluginSearchScope;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.BaseSearchAction;
import org.eclipse.pde.internal.ui.search.PluginSearchQuery;
import org.eclipse.search.ui.ISearchQuery;

public class FindReferencesAction
extends BaseSearchAction {
    private static final String KEY_REFERENCES = "SearchAction.references";
    private Object fSelectedObject;

    public FindReferencesAction(Object object) {
        super(PDEPlugin.getResourceString(KEY_REFERENCES));
        this.fSelectedObject = object;
    }

    protected ISearchQuery createSearchQuery() {
        PluginSearchInput input = new PluginSearchInput();
        if (this.fSelectedObject instanceof IPlugin) {
            input.setSearchElement(1);
            input.setSearchString(((IPlugin)this.fSelectedObject).getId());
        } else if (this.fSelectedObject instanceof IPluginExtensionPoint) {
            input.setSearchElement(3);
            IPluginModelBase model = ((IPluginExtensionPoint)this.fSelectedObject).getPluginModel();
            String id = model.getPluginBase().getId();
            if (id == null || id.trim().length() == 0) {
                id = "*";
            }
            input.setSearchString(String.valueOf(id) + "." + ((IPluginExtensionPoint)this.fSelectedObject).getId());
        } else if (this.fSelectedObject instanceof IPluginImport) {
            input.setSearchElement(1);
            input.setSearchString(((IPluginImport)this.fSelectedObject).getId());
        }
        input.setSearchLimit(2);
        input.setSearchScope(new PluginSearchScope());
        return new PluginSearchQuery(input);
    }
}

