/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.search.ManifestEditorOpener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter {
    protected ISearchQuery fQuery;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SearchResult(ISearchQuery query) {
        this.fQuery = query;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    public String getLabel() {
        int numMatches = this.getMatchCount();
        return String.valueOf(this.fQuery.getLabel()) + " - " + numMatches + " " + (numMatches == 1 ? PDEPlugin.getResourceString("SearchResult.match") : PDEPlugin.getResourceString("SearchResult.matches"));
    }

    public String getTooltip() {
        return null;
    }

    public ImageDescriptor getImageDescriptor() {
        return PDEPluginImages.DESC_PSEARCH_OBJ;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        if (element instanceof IPluginObject) {
            return this.isMatchContained(editor, (IPluginObject)element);
        }
        return false;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        ArrayList<Match> list = new ArrayList<Match>();
        Object[] objects = result.getElements();
        int i = 0;
        while (i < objects.length) {
            IPluginObject object;
            if (objects[i] instanceof IPluginObject && this.isMatchContained(editor, object = (IPluginObject)objects[i])) {
                Match[] matches = this.getMatches(object);
                int j = 0;
                while (j < matches.length) {
                    IDocument document = this.getDocument(editor, matches[j]);
                    if (document != null) {
                        list.add(ManifestEditorOpener.findExactMatch(document, matches[j]));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new Match[list.size()]);
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return null;
    }

    protected boolean isMatchContained(IEditorPart editor, IPluginObject object) {
        File file;
        IResource objectResource;
        IFile resource;
        IEditorInput iEditorInput = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IFile)iEditorInput.getAdapter((Class)clazz)) != null && (objectResource = object.getModel().getUnderlyingResource()) != null) {
            return resource.getProject().equals((Object)objectResource.getProject());
        }
        IEditorInput iEditorInput2 = editor.getEditorInput();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.io.File");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((file = (File)iEditorInput2.getAdapter((Class)clazz2)) != null) {
            Path path = new Path(object.getModel().getInstallLocation());
            Path filePath = null;
            filePath = "MANIFEST.MF".equals(file.getName()) ? new Path(file.getParentFile().getParent()) : (file.getName().endsWith("jar") ? new Path(file.getPath()) : new Path(file.getParent()));
            return path.equals((Object)filePath);
        }
        return false;
    }

    protected IDocument getDocument(IEditorPart editor, Match match) {
        IDocument document = null;
        if (editor instanceof ISearchEditorAccess) {
            document = ((ISearchEditorAccess)editor).getDocument(match);
        } else if (editor instanceof ITextEditor) {
            document = ((ITextEditor)editor).getDocumentProvider().getDocument((Object)editor.getEditorInput());
        }
        return document;
    }
}

