/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.actions.JavaSearchActionGroup;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.AbstractSearchResultPage;
import org.eclipse.pde.internal.ui.search.ManifestEditorOpener;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.search.dependencies.JavaEditorOpener;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.Page;

public class DependencyExtentSearchResultPage
extends AbstractSearchResultPage {
    public DependencyExtentSearchResultPage() {
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        mgr.add((IContributionItem)new Separator());
        JavaSearchActionGroup group = new JavaSearchActionGroup((Page)this);
        group.setContext(new ActionContext(this.getViewer().getSelection()));
        group.fillContextMenu(mgr);
        PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
        actionGroup.setContext(new ActionContext(this.getViewer().getSelection()));
        actionGroup.fillContextMenu(mgr);
    }

    protected void showMatch(Match match, int currentOffset, int currentLength, boolean activate) throws PartInitException {
        if (match.getElement() instanceof IPluginObject) {
            ManifestEditorOpener.open(match, activate);
        } else {
            try {
                JavaEditorOpener.open(match, currentOffset, currentLength, activate);
            }
            catch (PartInitException partInitException) {
            }
            catch (JavaModelException javaModelException) {}
        }
    }

    protected ILabelProvider createLabelProvider() {
        return new LabelProvider();
    }

    protected ViewerSorter createViewerSorter() {
        return new Sorter();
    }

    class Sorter
    extends ViewerSorter {
        Sorter() {
        }

        public int category(Object element) {
            try {
                if (element instanceof IType) {
                    if (((IType)element).isClass()) {
                        return 1;
                    }
                    return 0;
                }
            }
            catch (JavaModelException javaModelException) {}
            return 2;
        }
    }

    class LabelProvider
    extends JavaElementLabelProvider {
        LabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IPluginObject) {
                return PDEPlugin.getDefault().getLabelProvider().getImage(element);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IPluginExtensionPoint) {
                return ((IPluginExtensionPoint)element).getFullId();
            }
            if (element instanceof IPluginExtension) {
                return ((IPluginExtension)element).getPoint();
            }
            if (element instanceof IJavaElement) {
                IJavaElement javaElement = (IJavaElement)element;
                String text = String.valueOf(super.getText((Object)javaElement)) + " - " + javaElement.getAncestor(4).getElementName();
                if (!(javaElement instanceof IType)) {
                    IJavaElement ancestor = javaElement.getAncestor(7);
                    if (ancestor == null) {
                        ancestor = javaElement.getAncestor(6);
                    }
                    if (ancestor == null) {
                        ancestor = javaElement.getAncestor(5);
                    }
                    if (ancestor != null) {
                        text = String.valueOf(text) + "." + ancestor.getElementName();
                    }
                }
                return text;
            }
            return super.getText(element);
        }
    }
}

