/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.view;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.view.DependenciesLabelProvider;
import org.eclipse.pde.internal.ui.view.DependenciesView;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.help.WorkbenchHelp;

public class HistoryAction
extends Action {
    private String fElement;
    private DependenciesView fView;

    public HistoryAction(DependenciesView view, String element) {
        this.fView = view;
        this.fElement = element;
        String elementName = element.toString();
        this.setText(elementName);
        this.setImageDescriptor(this.getImageDescriptor(elementName));
        this.setDisabledImageDescriptor(PDEPluginImages.DESC_PLUGIN_OBJ);
        this.setDescription(PDEPlugin.getFormattedMessage("HistoryAction.description", elementName));
        this.setToolTipText(PDEPlugin.getFormattedMessage("HistoryAction.tooltip", elementName));
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.pde.doc.user.history_action");
    }

    private ImageDescriptor getImageDescriptor(String element) {
        DependenciesLabelProvider imageProvider = new DependenciesLabelProvider(false);
        ImageImageDescriptor desc = new ImageImageDescriptor(imageProvider.getImage(element));
        imageProvider.dispose();
        return desc;
    }

    public void run() {
        this.fView.gotoHistoryEntry(this.fElement);
    }

    public class ImageImageDescriptor
    extends ImageDescriptor {
        private Image fImage;

        public ImageImageDescriptor(Image image) {
            this.fImage = image;
        }

        public boolean equals(Object obj) {
            return obj != null && ((Object)((Object)this)).getClass().equals(obj.getClass()) && this.fImage.equals((Object)((ImageImageDescriptor)((Object)obj)).fImage);
        }

        public ImageData getImageData() {
            return this.fImage.getImageData();
        }

        public int hashCode() {
            return this.fImage.hashCode();
        }
    }
}

