/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.pde.internal.ui.elements.ElementLabelProvider;
import org.eclipse.pde.internal.ui.elements.ListContentProvider;
import org.eclipse.pde.internal.ui.elements.TreeContentProvider;
import org.eclipse.pde.internal.ui.wizards.BaseWizardSelectionPage;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionSorter;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;

public abstract class WizardTreeSelectionPage
extends BaseWizardSelectionPage
implements ISelectionChangedListener {
    private TreeViewer categoryTreeViewer;
    private String baseCategory;
    protected TableViewer wizardSelectionViewer;
    private WizardCollectionElement wizardCategories;

    public WizardTreeSelectionPage(WizardCollectionElement categories, String baseCategory, String message) {
        super("NewExtension", message);
        this.wizardCategories = categories;
        this.baseCategory = baseCategory;
    }

    public void advanceToNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        FillLayout flayout = new FillLayout();
        flayout.marginWidth = 5;
        flayout.marginHeight = 5;
        container.setLayout((Layout)flayout);
        SashForm rootSash = new SashForm(container, 512);
        SashForm outerSash = new SashForm((Composite)rootSash, 256);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        Tree tree = new Tree((Composite)outerSash, 2048);
        this.categoryTreeViewer = new TreeViewer(tree);
        this.categoryTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.categoryTreeViewer.setLabelProvider((IBaseLabelProvider)ElementLabelProvider.INSTANCE);
        this.categoryTreeViewer.setSorter((ViewerSorter)new WizardCollectionSorter(this.baseCategory));
        this.categoryTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Table table = new Table((Composite)outerSash, 2048);
        new TableColumn(table, 0);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)tlayout);
        this.wizardSelectionViewer = new TableViewer(table);
        this.wizardSelectionViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)ListUtil.TABLE_LABEL_PROVIDER);
        this.wizardSelectionViewer.setSorter(ListUtil.NAME_SORTER);
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.wizardSelectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                BusyIndicator.showWhile((Display)WizardTreeSelectionPage.this.wizardSelectionViewer.getControl().getDisplay(), (Runnable)new Runnable(this){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        1.access$0(this.this$1).selectionChanged(new SelectionChangedEvent((ISelectionProvider)1.access$0(this.this$1).wizardSelectionViewer, 1.access$0(this.this$1).wizardSelectionViewer.getSelection()));
                        1.access$0(this.this$1).advanceToNextPage();
                    }
                });
            }

            static /* synthetic */ WizardTreeSelectionPage access$0(1 var0) {
                return var0.WizardTreeSelectionPage.this;
            }
        });
        Composite descriptionComposite = new Composite((Composite)rootSash, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        descriptionComposite.setLayout((Layout)layout);
        this.createDescriptionIn(descriptionComposite);
        this.initializeViewers();
        rootSash.setWeights(new int[]{70, 30});
        this.setControl((Control)container);
    }

    protected Object getSingleSelection(IStructuredSelection selection) {
        Object selectedObject = selection.getFirstElement();
        if (selection.size() > 1) {
            selectedObject = null;
        }
        return selectedObject;
    }

    private void handleCategorySelection(SelectionChangedEvent selectionEvent) {
        this.setErrorMessage(null);
        this.setDescriptionText("");
        this.setSelectedNode(null);
        WizardCollectionElement selectedCategory = (WizardCollectionElement)this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection());
        if (selectedCategory == null) {
            this.wizardSelectionViewer.setInput(null);
        } else {
            this.wizardSelectionViewer.setInput((Object)selectedCategory.getWizards());
        }
    }

    private void handleWizardSelection(SelectionChangedEvent selectionEvent) {
        this.setErrorMessage(null);
        WizardElement currentSelection = (WizardElement)this.getSingleSelection((IStructuredSelection)selectionEvent.getSelection());
        if (currentSelection == null) {
            this.setDescriptionText("");
            this.setSelectedNode(null);
            return;
        }
        WizardElement finalSelection = currentSelection;
        this.setSelectedNode(this.createWizardNode(finalSelection));
        this.setDescriptionText(finalSelection.getDescription());
    }

    protected void initializeViewers() {
        this.categoryTreeViewer.setInput((Object)this.wizardCategories);
        this.wizardSelectionViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.categoryTreeViewer.getTree().setFocus();
    }

    public void selectionChanged(SelectionChangedEvent selectionEvent) {
        if (selectionEvent.getSelectionProvider().equals(this.categoryTreeViewer)) {
            this.handleCategorySelection(selectionEvent);
        } else {
            this.handleWizardSelection(selectionEvent);
        }
    }

    public void setSelectedNode(IWizardNode node) {
        super.setSelectedNode(node);
    }
}

