/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import java.util.StringTokenizer;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.plugin.AbstractFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.ui.IFieldData;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public abstract class ContentPage
extends WizardPage {
    protected boolean fInitialized = false;
    protected Text fIdText;
    protected Text fVersionText;
    protected Text fNameText;
    protected Text fProviderText;
    protected Text fPluginIdText;
    protected Text fPluginVersion;
    protected Combo fMatchCombo;
    protected AbstractFieldData fData;
    protected IProjectProvider fProjectProvider;
    protected Label fLibraryLabel;
    protected Text fLibraryText;
    protected static final int PROPERTIES_GROUP = 1;
    protected static final int P_CLASS_GROUP = 2;
    protected int fChangedGroups = 0;
    protected ModifyListener listener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            ContentPage.this.validatePage();
        }
    };
    protected ModifyListener propertiesListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (ContentPage.this.fInitialized) {
                ContentPage.this.fChangedGroups |= 1;
            }
            ContentPage.this.validatePage();
        }
    };
    protected static final String KEY_MATCH_PERFECT = "ManifestEditor.MatchSection.perfect";
    protected static final String KEY_MATCH_EQUIVALENT = "ManifestEditor.MatchSection.equivalent";
    protected static final String KEY_MATCH_COMPATIBLE = "ManifestEditor.MatchSection.compatible";
    protected static final String KEY_MATCH_GREATER = "ManifestEditor.MatchSection.greater";
    protected Text fClassText;
    protected Button fGenerateClass;
    protected Button fUIPlugin;
    protected Label fClassLabel;
    protected NewProjectCreationPage fMainPage;

    public ContentPage(String pageName, IProjectProvider provider, NewProjectCreationPage page, AbstractFieldData data) {
        super(pageName);
        this.fMainPage = page;
        this.fProjectProvider = provider;
        this.fData = data;
    }

    protected Text createText(Composite parent, ModifyListener listener) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.addModifyListener(listener);
        return text;
    }

    protected abstract void validatePage();

    protected String validateProperties() {
        String errorMessage = this.validateId();
        if (errorMessage != null) {
            return errorMessage;
        }
        if (this.fVersionText.getText().trim().length() == 0) {
            errorMessage = PDEPlugin.getResourceString("ContentPage.noversion");
        } else if (!this.isVersionValid(this.fVersionText.getText().trim())) {
            errorMessage = PDEPlugin.getResourceString("ContentPage.badversion");
        } else if (this.fNameText.getText().trim().length() == 0) {
            errorMessage = PDEPlugin.getResourceString("ContentPage.noname");
        }
        if (errorMessage != null) {
            return errorMessage;
        }
        if (!this.fData.isSimple() && this.fLibraryText.getText().trim().length() == 0) {
            errorMessage = PDEPlugin.getResourceString("ProjectStructurePage.noLibrary");
        }
        return errorMessage;
    }

    private String validateId() {
        String id = this.fIdText.getText().trim();
        if (id.length() == 0) {
            return PDEPlugin.getResourceString("ContentPage.noid");
        }
        int i = 0;
        while (i < id.length()) {
            if (!id.substring(i, i + 1).matches("[a-zA-Z0-9\\._]")) {
                return PDEPlugin.getResourceString("ContentPage.invalidId");
            }
            ++i;
        }
        return null;
    }

    protected boolean isVersionValid(String version) {
        try {
            new PluginVersionIdentifier(version);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public IWizardPage getNextPage() {
        this.updateData();
        return super.getNextPage();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.fLibraryLabel.setEnabled(!this.fData.isSimple());
            this.fLibraryText.setEnabled(!this.fData.isSimple());
            String id = this.computeId();
            if ((this.fChangedGroups & 1) == 0) {
                int oldfChanged = this.fChangedGroups;
                this.fIdText.setText(id);
                this.fVersionText.setText("1.0.0");
                this.presetNameField(id);
                this.presetProviderField(id);
                this.presetLibraryField(id);
                this.fChangedGroups = oldfChanged;
            }
            if (this.fInitialized) {
                this.validatePage();
            } else {
                this.fInitialized = true;
            }
        }
        super.setVisible(visible);
    }

    protected String computeId() {
        return this.fProjectProvider.getProjectName().replaceAll("[^a-zA-Z0-9\\._]", "_");
    }

    private void presetLibraryField(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            this.fLibraryText.setText(String.valueOf(token) + ".jar");
        }
    }

    private void presetNameField(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (tok.hasMoreTokens()) continue;
            this.fNameText.setText(String.valueOf(Character.toUpperCase(token.charAt(0))) + (token.length() > 1 ? token.substring(1) : "") + " " + this.getNameFieldQualifier());
        }
    }

    protected abstract String getNameFieldQualifier();

    private void presetProviderField(String id) {
        StringTokenizer tok = new StringTokenizer(id, ".");
        int count = tok.countTokens();
        if (count > 2 && tok.nextToken().equals("com")) {
            this.fProviderText.setText(tok.nextToken().toUpperCase());
        }
    }

    public void updateData() {
        this.fData.setId(this.fIdText.getText().trim());
        this.fData.setVersion(this.fVersionText.getText().trim());
        this.fData.setName(this.fNameText.getText().trim());
        this.fData.setProvider(this.fProviderText.getText().trim());
        if (!this.fData.isSimple()) {
            String library = this.fLibraryText.getText().trim();
            if (!(library.endsWith(".jar") || library.endsWith("/") || library.equals("."))) {
                library = String.valueOf(library) + "/";
            }
            this.fData.setLibraryName(library);
        }
    }

    public IFieldData getData() {
        return this.fData;
    }

    public String getId() {
        return this.fIdText.getText().trim();
    }
}

